#!/bin/bash

if (($# < 2)); then
    echo "-----------------------------------------------------------------------------------------------------"
    echo "--- Usage:"
    echo "---   sh update_metadata.sh <admin-username> <admin-password>"
    echo "--- Example: "
    echo "---   The script creates required AtScale types in Collibra"
    echo "-----------------------------------------------------------------------------------------------------"
    exit 1
fi

#Assigning variables
userid="${1}"
userpw="${2}"

setup_url="http://localhost:8081/api/setup"
echo "Executing setup using url $setup_url"
curl -u "$userid:$userpw" -X POST "$setup_url"

sync_url="http://localhost:8081/api/sync"
echo "Executing initial sync using url $sync_url"
curl -u "$sync_url:$sync_url" -X GET "$sync_url"

echo "Finished updating AtScale metadata for Collibra"
