@rem
@rem Copyright 2015 the original author or authors.
@rem
@rem Licensed under the Apache License, Version 2.0 (the "License");
@rem you may not use this file except in compliance with the License.
@rem You may obtain a copy of the License at
@rem
@rem      https://www.apache.org/licenses/LICENSE-2.0
@rem
@rem Unless required by applicable law or agreed to in writing, software
@rem distributed under the License is distributed on an "AS IS" BASIS,
@rem WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
@rem See the License for the specific language governing permissions and
@rem limitations under the License.
@rem
@rem SPDX-License-Identifier: Apache-2.0
@rem

@if "%DEBUG%"=="" @echo off
@rem ##########################################################################
@rem
@rem  atscale-to-collibra-integration startup script for Windows
@rem
@rem ##########################################################################

@rem Set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" setlocal

set DIRNAME=%~dp0
if "%DIRNAME%"=="" set DIRNAME=.
@rem This is normally unused
set APP_BASE_NAME=%~n0
set APP_HOME=%DIRNAME%..

@rem Resolve any "." and ".." in APP_HOME to make it shorter.
for %%i in ("%APP_HOME%") do set APP_HOME=%%~fi

@rem Add default JVM options here. You can also use JAVA_OPTS and ATSCALE_TO_COLLIBRA_INTEGRATION_OPTS to pass JVM options to this script.
set DEFAULT_JVM_OPTS=

@rem Find java.exe
if defined JAVA_HOME goto findJavaFromJavaHome

set JAVA_EXE=java.exe
%JAVA_EXE% -version >NUL 2>&1
if %ERRORLEVEL% equ 0 goto execute

echo. 1>&2
echo ERROR: JAVA_HOME is not set and no 'java' command could be found in your PATH. 1>&2
echo. 1>&2
echo Please set the JAVA_HOME variable in your environment to match the 1>&2
echo location of your Java installation. 1>&2

goto fail

:findJavaFromJavaHome
set JAVA_HOME=%JAVA_HOME:"=%
set JAVA_EXE=%JAVA_HOME%/bin/java.exe

if exist "%JAVA_EXE%" goto execute

echo. 1>&2
echo ERROR: JAVA_HOME is set to an invalid directory: %JAVA_HOME% 1>&2
echo. 1>&2
echo Please set the JAVA_HOME variable in your environment to match the 1>&2
echo location of your Java installation. 1>&2

goto fail

:execute
@rem Setup the command line

set CLASSPATH=%APP_HOME%\lib\atscale-to-collibra-integration-1.0.0-plain.jar;%APP_HOME%\lib\commons-lang3-3.12.0.jar;%APP_HOME%\lib\feign-jackson-10.12.jar;%APP_HOME%\lib\feign-okhttp-10.12.jar;%APP_HOME%\lib\feign-slf4j-10.12.jar;%APP_HOME%\lib\feign-core-10.12.jar;%APP_HOME%\lib\feign-form-3.8.0.jar;%APP_HOME%\lib\guava-31.1-jre.jar;%APP_HOME%\lib\jsr305-3.0.2.jar;%APP_HOME%\lib\jackson-databind-nullable-0.2.6.jar;%APP_HOME%\lib\scribejava-core-8.0.0.jar;%APP_HOME%\lib\spring-boot-starter-actuator-3.3.5.jar;%APP_HOME%\lib\spring-boot-actuator-autoconfigure-3.3.5.jar;%APP_HOME%\lib\spring-boot-starter-web-3.3.5.jar;%APP_HOME%\lib\spring-boot-starter-json-3.3.5.jar;%APP_HOME%\lib\jackson-datatype-jdk8-2.17.2.jar;%APP_HOME%\lib\jackson-module-parameter-names-2.17.2.jar;%APP_HOME%\lib\jackson-core-2.17.2.jar;%APP_HOME%\lib\jackson-datatype-jsr310-2.17.2.jar;%APP_HOME%\lib\jackson-databind-2.17.2.jar;%APP_HOME%\lib\jackson-annotations-2.17.2.jar;%APP_HOME%\lib\spring-boot-starter-security-3.3.5.jar;%APP_HOME%\lib\spring-boot-starter-3.3.5.jar;%APP_HOME%\lib\spring-boot-starter-tomcat-3.3.5.jar;%APP_HOME%\lib\jakarta.annotation-api-2.1.1.jar;%APP_HOME%\lib\jasypt-spring-boot-starter-3.0.5.jar;%APP_HOME%\lib\jasypt-spring-boot-3.0.5.jar;%APP_HOME%\lib\json-simple-1.1.1.jar;%APP_HOME%\lib\log4s_3-1.10.0.jar;%APP_HOME%\lib\lombok-1.18.22.jar;%APP_HOME%\lib\migbase64-2.2.jar;%APP_HOME%\lib\spring-webflux-6.1.14.jar;%APP_HOME%\lib\reactor-core-3.6.11.jar;%APP_HOME%\lib\scala3-library_3-3.6.3.jar;%APP_HOME%\lib\spring-security-config-6.3.4.jar;%APP_HOME%\lib\spring-security-web-6.3.4.jar;%APP_HOME%\lib\spring-security-core-6.3.4.jar;%APP_HOME%\lib\swagger-annotations-1.6.11.jar;%APP_HOME%\lib\unirest-java-1.4.9.jar;%APP_HOME%\lib\spring-boot-starter-logging-3.3.5.jar;%APP_HOME%\lib\logback-classic-1.5.11.jar;%APP_HOME%\lib\log4j-to-slf4j-2.23.1.jar;%APP_HOME%\lib\jul-to-slf4j-2.0.16.jar;%APP_HOME%\lib\slf4j-api-2.0.16.jar;%APP_HOME%\lib\okhttp-4.6.0.jar;%APP_HOME%\lib\failureaccess-1.0.1.jar;%APP_HOME%\lib\listenablefuture-9999.0-empty-to-avoid-conflict-with-guava.jar;%APP_HOME%\lib\checker-qual-3.12.0.jar;%APP_HOME%\lib\error_prone_annotations-2.11.0.jar;%APP_HOME%\lib\j2objc-annotations-1.3.jar;%APP_HOME%\lib\jasypt-1.9.3.jar;%APP_HOME%\lib\junit-4.10.jar;%APP_HOME%\lib\reactive-streams-1.0.4.jar;%APP_HOME%\lib\scala-library-2.13.15.jar;%APP_HOME%\lib\spring-boot-autoconfigure-3.3.5.jar;%APP_HOME%\lib\spring-boot-actuator-3.3.5.jar;%APP_HOME%\lib\spring-boot-3.3.5.jar;%APP_HOME%\lib\spring-webmvc-6.1.14.jar;%APP_HOME%\lib\spring-context-6.1.14.jar;%APP_HOME%\lib\spring-aop-6.1.14.jar;%APP_HOME%\lib\spring-web-6.1.14.jar;%APP_HOME%\lib\spring-beans-6.1.14.jar;%APP_HOME%\lib\spring-expression-6.1.14.jar;%APP_HOME%\lib\spring-core-6.1.14.jar;%APP_HOME%\lib\snakeyaml-2.2.jar;%APP_HOME%\lib\micrometer-jakarta9-1.13.6.jar;%APP_HOME%\lib\micrometer-core-1.13.6.jar;%APP_HOME%\lib\micrometer-observation-1.13.6.jar;%APP_HOME%\lib\spring-security-crypto-6.3.4.jar;%APP_HOME%\lib\httpasyncclient-4.1.1.jar;%APP_HOME%\lib\httpmime-4.5.2.jar;%APP_HOME%\lib\httpclient-4.5.2.jar;%APP_HOME%\lib\json-20160212.jar;%APP_HOME%\lib\okio-jvm-2.6.0.jar;%APP_HOME%\lib\kotlin-stdlib-1.3.71.jar;%APP_HOME%\lib\hamcrest-core-1.1.jar;%APP_HOME%\lib\spring-jcl-6.1.14.jar;%APP_HOME%\lib\micrometer-commons-1.13.6.jar;%APP_HOME%\lib\tomcat-embed-websocket-10.1.31.jar;%APP_HOME%\lib\tomcat-embed-core-10.1.31.jar;%APP_HOME%\lib\tomcat-embed-el-10.1.31.jar;%APP_HOME%\lib\httpcore-nio-4.4.4.jar;%APP_HOME%\lib\httpcore-4.4.4.jar;%APP_HOME%\lib\commons-logging-1.2.jar;%APP_HOME%\lib\commons-codec-1.9.jar;%APP_HOME%\lib\kotlin-stdlib-common-1.3.71.jar;%APP_HOME%\lib\annotations-13.0.jar;%APP_HOME%\lib\logback-core-1.5.11.jar;%APP_HOME%\lib\log4j-api-2.23.1.jar;%APP_HOME%\lib\HdrHistogram-2.2.2.jar;%APP_HOME%\lib\LatencyUtils-2.0.3.jar


@rem Execute atscale-to-collibra-integration
"%JAVA_EXE%" %DEFAULT_JVM_OPTS% %JAVA_OPTS% %ATSCALE_TO_COLLIBRA_INTEGRATION_OPTS%  -classpath "%CLASSPATH%" com.collibra.marketplace.atscale.Application %*

:end
@rem End local scope for the variables with windows NT shell
if %ERRORLEVEL% equ 0 goto mainEnd

:fail
rem Set variable ATSCALE_TO_COLLIBRA_INTEGRATION_EXIT_CONSOLE if you need the _script_ return code instead of
rem the _cmd.exe /c_ return code!
set EXIT_CODE=%ERRORLEVEL%
if %EXIT_CODE% equ 0 set EXIT_CODE=1
if not ""=="%ATSCALE_TO_COLLIBRA_INTEGRATION_EXIT_CONSOLE%" exit %EXIT_CODE%
exit /b %EXIT_CODE%

:mainEnd
if "%OS%"=="Windows_NT" endlocal

:omega
