/*
 * Decompiled with CFR 0.152.
 */
package com.collibra.marketplace.atscale.transformer;

import com.collibra.core.rest.client.model.AssetTypeImpl;
import com.collibra.core.rest.client.model.AttributeType;
import com.collibra.core.rest.client.model.RelationTypeImpl;
import com.collibra.importer.rest.client.model.AssetIdentifier;
import com.collibra.importer.rest.client.model.AssetImportCommand;
import com.collibra.importer.rest.client.model.AssetTypeIdentifier;
import com.collibra.importer.rest.client.model.AttributeValue;
import com.collibra.importer.rest.client.model.DomainIdentifier;
import com.collibra.marketplace.atscale.AssetFormatConstants$;
import com.collibra.marketplace.atscale.config.CollibraConstants$;
import com.collibra.marketplace.atscale.helpers.AssetNameHelpers$;
import com.collibra.marketplace.atscale.model.Column;
import com.collibra.marketplace.atscale.model.ConnectionGroup;
import com.collibra.marketplace.atscale.model.Dataset;
import com.collibra.marketplace.atscale.store.AtscaleAssetType;
import com.collibra.marketplace.atscale.store.AtscaleAttributeType$;
import com.collibra.marketplace.atscale.store.AtscaleRelationType;
import com.collibra.marketplace.atscale.transformer.package;
import com.collibra.marketplace.atscale.transformer.package$TransformContext$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function1;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class package$
implements Serializable {
    private static final String COLUMN_S;
    private static final String FOLDER;
    private static final String ATSCALE_DATASETS;
    public static final package$TransformContext$ TransformContext;
    public static final package$ MODULE$;

    private package$() {
    }

    static {
        MODULE$ = new package$();
        COLUMN_S = "column(s)";
        FOLDER = "folder";
        ATSCALE_DATASETS = "AtScale datasets";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(package$.class);
    }

    public String COLUMN_S() {
        return COLUMN_S;
    }

    public String FOLDER() {
        return FOLDER;
    }

    public String ATSCALE_DATASETS() {
        return ATSCALE_DATASETS;
    }

    public AssetImportCommand newAssetImportCommand() {
        AssetImportCommand cmd = new AssetImportCommand();
        cmd.setResourceType("Asset");
        return cmd;
    }

    public AssetImportCommand withAssetName(AssetImportCommand cmd, String assetName, package.TransformContext ctx) {
        cmd.setName(assetName);
        return cmd;
    }

    public AssetImportCommand withDisplayName(AssetImportCommand cmd, String displayName, package.TransformContext ctx) {
        cmd.setDisplayName(displayName);
        return cmd;
    }

    public AssetImportCommand withAssetType(AssetImportCommand cmd, AtscaleAssetType assetType, package.TransformContext ctx) {
        AssetTypeIdentifier identifier = new AssetTypeIdentifier();
        identifier.setId(((AssetTypeImpl)ctx.collibraData().assetTypesByName().apply((Object)assetType.name())).getId());
        cmd.setType(identifier);
        return cmd;
    }

    public AssetImportCommand withBusinessAssetDomain(AssetImportCommand cmd, package.TransformContext ctx) {
        cmd.setDomain(this.getBusinessAssetDomainIdentifier(cmd, ctx));
        return cmd;
    }

    public AssetImportCommand withDataAssetDomain(AssetImportCommand cmd, package.TransformContext ctx) {
        cmd.setDomain(this.getDataAssetDomainIdentifier(cmd, ctx));
        return cmd;
    }

    public AssetImportCommand addAttributeNote(AssetImportCommand cmd, String note, package.TransformContext ctx) {
        return this.addAttribute(cmd, CollibraConstants$.MODULE$.AttributeTypeNoteId(), note, ctx);
    }

    public AssetImportCommand addAttributeIdentifier(AssetImportCommand cmd, String value, package.TransformContext ctx) {
        String identifierKey = ((AttributeType)ctx.collibraData().attributeTypesByName().apply((Object)AtscaleAttributeType$.IDENTIFIER.name())).getId().toString();
        return this.addAttribute(cmd, identifierKey, value, ctx);
    }

    public AssetImportCommand addAttribute(AssetImportCommand cmd, String key, String value, package.TransformContext ctx) {
        if (cmd.getAttributes().containsKey(key)) {
            cmd.getAttributes().get(key).add(this.createAttributeValue(cmd, value, ctx));
            return cmd;
        }
        return cmd.putAttributesItem(key, this.createAttributeValues(cmd, (scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{value}), ctx));
    }

    public AssetImportCommand addBusinessAssetDomainRelation(AssetImportCommand cmd, AtscaleRelationType relationType, String direction, scala.collection.immutable.Seq<String> relationNames, package.TransformContext ctx) {
        return this.addAssetDomainRelation(cmd, relationType, direction, this.getBusinessAssetDomainIdentifier(cmd, ctx), relationNames, ctx);
    }

    public DomainIdentifier getBusinessAssetDomainIdentifier(AssetImportCommand cmd, package.TransformContext ctx) {
        DomainIdentifier domainIdentifier = new DomainIdentifier();
        domainIdentifier.setId(ctx.collibraData().businessAssetDomain().getId());
        return domainIdentifier;
    }

    public DomainIdentifier getDataAssetDomainIdentifier(AssetImportCommand cmd, package.TransformContext ctx) {
        DomainIdentifier domainIdentifier = new DomainIdentifier();
        domainIdentifier.setId(ctx.collibraData().dataAssetDomain().getId());
        return domainIdentifier;
    }

    public AssetImportCommand addAssetDomainRelation(AssetImportCommand cmd, AtscaleRelationType relationType, String direction, DomainIdentifier domain, scala.collection.immutable.Seq<String> relationNames, package.TransformContext ctx) {
        String relationId = ((RelationTypeImpl)ctx.collibraData().relationTypes().apply((Object)relationType)).getId().toString() + ":" + direction;
        AssetIdentifier ident = new AssetIdentifier();
        ident.setName(AssetNameHelpers$.MODULE$.prepareAssetName(relationNames));
        ident.setDomain(domain);
        AssetIdentifier identifier = ident;
        if (cmd.getRelations().containsKey(relationId)) {
            scala.collection.immutable.Seq existingRelations = CollectionConverters$.MODULE$.ListHasAsScala(cmd.getRelations().get(relationId)).asScala().toSeq();
            return cmd.putRelationsItem(relationId, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)existingRelations.$colon$plus((Object)identifier)).asJava());
        }
        return cmd.putRelationsItem(relationId, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((SeqOps)new .colon.colon((Object)identifier, (List)Nil$.MODULE$))).asJava());
    }

    public AssetImportCommand addDataAssetDomainRelation(AssetImportCommand cmd, AtscaleRelationType relationType, String direction, scala.collection.immutable.Seq<String> relationNames, package.TransformContext ctx) {
        return this.addAssetDomainRelation(cmd, relationType, direction, this.getDataAssetDomainIdentifier(cmd, ctx), relationNames, ctx);
    }

    public AttributeValue createAttributeValue(AssetImportCommand cmd, String value, package.TransformContext ctx) {
        AttributeValue av = new AttributeValue();
        av.setValues(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((SeqOps)new .colon.colon((Object)((String)Option$.MODULE$.apply((Object)value).getOrElse(package$::createAttributeValue$$anonfun$1)), (List)Nil$.MODULE$))).asJava());
        return av;
    }

    public java.util.List<AttributeValue> createAttributeValues(AssetImportCommand cmd, scala.collection.immutable.Seq<String> value, package.TransformContext ctx) {
        AttributeValue av = new AttributeValue();
        av.setValues(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)value.map((Function1 & Serializable)v -> (String)Option$.MODULE$.apply(v).getOrElse(package$::createAttributeValues$$anonfun$1$$anonfun$1))).asJava());
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((SeqOps)new .colon.colon((Object)av, (List)Nil$.MODULE$))).asJava();
    }

    public String toColumnUniqueName(scala.collection.immutable.Seq<Dataset> allDatasets, String datasetName, String columnName) {
        return (String)allDatasets.collectFirst((PartialFunction)new Serializable(datasetName, columnName){
            private final String datasetName$1;
            private final String columnName$1;
            {
                this.datasetName$1 = datasetName$5;
                this.columnName$1 = columnName$2;
            }

            public final boolean isDefinedAt(Dataset x) {
                Dataset dataset;
                Dataset ds = dataset = x;
                String string = ds.datasetName();
                String string2 = this.datasetName$1;
                return !(string != null ? !string.equals(string2) : string2 != null) && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(ds.table()));
            }

            public final Object applyOrElse(Dataset x, Function1 function1) {
                Dataset dataset;
                Dataset ds = dataset = x;
                String string = ds.datasetName();
                String string2 = this.datasetName$1;
                if (!(string != null ? !string.equals(string2) : string2 != null) && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(ds.table()))) {
                    if (ds.database().isEmpty()) {
                        return AssetNameHelpers$.MODULE$.prepareAssetName((scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)((SeqOps)new .colon.colon((Object)ds.schema(), (List)new .colon.colon((Object)ds.table(), (List)new .colon.colon((Object)this.columnName$1, (List)Nil$.MODULE$))))));
                    }
                    return AssetNameHelpers$.MODULE$.prepareAssetName((scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)((SeqOps)new .colon.colon((Object)(ds.database() + AssetFormatConstants$.MODULE$.ASSET_NAME_SEPARATOR() + ds.schema()), (List)new .colon.colon((Object)ds.table(), (List)new .colon.colon((Object)this.columnName$1, (List)Nil$.MODULE$))))));
                }
                return function1.apply((Object)x);
            }
        }).getOrElse(package$::toColumnUniqueName$$anonfun$1);
    }

    public boolean datasetIsTable(scala.collection.immutable.Seq<Dataset> allDatasets, String datasetName) {
        return allDatasets.find((Function1 & Serializable)ds -> {
            String string = ds.datasetName();
            String string2 = datasetName;
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).exists((Function1 & Serializable)_$1 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$1.table())));
    }

    public String toDatabaseSchema(scala.collection.immutable.Seq<Dataset> allDatasets, scala.collection.immutable.Seq<ConnectionGroup> allConnectionGroups, String datasetName) {
        Function1 & Serializable correctDataset = (Function1 & Serializable)dataset -> {
            String string = dataset.datasetName();
            String string2 = datasetName;
            return !(string != null ? !string.equals(string2) : string2 != null);
        };
        Function1 & Serializable hasTable = (Function1 & Serializable)dataset -> dataset.table() != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(dataset.table()));
        return (String)allDatasets.collectFirst((PartialFunction)new Serializable(correctDataset, hasTable, allConnectionGroups){
            private final Function1 correctDataset$1;
            private final Function1 hasTable$1;
            private final scala.collection.immutable.Seq allConnectionGroups$1;
            {
                this.correctDataset$1 = correctDataset$2;
                this.hasTable$1 = hasTable$2;
                this.allConnectionGroups$1 = allConnectionGroups$2;
            }

            public final boolean isDefinedAt(Dataset x) {
                Dataset dataset = x;
                Dataset ds = dataset;
                if (BoxesRunTime.unboxToBoolean((Object)this.correctDataset$1.apply((Object)ds)) && !BoxesRunTime.unboxToBoolean((Object)this.hasTable$1.apply((Object)ds))) {
                    return true;
                }
                Dataset ds2 = dataset;
                if (BoxesRunTime.unboxToBoolean((Object)this.correctDataset$1.apply((Object)ds2)) && ds2.database() != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(ds2.database()))) {
                    return true;
                }
                Dataset ds3 = dataset;
                return BoxesRunTime.unboxToBoolean((Object)this.correctDataset$1.apply((Object)ds3));
            }

            public final Object applyOrElse(Dataset x, Function1 function1) {
                Dataset dataset = x;
                Dataset ds = dataset;
                if (BoxesRunTime.unboxToBoolean((Object)this.correctDataset$1.apply((Object)ds)) && !BoxesRunTime.unboxToBoolean((Object)this.hasTable$1.apply((Object)ds))) {
                    return "";
                }
                Dataset ds2 = dataset;
                if (BoxesRunTime.unboxToBoolean((Object)this.correctDataset$1.apply((Object)ds2)) && ds2.database() != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(ds2.database()))) {
                    return ds2.database() + AssetFormatConstants$.MODULE$.ASSET_NAME_SEPARATOR() + ds2.schema();
                }
                Dataset ds3 = dataset;
                if (BoxesRunTime.unboxToBoolean((Object)this.correctDataset$1.apply((Object)ds3))) {
                    return this.allConnectionGroups$1.collectFirst((PartialFunction)new Serializable(ds3){
                        private final Dataset ds$1;
                        {
                            this.ds$1 = ds$3;
                        }

                        public final boolean isDefinedAt(ConnectionGroup x) {
                            ConnectionGroup connectionGroup;
                            ConnectionGroup cg = connectionGroup = x;
                            String string = cg.connectionId();
                            String string2 = this.ds$1.connection();
                            return !(string != null ? !string.equals(string2) : string2 != null);
                        }

                        public final Object applyOrElse(ConnectionGroup x, Function1 function1) {
                            ConnectionGroup connectionGroup;
                            ConnectionGroup cg = connectionGroup = x;
                            String string = cg.connectionId();
                            String string2 = this.ds$1.connection();
                            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                return cg.database() + AssetFormatConstants$.MODULE$.ASSET_NAME_SEPARATOR() + this.ds$1.schema();
                            }
                            return function1.apply((Object)x);
                        }
                    }).getOrElse(() -> package$.com$collibra$marketplace$atscale$transformer$package$$anon$2$$_$applyOrElse$$anonfun$1(ds3));
                }
                return function1.apply((Object)x);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{com$collibra$marketplace$atscale$transformer$package$$anon$2$$_$applyOrElse$$anonfun$1(com.collibra.marketplace.atscale.model.Dataset )}, serializedLambda);
            }
        }).getOrElse(package$::toDatabaseSchema$$anonfun$1);
    }

    public String toTableName(scala.collection.immutable.Seq<Dataset> allDatasets, String datasetName) {
        return (String)allDatasets.find((Function1 & Serializable)ds -> {
            String string = ds.datasetName();
            String string2 = datasetName;
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).map((Function1 & Serializable)_$2 -> _$2.table()).getOrElse(package$::toTableName$$anonfun$3);
    }

    public boolean foundInDatasets(String projectName, String dsName, scala.collection.immutable.Seq<Dataset> datasetList) {
        return datasetList.exists((Function1 & Serializable)ds -> {
            String string = ds.datasetName();
            String string2 = dsName;
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = ds.catalogName();
            String string4 = projectName;
            if (string3 == null) {
                if (string4 == null) return true;
                return false;
            } else {
                if (!string3.equals(string4)) return false;
                return true;
            }
        });
    }

    public boolean isCalculatedCol(scala.collection.immutable.Seq<Column> columns, String colName) {
        return columns.find((Function1 & Serializable)_$3 -> {
            String string = _$3.columnName();
            String string2 = colName;
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).exists((Function1 & Serializable)_$4 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$4.expression())));
    }

    private static final String createAttributeValue$$anonfun$1() {
        return "";
    }

    private static final String createAttributeValues$$anonfun$1$$anonfun$1() {
        return "";
    }

    private static final String toColumnUniqueName$$anonfun$1() {
        return "";
    }

    public static final String com$collibra$marketplace$atscale$transformer$package$$anon$2$$_$applyOrElse$$anonfun$1(Dataset ds$2) {
        return ds$2.schema();
    }

    private static final String toDatabaseSchema$$anonfun$1() {
        return "";
    }

    private static final String toTableName$$anonfun$3() {
        return "";
    }
}

