/*
 * Decompiled with CFR 0.152.
 */
package com.collibra.marketplace.atscale.transformer;

import com.collibra.core.rest.client.model.AssetTypeImpl;
import com.collibra.importer.rest.client.model.AssetImportCommand;
import com.collibra.importer.rest.client.model.DomainIdentifier;
import com.collibra.marketplace.atscale.AssetFormatConstants$;
import com.collibra.marketplace.atscale.config.CollibraConstants$;
import com.collibra.marketplace.atscale.helpers.AssetNameHelpers$;
import com.collibra.marketplace.atscale.model.Column;
import com.collibra.marketplace.atscale.model.ConnectionGroup;
import com.collibra.marketplace.atscale.model.Dataset;
import com.collibra.marketplace.atscale.model.Dependency;
import com.collibra.marketplace.atscale.model.Measure;
import com.collibra.marketplace.atscale.store.AtscaleAssetType$;
import com.collibra.marketplace.atscale.store.AtscaleRelationType$;
import com.collibra.marketplace.atscale.store.CollibraDirection$;
import com.collibra.marketplace.atscale.transformer.TransformDebugLogger$;
import com.collibra.marketplace.atscale.transformer.package;
import com.collibra.marketplace.atscale.transformer.package$;
import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some$;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;

public final class TransformMeasures$
implements Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(TransformMeasures$.class.getDeclaredField("logger$lzy1"));
    private volatile Object logger$lzy1;
    public static final TransformMeasures$ MODULE$ = new TransformMeasures$();

    private TransformMeasures$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TransformMeasures$.class);
    }

    private final Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LoggerFactory.getLogger((String)"com.collibra.marketplace.atscale.transformer.TransformMeasures");
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Seq<AssetImportCommand> apply(Seq<Measure> measures, Seq<Dependency> dependencies, Seq<Dataset> allDatasets, Seq<Column> allColumns, Seq<ConnectionGroup> allConnectionGroups, Map<String, String> physicalMap, package.TransformContext ctx) {
        Logger Logger_this = this.logger();
        if (Logger_this.isInfoEnabled()) {
            Logger_this.info("Transforming " + measures.size() + " measures...");
        }
        Set missingColumns = (Set)Set$.MODULE$.empty();
        AtomicReference<Boolean> foundColumn = new AtomicReference<Boolean>(BoxesRunTime.boxToBoolean((boolean)false));
        Seq importCommands = (Seq)measures.map((Function1 & Serializable)measure -> {
            String assetName = AssetNameHelpers$.MODULE$.prepareAssetName((Seq<String>)((Seq)((SeqOps)new .colon.colon((Object)ctx.atscaleService().name(), (List)new .colon.colon((Object)measure.catalogName(), (List)new .colon.colon((Object)measure.cubeName(), (List)new .colon.colon((Object)measure.measureName(), (List)Nil$.MODULE$)))))));
            AssetImportCommand assetImportCommand = package$.MODULE$.addAttribute(package$.MODULE$.addAttribute(package$.MODULE$.addAttributeIdentifier(package$.MODULE$.withBusinessAssetDomain(package$.MODULE$.withAssetType(package$.MODULE$.withDisplayName(package$.MODULE$.withAssetName(package$.MODULE$.newAssetImportCommand(), assetName, ctx), measure.measureCaption(), ctx), AtscaleAssetType$.ATSCALE_MEASURE, ctx), ctx), measure.measureGUID(), ctx), CollibraConstants$.MODULE$.AttributeTypeDescriptionId(), measure.description(), ctx), CollibraConstants$.MODULE$.AttributeTypeDefinitionId(), measure.description(), ctx);
            StringBuilder noteBuilder = new StringBuilder(AssetFormatConstants$.MODULE$.UNIQUE_NAME() + assetName);
            if (measure.isMetricalAttribute()) {
                noteBuilder.append(AssetFormatConstants$.MODULE$.NOTE_SEPARATOR()).append("Metrical Attribute");
            }
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(measure.expression()))) {
                noteBuilder.append(AssetFormatConstants$.MODULE$.NOTE_SEPARATOR()).append("Expression: ").append(measure.expression());
            }
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(measure.measureDisplayFolder()))) {
                noteBuilder.append(AssetFormatConstants$.MODULE$.NOTE_SEPARATOR()).append("Folder: ").append(measure.measureDisplayFolder());
            }
            if (!measure.isVisible()) {
                noteBuilder.append(AssetFormatConstants$.MODULE$.NOTE_SEPARATOR()).append("Hidden");
            }
            MODULE$.getAggregationByKey(Predef$.MODULE$.Integer2int(measure.measureAggregator())).foreach((Function1 & Serializable)aggregationKey -> noteBuilder.append(AssetFormatConstants$.MODULE$.NOTE_SEPARATOR()).append("Aggregation: ").append(aggregationKey));
            AssetImportCommand command = package$.MODULE$.addBusinessAssetDomainRelation(package$.MODULE$.addAttributeNote(assetImportCommand, noteBuilder.toString(), ctx), AtscaleRelationType$.ATSCALE_CUBE_CONTAINS_MEASURE, CollibraDirection$.MODULE$.SOURCE(), (Seq<String>)((Seq)((SeqOps)new .colon.colon((Object)ctx.atscaleService().name(), (List)new .colon.colon((Object)measure.catalogName(), (List)new .colon.colon((Object)measure.cubeName(), (List)Nil$.MODULE$))))), ctx);
            if (Option$.MODULE$.apply((Object)measure.expression()).isEmpty()) {
                if (package$.MODULE$.isCalculatedCol(allColumns, measure.columnName()) || !package$.MODULE$.datasetIsTable(allDatasets, measure.datasetName())) {
                    v1 = package$.MODULE$.addDataAssetDomainRelation(command, AtscaleRelationType$.ATSCALE_MEASURE_USES_ATSCALE_COLUMN, CollibraDirection$.MODULE$.TARGET(), (Seq<String>)((Seq)((SeqOps)new .colon.colon((Object)ctx.atscaleService().name(), (List)new .colon.colon((Object)measure.catalogName(), (List)new .colon.colon((Object)measure.datasetName(), (List)new .colon.colon((Object)measure.columnName(), (List)Nil$.MODULE$)))))), ctx);
                } else {
                    String fullColName = package$.MODULE$.toColumnUniqueName(allDatasets, measure.datasetName(), measure.columnName());
                    if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(fullColName)) && package$.MODULE$.datasetIsTable(allDatasets, measure.datasetName())) {
                        if (physicalMap.contains((Object)fullColName)) {
                            if (!BoxesRunTime.unboxToBoolean(foundColumn.get())) {
                                String measureName = package$.MODULE$.toTableName(allDatasets, measure.datasetName()) + AssetFormatConstants$.MODULE$.ASSET_NAME_SEPARATOR() + measure.columnName();
                                String databaseSchema = package$.MODULE$.toDatabaseSchema(allDatasets, allConnectionGroups, measure.datasetName());
                                String domainId = (String)physicalMap.getOrElse((Object)databaseSchema, TransformMeasures$::$anonfun$3);
                                AssetTypeImpl assetType = (AssetTypeImpl)ctx.collibraData().assetTypesByName().values().find((Function1 & Serializable)_$1 -> {
                                    String string = _$1.getId().toString();
                                    String string2 = domainId;
                                    return !(string != null ? !string.equals(string2) : string2 != null);
                                }).getOrElse(TransformMeasures$::$anonfun$5);
                                Logger Logger_this = MODULE$.logger();
                                if (Logger_this.isInfoEnabled()) {
                                    Logger_this.info("Example related physical column from measure '" + measureName + "' in domain: " + assetType);
                                }
                                foundColumn.set(BoxesRunTime.boxToBoolean((boolean)true));
                            }
                            String string = CollibraDirection$.MODULE$.TARGET();
                            DomainIdentifier domainIdentifier = new DomainIdentifier();
                            domainIdentifier.setId(UUID.fromString((String)physicalMap.getOrElse((Object)package$.MODULE$.toDatabaseSchema(allDatasets, allConnectionGroups, measure.datasetName()), TransformMeasures$::$anonfun$1$$anonfun$1)));
                            package$.MODULE$.addAssetDomainRelation(command, AtscaleRelationType$.ATSCALE_MEASURE_USES_PHYSICAL_COLUMN, string, domainIdentifier, (Seq<String>)((Seq)((SeqOps)new .colon.colon((Object)(package$.MODULE$.toTableName(allDatasets, measure.datasetName()) + AssetFormatConstants$.MODULE$.ASSET_NAME_SEPARATOR() + measure.columnName()), (List)Nil$.MODULE$))), ctx);
                            v1 = BoxedUnit.UNIT;
                        } else {
                            missingColumns.add((Object)fullColName);
                            v1 = BoxedUnit.UNIT;
                        }
                    } else {
                        v1 = BoxedUnit.UNIT;
                    }
                }
            } else {
                dependencies.foreach((Function1)(JProcedure1 & Serializable)dependency -> {
                    Predef$.MODULE$.println((Object)("DEPEND " + dependency));
                    String string = dependency.object();
                    String string2 = measure.measureName();
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        String string3 = dependency.objectType();
                        String string4 = "MEASURE";
                        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                            String string5 = dependency.referencedObjectType();
                            String string6 = "MEASURE";
                            if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                                if (!MODULE$.inMeasureList(measures, dependency.referencedObject())) {
                                    String target = AssetNameHelpers$.MODULE$.prepareAssetName((Seq<String>)((Seq)((SeqOps)new .colon.colon((Object)ctx.atscaleService().name(), (List)new .colon.colon((Object)dependency.catalogName(), (List)new .colon.colon((Object)measure.cubeName(), (List)new .colon.colon((Object)dependency.referencedObject(), (List)Nil$.MODULE$)))))));
                                    Logger Logger_this = MODULE$.logger();
                                    if (Logger_this.isWarnEnabled()) {
                                        Logger_this.warn("Destination object not in import so can't create relation from '" + assetName + "' to '" + target + "'. Destination measure may not be visible.");
                                        return;
                                    }
                                    return;
                                }
                                package$.MODULE$.addBusinessAssetDomainRelation(command, AtscaleRelationType$.ATSCALE_MEASURE_USES_MEASURE, CollibraDirection$.MODULE$.TARGET(), (Seq<String>)((Seq)((SeqOps)new .colon.colon((Object)ctx.atscaleService().name(), (List)new .colon.colon((Object)dependency.catalogName(), (List)new .colon.colon((Object)measure.cubeName(), (List)new .colon.colon((Object)dependency.referencedObject(), (List)Nil$.MODULE$)))))), ctx);
                                return;
                            }
                        }
                    }
                });
                v1 = BoxedUnit.UNIT;
            }
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(measure.measureDisplayFolder()))) {
                package$.MODULE$.addBusinessAssetDomainRelation(command, AtscaleRelationType$.ATSCALE_FOLDER_GROUPS_MEASURE, CollibraDirection$.MODULE$.SOURCE(), (Seq<String>)((Seq)((SeqOps)new .colon.colon((Object)ctx.atscaleService().name(), (List)new .colon.colon((Object)measure.catalogName(), (List)new .colon.colon((Object)measure.cubeName(), (List)new .colon.colon((Object)package$.MODULE$.FOLDER(), (List)new .colon.colon((Object)measure.measureDisplayFolder(), (List)Nil$.MODULE$))))))), ctx);
            }
            return command;
        });
        Logger Logger_this2 = this.logger();
        if (Logger_this2.isInfoEnabled()) {
            Logger_this2.info("Transformed " + importCommands.size() + " measures");
        }
        TransformDebugLogger$.MODULE$.logMissing((scala.collection.immutable.Set<String>)missingColumns.toSet(), "Physical column asset(s)", package$.MODULE$.COLUMN_S(), "measures");
        return importCommands;
    }

    private Option<String> getAggregationByKey(int key) {
        int n = key;
        switch (n) {
            case 1: {
                return Some$.MODULE$.apply((Object)"Sum");
            }
            case 2: {
                return Some$.MODULE$.apply((Object)"Non-Distinct Count");
            }
            case 3: {
                return Some$.MODULE$.apply((Object)"Minimum");
            }
            case 4: {
                return Some$.MODULE$.apply((Object)"Maximum");
            }
            case 5: {
                return Some$.MODULE$.apply((Object)"Average");
            }
            case 7: {
                return Some$.MODULE$.apply((Object)"Standard Deviation");
            }
            case 8: {
                return Some$.MODULE$.apply((Object)"Distinct Count");
            }
        }
        return None$.MODULE$;
    }

    private boolean inMeasureList(Seq<Measure> measures, String referencedObject) {
        return measures.exists((Function1 & Serializable)_$2 -> {
            String string = _$2.measureName();
            String string2 = referencedObject;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
    }

    private static final String $anonfun$3() {
        throw new RuntimeException("database domain not found");
    }

    private static final AssetTypeImpl $anonfun$5() {
        throw new RuntimeException("asset type for domain not found");
    }

    private static final String $anonfun$1$$anonfun$1() {
        throw new RuntimeException("schema domain not found");
    }
}

