/*
 * Decompiled with CFR 0.152.
 */
package com.collibra.marketplace.atscale.transformer;

import com.collibra.importer.rest.client.model.AssetImportCommand;
import com.collibra.importer.rest.client.model.DomainIdentifier;
import com.collibra.marketplace.atscale.AssetFormatConstants$;
import com.collibra.marketplace.atscale.config.CollibraConstants$;
import com.collibra.marketplace.atscale.helpers.AssetNameHelpers$;
import com.collibra.marketplace.atscale.model.Column;
import com.collibra.marketplace.atscale.model.ConnectionGroup;
import com.collibra.marketplace.atscale.model.Dataset;
import com.collibra.marketplace.atscale.model.Level;
import com.collibra.marketplace.atscale.store.AtscaleAssetType$;
import com.collibra.marketplace.atscale.store.AtscaleRelationType$;
import com.collibra.marketplace.atscale.store.CollibraDirection$;
import com.collibra.marketplace.atscale.transformer.TransformDebugLogger$;
import com.collibra.marketplace.atscale.transformer.package;
import com.collibra.marketplace.atscale.transformer.package$;
import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.IterableOnce;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;

public final class TransformLevels$
implements Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(TransformLevels$.class.getDeclaredField("logger$lzy1"));
    private volatile Object logger$lzy1;
    public static final TransformLevels$ MODULE$ = new TransformLevels$();

    private TransformLevels$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TransformLevels$.class);
    }

    private final Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LoggerFactory.getLogger((String)"com.collibra.marketplace.atscale.transformer.TransformLevels");
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Seq<AssetImportCommand> apply(Seq<Level> levels, Seq<Column> columns, Seq<Dataset> allDatasets, Seq<ConnectionGroup> allConnectionGroups, Map<String, String> physicalMap, Set<String> ignoreHierarchySet, package.TransformContext ctx) {
        Seq secondaryLevelCommands;
        Seq levelAssets;
        block1: {
            Logger Logger_this = this.logger();
            if (Logger_this.isInfoEnabled()) {
                Logger_this.info("Transforming " + levels.size() + " levels...");
            }
            Set missingColumns = (Set)Set$.MODULE$.empty();
            AtomicReference<Boolean> foundColumn = new AtomicReference<Boolean>(BoxesRunTime.boxToBoolean((boolean)false));
            levelAssets = (Seq)levels.flatMap((Function1 & Serializable)level -> {
                if (level.parentLevelGUID().isEmpty()) {
                    String assetName = AssetNameHelpers$.MODULE$.prepareAssetName((Seq<String>)((Seq)((SeqOps)new .colon.colon((Object)ctx.atscaleService().name(), (List)new .colon.colon((Object)level.catalogName(), (List)new .colon.colon((Object)level.cubeName(), (List)new .colon.colon((Object)level.levelUniqueName(), (List)Nil$.MODULE$)))))));
                    AssetImportCommand assetImportCommand = package$.MODULE$.addAttribute(package$.MODULE$.addAttribute(package$.MODULE$.addAttributeIdentifier(package$.MODULE$.withBusinessAssetDomain(package$.MODULE$.withAssetType(package$.MODULE$.withDisplayName(package$.MODULE$.withAssetName(package$.MODULE$.newAssetImportCommand(), assetName, ctx), level.levelCaption(), ctx), AtscaleAssetType$.ATSCALE_LEVEL, ctx), ctx), level.levelGUID(), ctx), CollibraConstants$.MODULE$.AttributeTypeDescriptionId(), level.description(), ctx), CollibraConstants$.MODULE$.AttributeTypeDefinitionId(), level.description(), ctx);
                    StringBuilder noteBuilder = new StringBuilder(AssetFormatConstants$.MODULE$.UNIQUE_NAME()).append(assetName).append(AssetFormatConstants$.MODULE$.NOTE_SEPARATOR()).append("Level ").append((Object)level.levelNumber());
                    if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(level.sortColumn()))) {
                        String string = level.sortColumn();
                        String string2 = level.nameColumn();
                        if (string == null ? string2 != null : !string.equals(string2)) {
                            noteBuilder.append(AssetFormatConstants$.MODULE$.NOTE_SEPARATOR()).append("Sort by column: ").append(level.sortColumn());
                        }
                    }
                    if (!level.isVisible()) {
                        noteBuilder.append(AssetFormatConstants$.MODULE$.NOTE_SEPARATOR()).append("Attribute is Hidden");
                    }
                    AssetImportCommand levelCmd = package$.MODULE$.addBusinessAssetDomainRelation(package$.MODULE$.addAttributeNote(assetImportCommand, noteBuilder.toString(), ctx), AtscaleRelationType$.ATSCALE_HIERARCHY_CONTAINS_LEVEL, CollibraDirection$.MODULE$.SOURCE(), (Seq<String>)((Seq)((SeqOps)new .colon.colon((Object)ctx.atscaleService().name(), (List)new .colon.colon((Object)level.catalogName(), (List)new .colon.colon((Object)level.cubeName(), (List)new .colon.colon((Object)level.hierarchyUniqueName(), (List)Nil$.MODULE$)))))), ctx);
                    scala.collection.immutable.Set<String> uniqueCalcColumns = level.getUniqueCalcColumns(level.catalogName(), columns);
                    scala.collection.immutable.Set<String> uniquePhysicalColumns = level.getUniquePhysicalColumns(level.catalogName(), columns);
                    if (uniqueCalcColumns == null && uniquePhysicalColumns == null || !package$.MODULE$.foundInDatasets(level.catalogName(), level.datasetName(), allDatasets)) {
                        Logger Logger_this = MODULE$.logger();
                        if (Logger_this.isWarnEnabled()) {
                            Logger_this.warn(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Can't add relationships to columns for level '" + level.levelUniqueName() + "' in cube '" + level.catalogName() + " > " + level.cubeName() + "'.\n                                   |It appears to be used for shared degenerate dimensions which are not yet supported by DMV queries")));
                        }
                        return None$.MODULE$;
                    }
                    uniqueCalcColumns.foreach((Function1 & Serializable)col -> package$.MODULE$.addDataAssetDomainRelation(levelCmd, AtscaleRelationType$.ATSCALE_LEVEL_USES_ATSCALE_COLUMN, CollibraDirection$.MODULE$.TARGET(), (Seq<String>)((Seq)((SeqOps)new .colon.colon((Object)ctx.atscaleService().name(), (List)new .colon.colon((Object)level.catalogName(), (List)new .colon.colon((Object)level.datasetName(), (List)new .colon.colon(col, (List)Nil$.MODULE$)))))), ctx));
                    uniquePhysicalColumns.foreach((Function1 & Serializable)col -> {
                        String fullColName = package$.MODULE$.toColumnUniqueName(allDatasets, level.datasetName(), (String)col);
                        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(fullColName)) && package$.MODULE$.datasetIsTable(allDatasets, level.datasetName())) {
                            if (physicalMap.contains((Object)fullColName)) {
                                String string = CollibraDirection$.MODULE$.TARGET();
                                DomainIdentifier domainIdentifier = new DomainIdentifier();
                                domainIdentifier.setId(UUID.fromString((String)physicalMap.getOrElse((Object)package$.MODULE$.toDatabaseSchema(allDatasets, allConnectionGroups, level.datasetName()), TransformLevels$::$anonfun$1$$anonfun$2$$anonfun$1)));
                                package$.MODULE$.addAssetDomainRelation(levelCmd, AtscaleRelationType$.ATSCALE_LEVEL_USES_PHYSICAL_COLUMN, string, domainIdentifier, (Seq<String>)((Seq)((SeqOps)new .colon.colon((Object)(package$.MODULE$.toTableName(allDatasets, level.datasetName()) + AssetFormatConstants$.MODULE$.ASSET_NAME_SEPARATOR() + col), (List)Nil$.MODULE$))), ctx);
                                if (!Predef$.MODULE$.boolean2Boolean(BoxesRunTime.unboxToBoolean(foundColumn.get())).booleanValue()) {
                                    Logger Logger_this = MODULE$.logger();
                                    if (Logger_this.isInfoEnabled()) {
                                        Logger_this.info(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Example related physical column from level attribute\n                              |'" + package$.MODULE$.toTableName(allDatasets, level.datasetName()) + AssetFormatConstants$.MODULE$.ASSET_NAME_SEPARATOR() + col + "}'\n                              |in domain: {FIX_LOOKUP}")));
                                    }
                                    foundColumn.set(BoxesRunTime.boxToBoolean((boolean)true));
                                    return BoxedUnit.UNIT;
                                }
                                return BoxedUnit.UNIT;
                            }
                            return BoxesRunTime.boxToBoolean((boolean)missingColumns.add((Object)fullColName));
                        }
                        return package$.MODULE$.addDataAssetDomainRelation(levelCmd, AtscaleRelationType$.ATSCALE_LEVEL_USES_ATSCALE_COLUMN, CollibraDirection$.MODULE$.TARGET(), (Seq<String>)((Seq)((SeqOps)new .colon.colon((Object)ctx.atscaleService().name(), (List)new .colon.colon((Object)level.catalogName(), (List)new .colon.colon((Object)level.datasetName(), (List)new .colon.colon(col, (List)Nil$.MODULE$)))))), ctx);
                    });
                    return Some$.MODULE$.apply((Object)levelCmd);
                }
                return None$.MODULE$;
            });
            Set cubesWithInvisibleLevels = (Set)Set$.MODULE$.empty();
            secondaryLevelCommands = (Seq)levels.flatMap((Function1 & Serializable)secondary -> {
                if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(secondary.parentLevelGUID()))) {
                    String assetName = AssetNameHelpers$.MODULE$.prepareAssetName((Seq<String>)((Seq)((SeqOps)new .colon.colon((Object)ctx.atscaleService().name(), (List)new .colon.colon((Object)secondary.catalogName(), (List)new .colon.colon((Object)secondary.cubeName(), (List)new .colon.colon((Object)secondary.levelUniqueName(), (List)Nil$.MODULE$)))))));
                    Option maybeAssociatedLevel = secondary.getAssociatedLevel(levels).map((Function1 & Serializable)level -> {
                        cubesWithInvisibleLevels.addOne((Object)(level.catalogName() + AssetFormatConstants$.MODULE$.ASSET_NAME_SEPARATOR() + level.cubeName()));
                        return level;
                    });
                    return (IterableOnce)maybeAssociatedLevel.map((Function1 & Serializable)associatedLevel -> {
                        ignoreHierarchySet.$plus$eq((Object)AssetNameHelpers$.MODULE$.prepareAssetName((Seq<String>)((Seq)((SeqOps)new .colon.colon((Object)ctx.atscaleService().name(), (List)new .colon.colon((Object)secondary.catalogName(), (List)new .colon.colon((Object)secondary.cubeName(), (List)new .colon.colon((Object)secondary.hierarchyUniqueName(), (List)Nil$.MODULE$))))))));
                        AssetImportCommand secondaryLevelCmd = package$.MODULE$.addBusinessAssetDomainRelation(package$.MODULE$.addAttributeIdentifier(package$.MODULE$.addAttributeNote(package$.MODULE$.addAttribute(package$.MODULE$.addAttribute(package$.MODULE$.withBusinessAssetDomain(package$.MODULE$.withAssetType(package$.MODULE$.withDisplayName(package$.MODULE$.withAssetName(package$.MODULE$.newAssetImportCommand(), assetName, ctx), secondary.levelCaption(), ctx), AtscaleAssetType$.ATSCALE_SECONDARY, ctx), ctx), CollibraConstants$.MODULE$.AttributeTypeDescriptionId(), secondary.description(), ctx), CollibraConstants$.MODULE$.AttributeTypeDefinitionId(), secondary.description(), ctx), new StringBuilder(AssetFormatConstants$.MODULE$.UNIQUE_NAME()).append(assetName).append(AssetFormatConstants$.MODULE$.NOTE_SEPARATOR()).append("Secondary attribute of ").append(associatedLevel.levelCaption()).toString(), ctx), secondary.levelGUID(), ctx), AtscaleRelationType$.ATSCALE_LEVEL_CONTAINS_SECONDARY, CollibraDirection$.MODULE$.SOURCE(), (Seq<String>)((Seq)((SeqOps)new .colon.colon((Object)ctx.atscaleService().name(), (List)new .colon.colon((Object)secondary.catalogName(), (List)new .colon.colon((Object)secondary.cubeName(), (List)new .colon.colon((Object)associatedLevel.levelUniqueName(), (List)Nil$.MODULE$)))))), ctx);
                        scala.collection.immutable.Set<String> uniqueCalcColumns = secondary.getUniqueCalcColumns(secondary.catalogName(), columns);
                        scala.collection.immutable.Set<String> uniquePhysicalColumns = secondary.getUniquePhysicalColumns(secondary.catalogName(), columns);
                        if (uniqueCalcColumns == null && uniquePhysicalColumns == null || !package$.MODULE$.foundInDatasets(associatedLevel.catalogName(), associatedLevel.datasetName(), allDatasets)) {
                            Logger Logger_this = MODULE$.logger();
                            if (Logger_this.isWarnEnabled()) {
                                Logger_this.warn(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Can't add relationships to columns for secondary attribute '" + secondary.levelUniqueName() + "'\n                           |in cube '" + secondary.catalogName() + " > " + secondary.cubeName() + "'.\n                           |It appears to be used for shared degenerate dimensions which are not yet supported by DMV queries")));
                            }
                        } else {
                            uniqueCalcColumns.foreach((Function1 & Serializable)col -> package$.MODULE$.addDataAssetDomainRelation(secondaryLevelCmd, AtscaleRelationType$.ATSCALE_SECONDARY_USES_ATSCALE_COLUMN, CollibraDirection$.MODULE$.TARGET(), (Seq<String>)((Seq)((SeqOps)new .colon.colon((Object)ctx.atscaleService().name(), (List)new .colon.colon((Object)associatedLevel.catalogName(), (List)new .colon.colon((Object)associatedLevel.datasetName(), (List)new .colon.colon(col, (List)Nil$.MODULE$)))))), ctx));
                            uniquePhysicalColumns.foreach((Function1 & Serializable)col -> {
                                String fullColName = package$.MODULE$.toColumnUniqueName(allDatasets, associatedLevel.datasetName(), (String)col);
                                if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(fullColName)) && package$.MODULE$.datasetIsTable(allDatasets, associatedLevel.datasetName())) {
                                    if (physicalMap.contains((Object)fullColName)) {
                                        String string = CollibraDirection$.MODULE$.TARGET();
                                        DomainIdentifier domain = new DomainIdentifier();
                                        domain.setId(UUID.fromString((String)physicalMap.getOrElse((Object)package$.MODULE$.toDatabaseSchema(allDatasets, allConnectionGroups, associatedLevel.datasetName()), TransformLevels$::$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1)));
                                        return package$.MODULE$.addAssetDomainRelation(secondaryLevelCmd, AtscaleRelationType$.ATSCALE_SECONDARY_USES_PHYSICAL_COLUMN, string, domain, (Seq<String>)((Seq)((SeqOps)new .colon.colon((Object)(package$.MODULE$.toTableName(allDatasets, associatedLevel.datasetName()) + AssetFormatConstants$.MODULE$.ASSET_NAME_SEPARATOR() + col), (List)Nil$.MODULE$))), ctx);
                                    }
                                    return missingColumns.$plus$eq((Object)fullColName);
                                }
                                return package$.MODULE$.addDataAssetDomainRelation(secondaryLevelCmd, AtscaleRelationType$.ATSCALE_SECONDARY_USES_ATSCALE_COLUMN, CollibraDirection$.MODULE$.TARGET(), (Seq<String>)((Seq)((SeqOps)new .colon.colon((Object)ctx.atscaleService().name(), (List)new .colon.colon((Object)associatedLevel.catalogName(), (List)new .colon.colon((Object)associatedLevel.datasetName(), (List)new .colon.colon(col, (List)Nil$.MODULE$)))))), ctx);
                            });
                        }
                        return Some$.MODULE$.apply((Object)secondaryLevelCmd);
                    }).getOrElse(() -> TransformLevels$.$anonfun$2$$anonfun$2(assetName, ctx, secondary, columns, allDatasets, physicalMap, allConnectionGroups, missingColumns));
                }
                return None$.MODULE$;
            });
            cubesWithInvisibleLevels.foreach((Function1)(JProcedure1 & Serializable)cube -> {
                Logger Logger_this = MODULE$.logger();
                if (Logger_this.isWarnEnabled()) {
                    Logger_this.warn("Secondary attribute(s) with no associated level attribute found in cube '" + cube + "'. The levels could be invisible and not returned by the DMV query");
                    return;
                }
            });
            TransformDebugLogger$.MODULE$.logMissing((scala.collection.immutable.Set<String>)missingColumns.toSet(), "Physical column asset(s)", package$.MODULE$.COLUMN_S(), "attributes");
            Logger Logger_this2 = this.logger();
            if (!Logger_this2.isInfoEnabled()) break block1;
            Logger_this2.info("Transformed " + (levelAssets.size() + secondaryLevelCommands.size()) + " attributes (both levels and secondary)");
        }
        return (Seq)levelAssets.$plus$plus((IterableOnce)secondaryLevelCommands);
    }

    private static final String $anonfun$1$$anonfun$2$$anonfun$1() {
        throw new RuntimeException("No schema found");
    }

    private static final String $anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1() {
        throw new RuntimeException("No schema found");
    }

    private static final String $anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1() {
        throw new RuntimeException("No schema found");
    }

    private static final Some $anonfun$2$$anonfun$2(String assetName$2, package.TransformContext ctx$8, Level secondary$2, Seq columns$4, Seq allDatasets$6, Map physicalMap$6, Seq allConnectionGroups$6, Set missingColumns$6) {
        AssetImportCommand secondaryLevelCmd = package$.MODULE$.addBusinessAssetDomainRelation(package$.MODULE$.addAttributeIdentifier(package$.MODULE$.addAttributeNote(package$.MODULE$.addAttribute(package$.MODULE$.addAttribute(package$.MODULE$.withBusinessAssetDomain(package$.MODULE$.withAssetType(package$.MODULE$.withDisplayName(package$.MODULE$.withAssetName(package$.MODULE$.newAssetImportCommand(), assetName$2, ctx$8), secondary$2.levelCaption(), ctx$8), AtscaleAssetType$.ATSCALE_LEVEL, ctx$8), ctx$8), CollibraConstants$.MODULE$.AttributeTypeDescriptionId(), secondary$2.description(), ctx$8), CollibraConstants$.MODULE$.AttributeTypeDefinitionId(), secondary$2.description(), ctx$8), new StringBuilder(AssetFormatConstants$.MODULE$.UNIQUE_NAME()).append(assetName$2).append(AssetFormatConstants$.MODULE$.NOTE_SEPARATOR()).append("Secondary attribute of invisible level").toString(), ctx$8), secondary$2.levelGUID(), ctx$8), AtscaleRelationType$.ATSCALE_HIERARCHY_CONTAINS_LEVEL, CollibraDirection$.MODULE$.SOURCE(), (Seq<String>)((Seq)((SeqOps)new .colon.colon((Object)ctx$8.atscaleService().name(), (List)new .colon.colon((Object)secondary$2.catalogName(), (List)new .colon.colon((Object)secondary$2.cubeName(), (List)new .colon.colon((Object)secondary$2.hierarchyUniqueName(), (List)Nil$.MODULE$)))))), ctx$8);
        scala.collection.immutable.Set<String> uniqueCalcColumns = secondary$2.getUniqueCalcColumns(secondary$2.catalogName(), (Seq<Column>)columns$4);
        scala.collection.immutable.Set<String> uniquePhysicalColumns = secondary$2.getUniquePhysicalColumns(secondary$2.catalogName(), (Seq<Column>)columns$4);
        if (uniqueCalcColumns == null && uniquePhysicalColumns == null || !package$.MODULE$.foundInDatasets(secondary$2.catalogName(), secondary$2.datasetName(), (Seq<Dataset>)allDatasets$6)) {
            Logger Logger_this = MODULE$.logger();
            if (Logger_this.isWarnEnabled()) {
                Logger_this.warn(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Can't add relationships to columns for secondary attribute\n                           |'" + secondary$2.levelUniqueName() + "' in cube '" + secondary$2.catalogName() + " > " + secondary$2.cubeName() + "'.\n                           |It appears to be used for shared degenerate dimensions which are not yet supported by DMV queries")));
            }
        } else {
            uniqueCalcColumns.foreach((Function1 & Serializable)col -> package$.MODULE$.addDataAssetDomainRelation(secondaryLevelCmd, AtscaleRelationType$.ATSCALE_LEVEL_USES_ATSCALE_COLUMN, CollibraDirection$.MODULE$.TARGET(), (Seq<String>)((Seq)((SeqOps)new .colon.colon((Object)ctx$8.atscaleService().name(), (List)new .colon.colon((Object)secondary$2.catalogName(), (List)new .colon.colon((Object)secondary$2.datasetName(), (List)new .colon.colon(col, (List)Nil$.MODULE$)))))), ctx$8));
            uniquePhysicalColumns.foreach((Function1 & Serializable)col -> {
                String fullColName = package$.MODULE$.toColumnUniqueName((Seq<Dataset>)allDatasets$6, secondary$2.datasetName(), (String)col);
                if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(fullColName)) && physicalMap$6.contains((Object)fullColName)) {
                    String string = CollibraDirection$.MODULE$.TARGET();
                    DomainIdentifier domain = new DomainIdentifier();
                    domain.setId(UUID.fromString((String)physicalMap$6.getOrElse((Object)package$.MODULE$.toDatabaseSchema((Seq<Dataset>)allDatasets$6, (Seq<ConnectionGroup>)allConnectionGroups$6, secondary$2.datasetName()), TransformLevels$::$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1)));
                    return package$.MODULE$.addAssetDomainRelation(secondaryLevelCmd, AtscaleRelationType$.ATSCALE_LEVEL_USES_PHYSICAL_COLUMN, string, domain, (Seq<String>)((Seq)((SeqOps)new .colon.colon((Object)(package$.MODULE$.toTableName((Seq<Dataset>)allDatasets$6, secondary$2.datasetName()) + AssetFormatConstants$.MODULE$.ASSET_NAME_SEPARATOR() + col), (List)Nil$.MODULE$))), ctx$8);
                }
                return missingColumns$6.$plus$eq((Object)fullColName);
            });
        }
        return Some$.MODULE$.apply((Object)secondaryLevelCmd);
    }
}

