/*
 * Decompiled with CFR 0.152.
 */
package com.collibra.marketplace.atscale.transformer;

import com.collibra.importer.rest.client.model.AssetImportCommand;
import com.collibra.marketplace.atscale.AssetFormatConstants$;
import com.collibra.marketplace.atscale.config.CollibraConstants$;
import com.collibra.marketplace.atscale.helpers.AssetNameHelpers$;
import com.collibra.marketplace.atscale.model.Dataset;
import com.collibra.marketplace.atscale.model.Hierarchy;
import com.collibra.marketplace.atscale.model.Level;
import com.collibra.marketplace.atscale.store.AtscaleAssetType$;
import com.collibra.marketplace.atscale.store.AtscaleRelationType$;
import com.collibra.marketplace.atscale.store.CollibraDirection$;
import com.collibra.marketplace.atscale.transformer.package;
import com.collibra.marketplace.atscale.transformer.package$;
import java.io.Serializable;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.None$;
import scala.Predef$;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class TransformHierarchies$
implements Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(TransformHierarchies$.class.getDeclaredField("logger$lzy1"));
    private volatile Object logger$lzy1;
    public static final TransformHierarchies$ MODULE$ = new TransformHierarchies$();

    private TransformHierarchies$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TransformHierarchies$.class);
    }

    private final Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LoggerFactory.getLogger((String)"com.collibra.marketplace.atscale.transformer.TransformHierarchies");
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Seq<AssetImportCommand> apply(Seq<Hierarchy> hierarchies, Seq<Level> levels, Seq<Dataset> datasetList, Set<String> ignoreHierarchySet, package.TransformContext ctx) {
        Seq hierarchyAssets;
        block1: {
            Logger Logger_this = this.logger();
            if (Logger_this.isInfoEnabled()) {
                Logger_this.info("Transforming " + hierarchies.size() + " hierarchies...");
            }
            hierarchyAssets = (Seq)hierarchies.flatMap((Function1 & Serializable)hierarchy -> {
                String assetName = AssetNameHelpers$.MODULE$.prepareAssetName((Seq<String>)((Seq)((SeqOps)new .colon.colon((Object)ctx.atscaleService().name(), (List)new .colon.colon((Object)hierarchy.catalogName(), (List)new .colon.colon((Object)hierarchy.cubeName(), (List)new .colon.colon((Object)hierarchy.hierarchyUniqueName(), (List)Nil$.MODULE$)))))));
                if (ignoreHierarchySet == null || ignoreHierarchySet.isEmpty() || !ignoreHierarchySet.contains((Object)assetName)) {
                    AssetImportCommand assetImportCommand = package$.MODULE$.addAttribute(package$.MODULE$.addAttribute(package$.MODULE$.addAttributeIdentifier(package$.MODULE$.withAssetType(package$.MODULE$.withBusinessAssetDomain(package$.MODULE$.withDisplayName(package$.MODULE$.withAssetName(package$.MODULE$.newAssetImportCommand(), assetName, ctx), hierarchy.hierarchyCaption(), ctx), ctx), AtscaleAssetType$.ATSCALE_HIERARCHY, ctx), hierarchy.hierarchyGUID(), ctx), CollibraConstants$.MODULE$.AttributeTypeDescriptionId(), hierarchy.description(), ctx), CollibraConstants$.MODULE$.AttributeTypeDefinitionId(), hierarchy.description(), ctx);
                    StringBuilder noteBuilder = new StringBuilder(AssetFormatConstants$.MODULE$.UNIQUE_NAME()).append(assetName);
                    if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(hierarchy.defaultMember())) && !hierarchy.defaultMember().toUpperCase(Locale.ROOT).contains("ALL_MEMBER") && !hierarchy.defaultMember().toUpperCase(Locale.ROOT).contains("[ALL]")) {
                        noteBuilder.append(AssetFormatConstants$.MODULE$.NOTE_SEPARATOR()).append("Default Member: ").append(hierarchy.defaultMember());
                    }
                    AssetImportCommand hierarchyAssetBuilder = package$.MODULE$.addBusinessAssetDomainRelation(package$.MODULE$.addAttributeNote(assetImportCommand, noteBuilder.toString(), ctx), AtscaleRelationType$.ATSCALE_DIMENSION_CONTAINS_HIERARCHY, CollibraDirection$.MODULE$.SOURCE(), (Seq<String>)((Seq)((SeqOps)new .colon.colon((Object)ctx.atscaleService().name(), (List)new .colon.colon((Object)hierarchy.catalogName(), (List)new .colon.colon((Object)hierarchy.cubeName(), (List)new .colon.colon((Object)hierarchy.dimensionUniqueName(), (List)Nil$.MODULE$)))))), ctx);
                    scala.collection.immutable.Set datasets = ((IterableOnceOps)levels.flatMap((Function1 & Serializable)level -> {
                        String string = level.hierarchyUniqueName();
                        String string2 = hierarchy.hierarchyUniqueName();
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            String string3 = level.catalogName();
                            String string4 = hierarchy.catalogName();
                            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                                if (package$.MODULE$.foundInDatasets(level.catalogName(), level.datasetName(), datasetList)) {
                                    return (IterableOnce)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{level.datasetName()}));
                                }
                                Object object = Predef$.MODULE$.refArrayOps((Object[])level.datasetName().split(","));
                                return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)x$1 -> {
                                    String string;
                                    String ds = string = x$1;
                                    if (package$.MODULE$.foundInDatasets(level.catalogName(), ds, datasetList)) {
                                        return Some$.MODULE$.apply((Object)ds);
                                    }
                                    return None$.MODULE$;
                                }, ClassTag$.MODULE$.apply(String.class))).toSet();
                            }
                        }
                        return Predef$.MODULE$.Set().empty();
                    })).toSet();
                    datasets.foreach((Function1 & Serializable)dataset -> package$.MODULE$.addDataAssetDomainRelation(hierarchyAssetBuilder, AtscaleRelationType$.ATSCALE_HIERARCHY_USES_DATASET, CollibraDirection$.MODULE$.TARGET(), (Seq<String>)((Seq)((SeqOps)new .colon.colon((Object)ctx.atscaleService().name(), (List)new .colon.colon((Object)hierarchy.catalogName(), (List)new .colon.colon(dataset, (List)Nil$.MODULE$))))), ctx));
                    if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(hierarchy.hierarchyDisplayFolder()))) {
                        package$.MODULE$.addBusinessAssetDomainRelation(hierarchyAssetBuilder, AtscaleRelationType$.ATSCALE_FOLDER_GROUPS_HIERARCHY, CollibraDirection$.MODULE$.SOURCE(), (Seq<String>)((Seq)((SeqOps)new .colon.colon((Object)ctx.atscaleService().name(), (List)new .colon.colon((Object)hierarchy.catalogName(), (List)new .colon.colon((Object)hierarchy.cubeName(), (List)new .colon.colon((Object)package$.MODULE$.FOLDER(), (List)new .colon.colon((Object)hierarchy.hierarchyDisplayFolder(), (List)Nil$.MODULE$))))))), ctx);
                    }
                    return Some$.MODULE$.apply((Object)hierarchyAssetBuilder);
                }
                return None$.MODULE$;
            });
            Logger Logger_this2 = this.logger();
            if (!Logger_this2.isInfoEnabled()) break block1;
            Logger_this2.info("Transformed " + hierarchyAssets.size() + " hierarchies");
        }
        return hierarchyAssets;
    }
}

