/*
 * Decompiled with CFR 0.152.
 */
package com.collibra.marketplace.atscale.store;

import com.collibra.core.rest.client.model.AssetImpl;
import com.collibra.core.rest.client.model.RelationImpl;
import com.collibra.marketplace.atscale.AssetFormatConstants$;
import com.collibra.marketplace.atscale.collibra.service.AssetService;
import com.collibra.marketplace.atscale.collibra.service.RelationService;
import com.collibra.marketplace.atscale.config.CollibraConstants$;
import com.collibra.marketplace.atscale.helpers.AssetNameHelpers$;
import com.collibra.marketplace.atscale.model.Dataset;
import java.io.Serializable;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Predef$;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map$;
import scala.package$;
import scala.runtime.BooleanRef;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;

public class PhysicalMapLoader {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(PhysicalMapLoader.class.getDeclaredField("logger$lzy1"));
    private final AssetService assetService;
    private final RelationService relationService;
    private volatile Object logger$lzy1;

    public PhysicalMapLoader(AssetService assetService, RelationService relationService) {
        this.assetService = assetService;
        this.relationService = relationService;
    }

    private AssetService assetService() {
        return this.assetService;
    }

    private RelationService relationService() {
        return this.relationService;
    }

    private Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LoggerFactory.getLogger((String)"com.collibra.marketplace.atscale.store.PhysicalMapLoader");
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Map<String, String> createPhysicalMap(Seq<Dataset> allDatasets) {
        Logger Logger_this = this.logger();
        if (Logger_this.isInfoEnabled()) {
            Logger_this.info("Creating a map of physical objects for linking");
        }
        scala.collection.mutable.Map physicalMap = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        Seq datasetsSet = (Seq)allDatasets.flatMap((Function1 & Serializable)ds -> {
            if (ds.schema() != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(ds.schema()))) {
                String datasetSchema = ds.database() != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(ds.database())) ? ds.database() + AssetFormatConstants$.MODULE$.ASSET_NAME_SEPARATOR() + ds.schema() : ds.schema();
                return (SeqOps)new .colon.colon((Object)datasetSchema, (List)new .colon.colon((Object)AssetNameHelpers$.MODULE$.prepareAssetName((Seq<String>)((Seq)((SeqOps)new .colon.colon((Object)datasetSchema, (List)new .colon.colon((Object)ds.table(), (List)Nil$.MODULE$))))), (List)Nil$.MODULE$));
            }
            return package$.MODULE$.Seq().empty();
        });
        Seq<AssetImpl> databaseAssets = this.assetService().listAssetsForAssetTypeId(UUID.fromString(CollibraConstants$.MODULE$.AssetTypeDatabaseId()));
        databaseAssets.foreach((Function1)(JProcedure1 & Serializable)dbAsset -> {
            Seq<RelationImpl> relations = this.relationService().listRelationsForAsset((AssetImpl)dbAsset);
            if (relations.isEmpty()) {
                Logger Logger_this = this.logger();
                if (Logger_this.isInfoEnabled()) {
                    Logger_this.info("No related schemas found for database: " + dbAsset.getName());
                    return;
                }
                return;
            }
            relations.foreach((Function1)(JProcedure1 & Serializable)relation -> {
                if (relation.getTarget() != null) {
                    Seq<AssetImpl> relationTargetAssets = this.assetService().listAssetsForName(relation.getTarget().getName());
                    if (relationTargetAssets.isEmpty()) {
                        Logger Logger_this = this.logger();
                        if (Logger_this.isWarnEnabled()) {
                            Logger_this.warn("No assets found for schema: " + relation.getTarget().getName());
                            return;
                        }
                        return;
                    }
                    ObjectRef count = ObjectRef.create((Object)Predef$.MODULE$.int2Integer(0));
                    relationTargetAssets.foreach((Function1)(JProcedure1 & Serializable)schema -> {
                        UUID uUID = schema.getId();
                        UUID uUID2 = relation.getTarget().getId();
                        if (!(uUID != null ? !((Object)uUID).equals(uUID2) : uUID2 != null)) {
                            physicalMap.put((Object)(dbAsset.getName() + AssetFormatConstants$.MODULE$.ASSET_NAME_SEPARATOR() + relation.getTarget().getName()), (Object)schema.getDomain().getId().toString());
                            physicalMap.put((Object)relation.getTarget().getName(), (Object)schema.getDomain().getId().toString());
                            physicalMap.put((Object)schema.getDomain().getId().toString(), (Object)(dbAsset.getName() + AssetFormatConstants$.MODULE$.ASSET_NAME_SEPARATOR() + relation.getTarget().getName()));
                            Seq<AssetImpl> schemaDomainAssets = this.assetService().listAssetsForDomainId(schema.getDomain().getId());
                            BooleanRef foundTable = BooleanRef.create((boolean)false);
                            BooleanRef foundColumn = BooleanRef.create((boolean)false);
                            schemaDomainAssets.foreach((Function1)(JProcedure1 & Serializable)tableOrCol -> {
                                block10: {
                                    String assetId;
                                    block9: {
                                        String assetPrefix = dbAsset != null && dbAsset.getName() != null ? dbAsset.getName() + AssetFormatConstants$.MODULE$.ASSET_NAME_SEPARATOR() + (Function1 & Serializable)name -> schema.name((String)name) : schema.getName();
                                        assetId = AssetNameHelpers$.MODULE$.prepareAssetName((Seq<String>)((Seq)((SeqOps)new .colon.colon((Object)assetPrefix, (List)new .colon.colon((Object)tableOrCol.getName(), (List)Nil$.MODULE$)))));
                                        if (!foundTable$1.elem) {
                                            String string = tableOrCol.getType().getName();
                                            String string2 = "Table";
                                            if (!(string != null ? !string.equals(string2) : string2 != null) && datasetsSet.contains((Object)assetId)) {
                                                Logger Logger_this = this.logger();
                                                if (Logger_this.isInfoEnabled()) {
                                                    Logger_this.info("Example Table asset: : " + assetId + " (" + tableOrCol.getId() + ")");
                                                }
                                                foundTable$1.elem = true;
                                            }
                                        }
                                        if (!foundColumn$1.elem) {
                                            String string = tableOrCol.getType().getName();
                                            String string3 = CollibraConstants$.MODULE$.AssetTypeColumnName();
                                            if (!(string != null ? !string.equals(string3) : string3 != null) && datasetsSet.contains((Object)this.removeColumn(assetId, true))) {
                                                Logger Logger_this = this.logger();
                                                if (Logger_this.isInfoEnabled()) {
                                                    Logger_this.info("Example Column asset: " + assetId + " (" + tableOrCol.getId() + ")");
                                                }
                                                foundColumn$1.elem = true;
                                            }
                                        }
                                        String string = tableOrCol.getType().getName();
                                        String string4 = "Table";
                                        if (!(string != null ? !string.equals(string4) : string4 != null) && datasetsSet.contains((Object)assetId)) break block9;
                                        String string5 = tableOrCol.getType().getName();
                                        String string6 = CollibraConstants$.MODULE$.AssetTypeColumnName();
                                        if ((string5 != null ? !string5.equals(string6) : string6 != null) || !datasetsSet.contains((Object)this.removeColumn(assetId, true))) break block10;
                                    }
                                    physicalMap.put((Object)assetId, (Object)tableOrCol.getName());
                                    count$2.elem = Predef$.MODULE$.int2Integer(Predef$.MODULE$.Integer2int((Integer)count$2.elem) + 1);
                                    return;
                                }
                            });
                            return;
                        }
                    });
                    return;
                }
            });
        });
        return physicalMap.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private String removeColumn(String assetID, boolean hasDatabase) {
        if (assetID.split(" > ").length == 4 || assetID.split(" > ").length == 3 && !hasDatabase) {
            return assetID.substring(0, assetID.lastIndexOf(" > "));
        }
        return assetID;
    }
}

