/*
 * Decompiled with CFR 0.152.
 */
package com.collibra.marketplace.atscale.store;

import com.collibra.core.rest.client.model.AssetTypeImpl;
import com.collibra.core.rest.client.model.AttributeType;
import com.collibra.core.rest.client.model.CommunityImpl;
import com.collibra.core.rest.client.model.DomainImpl;
import com.collibra.core.rest.client.model.RelationTypeImpl;
import com.collibra.marketplace.atscale.collibra.service.AssetTypeService;
import com.collibra.marketplace.atscale.collibra.service.AttributeTypeService;
import com.collibra.marketplace.atscale.collibra.service.CommunityService;
import com.collibra.marketplace.atscale.collibra.service.DomainService;
import com.collibra.marketplace.atscale.collibra.service.RelationTypeService;
import com.collibra.marketplace.atscale.config.AssetConfig;
import com.collibra.marketplace.atscale.config.CollibraConstants$;
import com.collibra.marketplace.atscale.config.CommunityConfig;
import com.collibra.marketplace.atscale.package;
import com.collibra.marketplace.atscale.package$InvalidConfigurationException$;
import com.collibra.marketplace.atscale.store.AtscaleAssetType$;
import com.collibra.marketplace.atscale.store.AtscaleAttributeType$;
import com.collibra.marketplace.atscale.store.AtscaleRelationType;
import com.collibra.marketplace.atscale.store.AtscaleRelationType$;
import com.collibra.marketplace.atscale.store.CollibraInstanceData;
import com.collibra.marketplace.atscale.store.CollibraInstanceData$;
import java.io.Serializable;
import java.util.UUID;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;

public class CollibraDataLoader {
    private final CommunityConfig communityConfig;
    private final AssetConfig assetConfig;
    private final CommunityService communityService;
    private final DomainService domainService;
    private final AssetTypeService assetTypeService;
    private final AttributeTypeService attributeTypeService;
    private final RelationTypeService relationTypeService;

    public CollibraDataLoader(CommunityConfig communityConfig, AssetConfig assetConfig, CommunityService communityService, DomainService domainService, AssetTypeService assetTypeService, AttributeTypeService attributeTypeService, RelationTypeService relationTypeService) {
        this.communityConfig = communityConfig;
        this.assetConfig = assetConfig;
        this.communityService = communityService;
        this.domainService = domainService;
        this.assetTypeService = assetTypeService;
        this.attributeTypeService = attributeTypeService;
        this.relationTypeService = relationTypeService;
    }

    public CollibraInstanceData load() {
        CommunityImpl community = this.getCommunity();
        DomainImpl businessAssetDomain = this.getDomain(community, this.assetConfig.atscaleBusinessAssetDomainId(), this.assetConfig.atscaleBusinessAssetDomainName());
        DomainImpl dataAssetDomain = this.getDomain(community, this.assetConfig.atscaleDataAssetDomainId(), this.assetConfig.atscaleDataAssetDomainName());
        Map<String, AssetTypeImpl> assetTypes = this.getAssetTypesByName();
        Map<String, AttributeType> attributeTypes = this.getAttributeTypes();
        Map<AtscaleRelationType, RelationTypeImpl> relationTypes = this.getRelationTypes(assetTypes);
        return CollibraInstanceData$.MODULE$.apply(community, businessAssetDomain, dataAssetDomain, assetTypes, attributeTypes, relationTypes);
    }

    private CommunityImpl getCommunity() {
        if (this.communityConfig.atscaleCommunityId() != null) {
            return this.communityService.getCommunityById(this.communityConfig.atscaleCommunityId());
        }
        if (this.communityConfig.collibraBusinessAnalystsCommunityId() != null) {
            return this.communityService.getCommunityById(this.communityConfig.collibraBusinessAnalystsCommunityId());
        }
        if (this.communityConfig.atscaleCommunityName() != null) {
            return (CommunityImpl)this.communityService.findCommunityByName(this.communityConfig.atscaleCommunityName()).getOrElse(CollibraDataLoader::getCommunity$$anonfun$1);
        }
        throw new package.InvalidConfigurationException("Either atscale.community.id, collibra.business.analysts.community.id or atscale.community.name must be configured", package$InvalidConfigurationException$.MODULE$.$lessinit$greater$default$2());
    }

    private DomainImpl getDomain(CommunityImpl community, UUID domainId, String domainName) {
        if (domainId != null) {
            return this.domainService.getDomainById(domainId);
        }
        return (DomainImpl)this.domainService.findDomainByName(community, domainName).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private AssetTypeImpl lookupCollibraAssetType(String id) {
        return (AssetTypeImpl)this.assetTypeService.getAssetTypeById(UUID.fromString(id)).getOrElse(() -> CollibraDataLoader.lookupCollibraAssetType$$anonfun$1(id));
    }

    private Map<String, AssetTypeImpl> getAssetTypesByName() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])AtscaleAssetType$.MODULE$.values());
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)assetType -> this.assetTypeService.findAssetTypeByName(assetType.name()), ClassTag$.MODULE$.apply(AssetTypeImpl.class)));
        Map atscaleAssetTypesByName = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)assetType -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)assetType.getName());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, assetType);
        }, ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Object[] objectArray = new Tuple2[3];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"Column");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.lookupCollibraAssetType(CollibraConstants$.MODULE$.AssetTypeColumnId()));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"Table");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)this.lookupCollibraAssetType(CollibraConstants$.MODULE$.AssetTypeTableId()));
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"Schema");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)this.lookupCollibraAssetType(CollibraConstants$.MODULE$.AssetTypeSchemaId()));
        Map collibraAssetTypesByName = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        return (Map)atscaleAssetTypesByName.$plus$plus((IterableOnce)collibraAssetTypesByName);
    }

    private Map<String, AttributeType> getAttributeTypes() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])AtscaleAttributeType$.MODULE$.values());
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)attributeType -> Option$.MODULE$.apply((Object)this.attributeTypeService.findAttributeTypeByName(attributeType.name())), ClassTag$.MODULE$.apply(AttributeType.class)));
        Map atscaleAttributesTypesByName = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)attributeType -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)attributeType.getName());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, attributeType);
        }, ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"Description");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.attributeTypeService.getAttributeTypeById(UUID.fromString(CollibraConstants$.MODULE$.AttributeTypeDescriptionId())));
        Map collibraAttributeTypesByName = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        return (Map)atscaleAttributesTypesByName.$plus$plus((IterableOnce)collibraAttributeTypesByName);
    }

    private Map<AtscaleRelationType, RelationTypeImpl> getRelationTypes(Map<String, AssetTypeImpl> assetTypesByName) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])AtscaleRelationType$.MODULE$.values());
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)relationType -> this.relationTypeService.findRelationType((AtscaleRelationType)relationType, assetTypesByName).map((Function1 & Serializable)_$1 -> Tuple2$.MODULE$.apply(relationType, _$1)), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private static final CommunityImpl getCommunity$$anonfun$1() {
        return null;
    }

    private static final AssetTypeImpl lookupCollibraAssetType$$anonfun$1(String id$1) {
        throw new IllegalStateException("Asset type with id " + id$1 + " not found");
    }
}

