/*
 * Decompiled with CFR 0.152.
 */
package com.collibra.marketplace.atscale.processor.setup;

import com.collibra.core.rest.client.model.CommunityImpl;
import com.collibra.core.rest.client.model.DomainImpl;
import com.collibra.core.rest.client.model.DomainTypeImpl;
import com.collibra.marketplace.atscale.collibra.service.DomainService;
import com.collibra.marketplace.atscale.collibra.service.DomainTypeService;
import com.collibra.marketplace.atscale.config.AssetConfig;
import com.collibra.marketplace.atscale.package;
import com.collibra.marketplace.atscale.package$InvalidConfigurationException$;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.Option$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;

public class SetupDomains {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(SetupDomains.class.getDeclaredField("logger$lzy1"));
    private final DomainTypeService domainTypeService;
    private final DomainService domainService;
    private volatile Object logger$lzy1;

    public SetupDomains(DomainTypeService domainTypeService, DomainService domainService) {
        this.domainTypeService = domainTypeService;
        this.domainService = domainService;
    }

    private final Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LoggerFactory.getLogger((String)"com.collibra.marketplace.atscale.processor.setup.SetupDomains");
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public void apply(AssetConfig assetConfig, CommunityImpl community) {
        this.upsertAtscaleDomain(community, assetConfig.collibraBusinessAssetDomainTypeId(), assetConfig.collibraBusinessAssetDomainTypeName(), (Option<String>)Option$.MODULE$.apply((Object)assetConfig.collibraBusinessAssetDomainTypeDescription()), assetConfig.atscaleBusinessAssetDomainId(), assetConfig.atscaleBusinessAssetDomainName(), (Option<String>)Option$.MODULE$.apply((Object)assetConfig.atscaleBusinessAssetDomainDescription()));
        this.upsertAtscaleDomain(community, assetConfig.collibraDataAssetDomainTypeId(), assetConfig.collibraDataAssetDomainTypeName(), (Option<String>)Option$.MODULE$.apply((Object)assetConfig.collibraDataAssetDomainTypeDescription()), assetConfig.atscaleDataAssetDomainId(), assetConfig.atscaleDataAssetDomainName(), (Option<String>)Option$.MODULE$.apply((Object)assetConfig.atscaleDataAssetDomainDescription()));
    }

    private void upsertAtscaleDomain(CommunityImpl community, UUID existingDomainTypeId, String domainTypeName, Option<String> domainTypeDescription, UUID existingDomainId, String domainName, Option<String> domainDescription) {
        DomainTypeImpl domainType = null;
        if (existingDomainTypeId != null) {
            domainType = this.domainTypeService.getDomainTypeById(existingDomainTypeId);
            if (domainType == null) {
                throw new package.InvalidConfigurationException("Domain type " + domainTypeName + " with id " + existingDomainTypeId + " not found", package$InvalidConfigurationException$.MODULE$.$lessinit$greater$default$2());
            }
        } else {
            domainType = this.domainTypeService.findDomainTypeByName(domainTypeName);
            if (domainType == null) {
                Logger Logger_this = this.logger();
                if (Logger_this.isInfoEnabled()) {
                    Logger_this.info("Domain type " + domainTypeName + " does not exist in Collibra, creating it");
                }
                domainType = this.domainTypeService.addDomainType(domainTypeName, domainTypeDescription);
            } else {
                Logger Logger_this = this.logger();
                if (Logger_this.isInfoEnabled()) {
                    Logger_this.info("Existing domain type " + domainType + " found in Collibra");
                }
            }
        }
        if (existingDomainId != null) {
            DomainImpl maybeDomain = this.domainService.getDomainById(existingDomainId);
            if (Option$.MODULE$.apply((Object)maybeDomain).isEmpty()) {
                throw new package.InvalidConfigurationException("Domain " + domainName + " with id " + existingDomainId + " not found", package$InvalidConfigurationException$.MODULE$.$lessinit$greater$default$2());
            }
            Logger Logger_this = this.logger();
            if (Logger_this.isInfoEnabled()) {
                Logger_this.info("Domain " + domainName + " with id " + existingDomainId + " found in Collibra");
                return;
            }
            return;
        }
        Option<DomainImpl> maybeDomain = this.domainService.findDomainByName(community, domainName);
        if (maybeDomain.isEmpty()) {
            Logger Logger_this = this.logger();
            if (Logger_this.isInfoEnabled()) {
                Logger_this.info("Domain " + domainName + " does not exist in Collibra, creating it");
            }
            this.domainService.addDomain(community, domainType, domainName, domainDescription);
            return;
        }
        Logger Logger_this = this.logger();
        if (Logger_this.isInfoEnabled()) {
            Logger_this.info("Domain " + domainName + " already exists in Collibra, no need to create it again");
            return;
        }
    }
}

