/*
 * Decompiled with CFR 0.152.
 */
package com.collibra.marketplace.atscale.processor.setup;

import com.collibra.core.rest.client.model.CommunityImpl;
import com.collibra.marketplace.atscale.collibra.service.CommunityService;
import com.collibra.marketplace.atscale.config.CommunityConfig;
import com.collibra.marketplace.atscale.package;
import com.collibra.marketplace.atscale.package$InvalidConfigurationException$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;

public class SetupCommunity {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(SetupCommunity.class.getDeclaredField("logger$lzy1"));
    private final CommunityService communityService;
    private volatile Object logger$lzy1;

    public SetupCommunity(CommunityService communityService) {
        this.communityService = communityService;
    }

    private final Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LoggerFactory.getLogger((String)"com.collibra.marketplace.atscale.processor.setup.SetupCommunity");
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public CommunityImpl apply(CommunityConfig communityConfig) {
        if (Option$.MODULE$.apply((Object)communityConfig.atscaleCommunityId()).nonEmpty()) {
            Logger Logger_this = this.logger();
            if (Logger_this.isInfoEnabled()) {
                Logger_this.info("Using atscale community with id " + communityConfig.atscaleCommunityId());
            }
            return this.communityService.getCommunityById(communityConfig.atscaleCommunityId());
        }
        if (Option$.MODULE$.apply((Object)communityConfig.collibraBusinessAnalystsCommunityId()).nonEmpty()) {
            Logger Logger_this = this.logger();
            if (Logger_this.isInfoEnabled()) {
                Logger_this.info("Using collibra business analysts community with id " + communityConfig.collibraBusinessAnalystsCommunityId());
            }
            return this.communityService.getCommunityById(communityConfig.collibraBusinessAnalystsCommunityId());
        }
        if (Option$.MODULE$.apply((Object)communityConfig.atscaleCommunityName()).nonEmpty()) {
            Option<CommunityImpl> option = this.communityService.findCommunityByName(communityConfig.atscaleCommunityName());
            if (option instanceof Some) {
                CommunityImpl community = (CommunityImpl)((Some)option).value();
                Logger Logger_this = this.logger();
                if (Logger_this.isInfoEnabled()) {
                    Logger_this.info("Community " + communityConfig.atscaleCommunityName() + " (" + community.getId() + ") already exists in Collibra, no need to create it again");
                }
                return community;
            }
            if (None$.MODULE$.equals(option)) {
                Logger Logger_this = this.logger();
                if (Logger_this.isInfoEnabled()) {
                    Logger_this.info("Community " + communityConfig.atscaleCommunityName() + " does not exist in Collibra, creating it");
                }
                return this.communityService.addCommunity(communityConfig.atscaleCommunityName(), (Option<String>)Option$.MODULE$.apply((Object)communityConfig.atscaleCommunityDescription()));
            }
            throw new MatchError(option);
        }
        throw new package.InvalidConfigurationException("Either atscale.community.id, collibra.business.analysts.community.id or atscale.community.name must be configured", package$InvalidConfigurationException$.MODULE$.$lessinit$greater$default$2());
    }
}

