/*
 * Decompiled with CFR 0.152.
 */
package com.collibra.marketplace.atscale.processor.setup;

import com.collibra.core.rest.client.model.AssetTypeImpl;
import com.collibra.marketplace.atscale.collibra.service.AssetTypeService;
import com.collibra.marketplace.atscale.config.CollibraConstants$;
import com.collibra.marketplace.atscale.store.AtscaleAssetType$;
import java.io.Serializable;
import java.util.UUID;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;

public class SetupAssetTypes {
    private final AssetTypeService assetTypeService;

    public SetupAssetTypes(AssetTypeService assetTypeService) {
        this.assetTypeService = assetTypeService;
    }

    public Map<String, AssetTypeImpl> apply() {
        Map atscaleAssetTypesByName = ((IterableOnceOps)this.upsertAtscaleAssetTypes().map((Function1 & Serializable)assetType -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)assetType.getName());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, assetType);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Object[] objectArray = new Tuple2[3];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"Column");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.lookupCollibraAssetType(CollibraConstants$.MODULE$.AssetTypeColumnId()));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"Table");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)this.lookupCollibraAssetType(CollibraConstants$.MODULE$.AssetTypeTableId()));
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"Schema");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)this.lookupCollibraAssetType(CollibraConstants$.MODULE$.AssetTypeSchemaId()));
        Map collibraAssetTypesByName = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        return (Map)atscaleAssetTypesByName.$plus$plus((IterableOnce)collibraAssetTypesByName);
    }

    private AssetTypeImpl lookupCollibraAssetType(String id) {
        return (AssetTypeImpl)this.assetTypeService.getAssetTypeById(UUID.fromString(id)).getOrElse(() -> SetupAssetTypes.lookupCollibraAssetType$$anonfun$1(id));
    }

    private Seq<AssetTypeImpl> upsertAtscaleAssetTypes() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])AtscaleAssetType$.MODULE$.values());
        return (Seq)ArrayOps$.MODULE$.toIndexedSeq$extension(object).map((Function1 & Serializable)assetType -> {
            AssetTypeImpl resolvedAssetType = this.assetTypeService.findAssetTypeByName(assetType.name());
            if (resolvedAssetType != null) {
                return resolvedAssetType;
            }
            return this.assetTypeService.addAssetType((Option<UUID>)None$.MODULE$, assetType.name(), (Option<String>)Some$.MODULE$.apply((Object)assetType.description()));
        });
    }

    private static final AssetTypeImpl lookupCollibraAssetType$$anonfun$1(String id$1) {
        throw new IllegalStateException("Asset type with id " + id$1 + " not found");
    }
}

