/*
 * Decompiled with CFR 0.152.
 */
package com.collibra.marketplace.atscale.processor;

import com.collibra.marketplace.atscale.api.AtscaleService;
import com.collibra.marketplace.atscale.api.AuthContext;
import com.collibra.marketplace.atscale.collibra.service.ProjectService;
import com.collibra.marketplace.atscale.model.Attribute;
import com.collibra.marketplace.atscale.model.Dataset;
import com.collibra.marketplace.atscale.model.Measure;
import com.collibra.marketplace.atscale.model.Project;
import com.collibra.marketplace.atscale.processor.ProcessorLike;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class SyncCollibraToAtscaleProcessor
implements ProcessorLike {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(SyncCollibraToAtscaleProcessor.class.getDeclaredField("emptyJsonResponse$lzy1"));
    private volatile Object emptyJsonResponse$lzy1;
    private final AtscaleService atscaleService;

    public SyncCollibraToAtscaleProcessor(ProjectService projectService, AtscaleService atscaleService) {
        this.atscaleService = atscaleService;
        ProcessorLike.$init$(this);
    }

    @Override
    public JsonNode emptyJsonResponse() {
        Object object = this.emptyJsonResponse$lzy1;
        if (object instanceof JsonNode) {
            return (JsonNode)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (JsonNode)this.emptyJsonResponse$lzyINIT1();
    }

    private Object emptyJsonResponse$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.emptyJsonResponse$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    JsonNode jsonNode = null;
                    try {
                        jsonNode = ProcessorLike.emptyJsonResponse$(this);
                        object2 = jsonNode == null ? LazyVals.NullValue$.MODULE$ : jsonNode;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.emptyJsonResponse$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return jsonNode;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public JsonNode execute(AuthContext authCtx) {
        Map<String, Project> allProjects = this.atscaleService.retrieveProjects(authCtx);
        allProjects.foreach((Function1)(JProcedure1 & Serializable)x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 != null) {
                String projectId = (String)tuple2._1();
                Project project = (Project)tuple2._2();
                Iterable collibraProjectMeasureList = (Iterable)allProjects.flatMap((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        Project cProject = (Project)tuple2._2();
                        if (cProject.name().contains(projectId)) {
                            return cProject.measuresList();
                        }
                        return (Seq)package$.MODULE$.Seq().empty();
                    }
                    throw new MatchError((Object)tuple2);
                });
                Object[] objectArray = new Tuple2[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)projectId);
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)project);
                Seq<Measure> allMeasures = this.atscaleService.retrieveMeasures((Map<String, Project>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))), authCtx);
                if (collibraProjectMeasureList.nonEmpty()) {
                    Map collibraMeasureList = ((IterableOnceOps)collibraProjectMeasureList.map((Function1 & Serializable)measure -> {
                        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)(measure.cubeName().trim() + "-" + measure.measureName()));
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, measure);
                    })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                    Map<String, Measure> measuresToUpdate = this.compareMeasureDescription((Map<String, Measure>)collibraMeasureList, allMeasures);
                    if (measuresToUpdate.nonEmpty()) {
                        this.atscaleService.publishProject(projectId, project, measuresToUpdate, authCtx);
                        return;
                    }
                    return;
                }
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        return null;
    }

    public Map<String, Measure> compareMeasureDescription(Map<String, Measure> collibraProjectMeasureMap, Seq<Measure> allMeasures) {
        return ((IterableOnceOps)allMeasures.flatMap((Function1 & Serializable)atscaleMeasure -> {
            String measureKey = atscaleMeasure.cubeName() + "-" + atscaleMeasure.measureCaption();
            if (collibraProjectMeasureMap.contains((Object)measureKey)) {
                Measure collibraMeasure = (Measure)collibraProjectMeasureMap.getOrElse((Object)measureKey, () -> SyncCollibraToAtscaleProcessor.$anonfun$3(atscaleMeasure));
                if (collibraMeasure.attributeList().nonEmpty()) {
                    String string = ((Attribute)collibraMeasure.attributeList().head()).value();
                    String string2 = atscaleMeasure.description();
                    if (string == null ? string2 != null : !string.equals(string2)) {
                        String string3 = ((Attribute)collibraMeasure.attributeList().head()).value();
                        Integer n = atscaleMeasure.copy$default$1();
                        String string4 = atscaleMeasure.copy$default$2();
                        String string5 = atscaleMeasure.copy$default$3();
                        String string6 = atscaleMeasure.copy$default$4();
                        String string7 = atscaleMeasure.copy$default$5();
                        String string8 = atscaleMeasure.copy$default$6();
                        String string9 = atscaleMeasure.copy$default$7();
                        String string10 = atscaleMeasure.copy$default$8();
                        String string11 = atscaleMeasure.copy$default$9();
                        Integer n2 = atscaleMeasure.copy$default$10();
                        String string12 = atscaleMeasure.copy$default$11();
                        Integer n3 = atscaleMeasure.copy$default$12();
                        String string13 = atscaleMeasure.copy$default$13();
                        String string14 = atscaleMeasure.copy$default$14();
                        String string15 = atscaleMeasure.copy$default$15();
                        String string16 = atscaleMeasure.copy$default$16();
                        Integer n4 = atscaleMeasure.copy$default$17();
                        Integer n5 = atscaleMeasure.copy$default$18();
                        Integer n6 = atscaleMeasure.copy$default$19();
                        String string17 = atscaleMeasure.copy$default$21();
                        boolean bl = atscaleMeasure.copy$default$22();
                        String string18 = atscaleMeasure.copy$default$23();
                        String string19 = atscaleMeasure.copy$default$24();
                        String string20 = atscaleMeasure.copy$default$25();
                        String string21 = atscaleMeasure.copy$default$26();
                        String string22 = atscaleMeasure.copy$default$27();
                        String string23 = atscaleMeasure.copy$default$28();
                        String string24 = atscaleMeasure.copy$default$29();
                        Dataset dataset = atscaleMeasure.copy$default$30();
                        boolean bl2 = atscaleMeasure.copy$default$31();
                        String string25 = atscaleMeasure.copy$default$32();
                        String string26 = atscaleMeasure.copy$default$33();
                        Seq<Attribute> seq = atscaleMeasure.copy$default$34();
                        atscaleMeasure.copy(n, string4, string5, string6, string7, string8, string9, string10, string11, n2, string12, n3, string13, string14, string15, string16, n4, n5, n6, string3, string17, bl, string18, string19, string20, string21, string22, string23, string24, dataset, bl2, string25, string26, seq);
                        String string27 = (String)Predef$.MODULE$.ArrowAssoc((Object)atscaleMeasure.measureGUID());
                        return Some$.MODULE$.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string27, atscaleMeasure));
                    }
                }
                return None$.MODULE$;
            }
            return None$.MODULE$;
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private static final Measure $anonfun$3(Measure atscaleMeasure$1) {
        throw new RuntimeException("collibra measure not found " + atscaleMeasure$1.cubeName());
    }
}

