/*
 * Decompiled with CFR 0.152.
 */
package com.collibra.marketplace.atscale.processor;

import com.collibra.core.rest.client.model.AssetImpl;
import com.collibra.importer.rest.client.model.AssetImportCommand;
import com.collibra.importer.rest.client.model.Job;
import com.collibra.marketplace.atscale.AssetFormatConstants$;
import com.collibra.marketplace.atscale.api.AtscaleService;
import com.collibra.marketplace.atscale.api.AuthContext;
import com.collibra.marketplace.atscale.collibra.service.AssetService;
import com.collibra.marketplace.atscale.collibra.service.ImportService;
import com.collibra.marketplace.atscale.collibra.service.ProjectService;
import com.collibra.marketplace.atscale.config.ApplicationConfig;
import com.collibra.marketplace.atscale.model.AtscaleServiceConfig;
import com.collibra.marketplace.atscale.model.AtscaleServiceConfig$;
import com.collibra.marketplace.atscale.model.Column;
import com.collibra.marketplace.atscale.model.Connection;
import com.collibra.marketplace.atscale.model.ConnectionGroup;
import com.collibra.marketplace.atscale.model.Cube;
import com.collibra.marketplace.atscale.model.Dataset;
import com.collibra.marketplace.atscale.model.Dependency;
import com.collibra.marketplace.atscale.model.Dimension;
import com.collibra.marketplace.atscale.model.Folder;
import com.collibra.marketplace.atscale.model.Hierarchy;
import com.collibra.marketplace.atscale.model.Level;
import com.collibra.marketplace.atscale.model.Measure;
import com.collibra.marketplace.atscale.model.Project;
import com.collibra.marketplace.atscale.processor.ProcessorLike;
import com.collibra.marketplace.atscale.store.CollibraDataLoader;
import com.collibra.marketplace.atscale.store.CollibraInstanceData;
import com.collibra.marketplace.atscale.store.PhysicalMapLoader;
import com.collibra.marketplace.atscale.transformer.TransformAtscaleServiceInstance$;
import com.collibra.marketplace.atscale.transformer.TransformColumns$;
import com.collibra.marketplace.atscale.transformer.TransformConnectionGroups$;
import com.collibra.marketplace.atscale.transformer.TransformConnections$;
import com.collibra.marketplace.atscale.transformer.TransformCubes$;
import com.collibra.marketplace.atscale.transformer.TransformDatasets$;
import com.collibra.marketplace.atscale.transformer.TransformDimensions$;
import com.collibra.marketplace.atscale.transformer.TransformFolders$;
import com.collibra.marketplace.atscale.transformer.TransformHierarchies$;
import com.collibra.marketplace.atscale.transformer.TransformLevels$;
import com.collibra.marketplace.atscale.transformer.TransformMeasures$;
import com.collibra.marketplace.atscale.transformer.TransformProjects$;
import com.collibra.marketplace.atscale.transformer.package;
import com.collibra.marketplace.atscale.transformer.package$TransformContext$;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.Serializable;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.runtime.LazyRef;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class SyncAtscaleToCollibraProcessor
implements ProcessorLike {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(SyncAtscaleToCollibraProcessor.class.getDeclaredField("emptyJsonResponse$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(SyncAtscaleToCollibraProcessor.class.getDeclaredField("logger$lzy1"));
    private volatile Object emptyJsonResponse$lzy1;
    private final ApplicationConfig appConfig;
    private final CollibraDataLoader collibraDataLoader;
    private final AssetService assetService;
    private final AtscaleService atscaleService;
    private final ImportService importService;
    private final PhysicalMapLoader physicalMapLoader;
    private volatile Object logger$lzy1;

    public SyncAtscaleToCollibraProcessor(ApplicationConfig appConfig, CollibraDataLoader collibraDataLoader, AssetService assetService, ProjectService projectService, AtscaleService atscaleService, ImportService importService, PhysicalMapLoader physicalMapLoader) {
        this.appConfig = appConfig;
        this.collibraDataLoader = collibraDataLoader;
        this.assetService = assetService;
        this.atscaleService = atscaleService;
        this.importService = importService;
        this.physicalMapLoader = physicalMapLoader;
        ProcessorLike.$init$(this);
        boolean DoImports = true;
        int MAX_ASSETS_TO_LOAD = 6000;
    }

    @Override
    public JsonNode emptyJsonResponse() {
        Object object = this.emptyJsonResponse$lzy1;
        if (object instanceof JsonNode) {
            return (JsonNode)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (JsonNode)this.emptyJsonResponse$lzyINIT1();
    }

    private Object emptyJsonResponse$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.emptyJsonResponse$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    JsonNode jsonNode = null;
                    try {
                        jsonNode = ProcessorLike.emptyJsonResponse$(this);
                        object2 = jsonNode == null ? LazyVals.NullValue$.MODULE$ : jsonNode;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.emptyJsonResponse$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return jsonNode;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private final Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LoggerFactory.getLogger((String)"com.collibra.marketplace.atscale.processor.SyncAtscaleToCollibraProcessor");
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public JsonNode execute(AuthContext authCtx) {
        try {
            Map<String, Project> allProjects;
            Tuple2 tuple2;
            LazyRef lazyRef = new LazyRef();
            LazyRef lazyRef2 = new LazyRef();
            Seq<AssetImpl> assets = this.assetService.listObsoleteAssetsForDomainId(this.collibraData$1(lazyRef).businessAssetDomain().getId());
            Logger Logger_this = this.logger();
            if (Logger_this.isInfoEnabled()) {
                Logger_this.info("Found " + assets.size() + " obsolete assets for " + this.collibraData$1(lazyRef).businessAssetDomain().getName());
            }
            if ((tuple2 = (Tuple2)(allProjects = this.atscaleService.retrieveProjects(authCtx)).foldLeft((Object)Tuple2$.MODULE$.apply((Object)package$.MODULE$.Seq().empty(), (Object)package$.MODULE$.Seq().empty()), (Function2 & Serializable)(x$1, x$2) -> {
                Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    Tuple2 tuple23 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        Seq allCurrentAssets = (Seq)tuple22._1();
                        Seq allCurrentFailed = (Seq)tuple22._2();
                        if (tuple23 != null) {
                            String projectName = (String)tuple23._1();
                            Project project = (Project)tuple23._2();
                            LazyRef lazyRef = new LazyRef();
                            Logger Logger_this = this.logger();
                            if (Logger_this.isDebugEnabled()) {
                                Logger_this.debug("Synchronizing project metadata " + projectName + " -> " + project);
                            }
                            Set ignoreHierarchySet = (Set)Set$.MODULE$.empty();
                            Object[] objectArray = new Tuple2[1];
                            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)projectName);
                            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)project);
                            Map currentProject = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
                            Seq<Cube> allCubes = this.atscaleService.retrieveCubes((Map<String, Project>)currentProject, authCtx);
                            Seq<Measure> allMeasures = this.atscaleService.retrieveMeasures((Map<String, Project>)currentProject, authCtx);
                            Seq<Dimension> allDimensions = this.atscaleService.retrieveDimensions((Map<String, Project>)currentProject, authCtx);
                            Seq<Hierarchy> allHierarchies = this.atscaleService.retrieveHierarchies((Map<String, Project>)currentProject, authCtx);
                            Seq<Level> allLevels = this.atscaleService.retrieveLevels((Map<String, Project>)currentProject, authCtx);
                            Map<String, Folder> allFolders = this.atscaleService.retrieveFolders(allMeasures, allHierarchies, authCtx);
                            Seq<ConnectionGroup> allConnectionGroups = this.atscaleService.retrieveConnectionGroups(authCtx);
                            Seq<Connection> allConnections = this.atscaleService.retrieveConnections(authCtx);
                            Seq<Dataset> allDatasets = this.atscaleService.retrieveDatasets((Map<String, Project>)currentProject, authCtx);
                            Seq<Column> allColumns = this.atscaleService.retrieveColumns((Map<String, Project>)currentProject, authCtx);
                            Seq<Dependency> allDependencies = this.atscaleService.retrieveDependencies((Map<String, Project>)currentProject, allColumns, authCtx);
                            Seq<Hierarchy> filteredHierarchies = this.removeHiddenDimensions(allHierarchies, allDimensions);
                            Seq<Level> filteredLevels = this.removeHiddenHierarchies(allLevels, filteredHierarchies);
                            AssetImportCommand atscaleServiceAsset = TransformAtscaleServiceInstance$.MODULE$.apply(this.ctx$3(lazyRef, lazyRef2, lazyRef));
                            Seq<AssetImportCommand> projectAssets = TransformProjects$.MODULE$.apply((Seq<Project>)currentProject.values().toSeq(), allDatasets, this.ctx$3(lazyRef, lazyRef2, lazyRef));
                            Seq<AssetImportCommand> cubeAssets = TransformCubes$.MODULE$.apply(allCubes, this.ctx$3(lazyRef, lazyRef2, lazyRef));
                            Map<String, String> physicalMap = this.physicalMapLoader.createPhysicalMap(allDatasets);
                            Seq<AssetImportCommand> measureAssets = TransformMeasures$.MODULE$.apply(allMeasures, allDependencies, allDatasets, allColumns, allConnectionGroups, physicalMap, this.ctx$3(lazyRef, lazyRef2, lazyRef));
                            Seq<AssetImportCommand> folderAssets = TransformFolders$.MODULE$.apply(allFolders, this.ctx$3(lazyRef, lazyRef2, lazyRef));
                            Seq<AssetImportCommand> dimensionAssets = TransformDimensions$.MODULE$.apply(allDimensions, this.ctx$3(lazyRef, lazyRef2, lazyRef));
                            Seq<AssetImportCommand> levelAssets = TransformLevels$.MODULE$.apply(filteredLevels, allColumns, allDatasets, allConnectionGroups, physicalMap, (Set<String>)ignoreHierarchySet, this.ctx$3(lazyRef, lazyRef2, lazyRef));
                            Seq<AssetImportCommand> hierarchyAssets = TransformHierarchies$.MODULE$.apply(filteredHierarchies, filteredLevels, allDatasets, (Set<String>)ignoreHierarchySet, this.ctx$3(lazyRef, lazyRef2, lazyRef));
                            Seq<AssetImportCommand> connectionGroupAssets = TransformConnectionGroups$.MODULE$.apply(allConnectionGroups, this.ctx$3(lazyRef, lazyRef2, lazyRef));
                            Seq<AssetImportCommand> connectionAssets = TransformConnections$.MODULE$.apply(allConnections, allConnectionGroups, connectionGroupAssets, this.ctx$3(lazyRef, lazyRef2, lazyRef));
                            Seq<AssetImportCommand> columnAssets = TransformColumns$.MODULE$.apply(this.appConfig, allColumns, allDependencies, allDatasets, allConnectionGroups, physicalMap, this.ctx$3(lazyRef, lazyRef2, lazyRef));
                            Seq<AssetImportCommand> datasetAssets = TransformDatasets$.MODULE$.apply(this.appConfig, allDatasets, allConnectionGroups, physicalMap, this.ctx$3(lazyRef, lazyRef2, lazyRef));
                            this.importService.importData((Seq<AssetImportCommand>)((Seq)((IterableOps)((IterableOps)((IterableOps)((IterableOps)((IterableOps)((IterableOps)((IterableOps)((IterableOps)((IterableOps)((IterableOps)((SeqOps)new .colon.colon((Object)atscaleServiceAsset, (List)Nil$.MODULE$)).$plus$plus(projectAssets)).$plus$plus(connectionGroupAssets)).$plus$plus(connectionAssets)).$plus$plus(datasetAssets)).$plus$plus(columnAssets)).$plus$plus(cubeAssets)).$plus$plus(measureAssets)).$plus$plus(folderAssets)).$plus$plus(dimensionAssets)).$plus$plus(levelAssets)).$plus$plus(hierarchyAssets)));
                            return Tuple2$.MODULE$.apply(allCurrentAssets.$plus$plus(projectAssets), (Object)allCurrentFailed);
                        }
                    }
                }
                throw new MatchError((Object)tuple2);
            })) == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq allAssetsLoaded = (Seq)tuple2._1();
            Seq failedProjects = (Seq)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)allAssetsLoaded, (Object)failedProjects);
            Seq allAssetsLoaded2 = (Seq)tuple22._1();
            Seq failedProjects2 = (Seq)tuple22._2();
            Logger Logger_this2 = this.logger();
            if (Logger_this2.isInfoEnabled()) {
                Logger_this2.info("Setting obsolete assets...");
            }
            Map<String, Project> allAddedProjects = this.addAllSuccessfulProjects(allProjects, (ListBuffer<String>)ListBuffer$.MODULE$.from((IterableOnce)failedProjects2));
            Logger Logger_this3 = this.logger();
            if (Logger_this3.isInfoEnabled()) {
                Logger_this3.info("Finished synchronizing the metadata for all projects");
            }
        }
        catch (Exception ex) {
            Logger Logger_this = this.logger();
            if (Logger_this.isErrorEnabled()) {
                Logger_this.error("Error synchronizing atscale metadata with collibra.", (Throwable)ex);
            }
            throw ex;
        }
        return null;
    }

    private void loadAllAssetsForProject(Seq<AssetImportCommand> levelAssets, Seq<AssetImportCommand> measureAssets, Seq<AssetImportCommand> sharedAssets, String projectName, Project project, Seq<AssetImportCommand> assetsByCube, Seq<AssetImportCommand> folderAssets, Map<String, String> physicalMap, ListBuffer<String> failedProjects, ListBuffer<AssetImportCommand> allAssets, Seq<AssetImportCommand> cubeAssets, ListBuffer<AssetImportCommand> assetsToCheck, Seq<AssetImportCommand> dimensionAssets, package.TransformContext ctx) {
        if (levelAssets.size() + measureAssets.size() + sharedAssets.size() < 6000) {
            Logger Logger_this = this.logger();
            if (Logger_this.isInfoEnabled()) {
                Logger_this.info("Loading all assets for project '" + projectName + "' in a single import call");
            }
            Seq assetsToLoad = (Seq)sharedAssets.$plus$plus(assetsByCube);
            this.validateAllAssets((Seq<AssetImportCommand>)assetsToLoad, physicalMap, "", ctx);
            this.importAssets((Seq<AssetImportCommand>)assetsToLoad, failedProjects, projectName, "", ctx);
            return;
        }
        this.loadProjectByCube(cubeAssets, allAssets, assetsToCheck, assetsByCube, measureAssets, folderAssets, sharedAssets, projectName, project, physicalMap, failedProjects, dimensionAssets, ctx);
    }

    private void loadProjectByCube(Seq<AssetImportCommand> cubeAssets, ListBuffer<AssetImportCommand> allAssets, ListBuffer<AssetImportCommand> assetsToCheck, Seq<AssetImportCommand> assetsByCube, Seq<AssetImportCommand> measureAssets, Seq<AssetImportCommand> folderAssets, Seq<AssetImportCommand> sharedAssets, String projectName, Project project, Map<String, String> physicalMap, ListBuffer<String> failedProjects, Seq<AssetImportCommand> dimensionAssets, package.TransformContext ctx) {
        Logger Logger_this = this.logger();
        if (Logger_this.isWarnEnabled()) {
            Logger_this.warn("Can't load full project '" + projectName + "' because of size constraints so loading by individual cube");
        }
        cubeAssets.foreach((Function1)(JProcedure1 & Serializable)cube -> {
            allAssets.$plus$eq(cube);
            Seq assetsToCheck = (Seq)((IterableOps)assetsByCube.$plus$plus((IterableOnce)measureAssets)).$plus$plus((IterableOnce)folderAssets);
            Seq assetsToLoad = (Seq)assetsToCheck.filter((Function1 & Serializable)asset -> asset.getName().startsWith(cube.getName() + AssetFormatConstants$.MODULE$.ASSET_NAME_SEPARATOR()));
            this.loadCubeAssets((Seq<AssetImportCommand>)assetsToLoad, assetsByCube, sharedAssets, measureAssets, projectName, project, (AssetImportCommand)cube, allAssets, physicalMap, failedProjects, folderAssets, dimensionAssets, ctx);
        });
    }

    private void loadCubeAssets(Seq<AssetImportCommand> assetsToLoad, Seq<AssetImportCommand> assetsByCube, Seq<AssetImportCommand> sharedAssets, Seq<AssetImportCommand> measureAssets, String projectName, Project project, AssetImportCommand cube, ListBuffer<AssetImportCommand> allAssets, Map<String, String> physicalMap, ListBuffer<String> failedProjects, Seq<AssetImportCommand> folderAssets, Seq<AssetImportCommand> dimensionAssets, package.TransformContext ctx) {
        if (assetsToLoad.size() + sharedAssets.size() < 6000) {
            Logger Logger_this = this.logger();
            if (Logger_this.isInfoEnabled()) {
                Logger_this.info("Loading all assets for cube '" + projectName + "." + cube.getDisplayName() + "'");
            }
            allAssets.$plus$plus$eq(assetsToLoad);
            Seq toLoad = (Seq)((SeqOps)assetsToLoad.$plus$plus((IterableOnce)sharedAssets.toSeq())).$colon$plus((Object)cube);
            this.validateAllAssets((Seq<AssetImportCommand>)toLoad, physicalMap, cube.getDisplayName(), ctx);
            this.importAssets((Seq<AssetImportCommand>)toLoad, failedProjects, projectName, cube.getDisplayName(), ctx);
            return;
        }
        Logger Logger_this = this.logger();
        if (Logger_this.isWarnEnabled()) {
            Logger_this.warn("Can't load cube '" + projectName + "." + cube.getDisplayName() + "' because of size constraints so loading by individual dimension");
        }
        Seq<AssetImportCommand> cubeFolderAssets = this.filterCubeFolderAssets(folderAssets, cube);
        allAssets.$plus$plus$eq(cubeFolderAssets);
        ListBuffer combinedAssets = ListBuffer$.MODULE$.empty();
        ListBuffer dimList = ListBuffer$.MODULE$.empty();
        this.processDimensions(dimensionAssets, assetsToLoad, assetsByCube, cube, allAssets, sharedAssets, cubeFolderAssets, projectName, project, physicalMap, failedProjects, (ListBuffer<AssetImportCommand>)combinedAssets, (ListBuffer<String>)dimList, ctx);
        this.loadAssetsForSmallerDimensionsInCube((ListBuffer<AssetImportCommand>)combinedAssets, sharedAssets, cubeFolderAssets, cube, (ListBuffer<String>)dimList, projectName, project, physicalMap, failedProjects, ctx);
        Seq<AssetImportCommand> measureAssetsToLoad = this.filterMeasureAssetsByCube(cube, measureAssets);
        allAssets.$plus$plus$eq(measureAssetsToLoad);
        Seq allMeasureAssetsToLoad = (Seq)((SeqOps)((IterableOps)measureAssetsToLoad.$plus$plus((IterableOnce)sharedAssets.toSeq())).$plus$plus(cubeFolderAssets)).$colon$plus((Object)cube);
        Logger Logger_this2 = this.logger();
        if (Logger_this2.isInfoEnabled()) {
            Logger_this2.info("Loading all assets for measures in cube '" + projectName + "." + cube.getDisplayName() + "'");
        }
        this.validateAllAssets((Seq<AssetImportCommand>)allMeasureAssetsToLoad, physicalMap, "measures", ctx);
        this.importAssets((Seq<AssetImportCommand>)allMeasureAssetsToLoad, failedProjects, projectName, "measures", ctx);
    }

    private Seq<AssetImportCommand> filterCubeFolderAssets(Seq<AssetImportCommand> folderAssets, AssetImportCommand cube) {
        return (Seq)folderAssets.filter((Function1 & Serializable)asset -> asset.getName().startsWith(cube.getName() + AssetFormatConstants$.MODULE$.ASSET_NAME_SEPARATOR()));
    }

    private void processDimensions(Seq<AssetImportCommand> dimensionAssets, Seq<AssetImportCommand> assetsToLoad, Seq<AssetImportCommand> assetsByCube, AssetImportCommand cube, ListBuffer<AssetImportCommand> allAssets, Seq<AssetImportCommand> sharedAssets, Seq<AssetImportCommand> cubeFolderAssets, String projectName, Project project, Map<String, String> physicalMap, ListBuffer<String> failedProjects, ListBuffer<AssetImportCommand> combinedAssets, ListBuffer<String> dimList, package.TransformContext ctx) {
        dimensionAssets.foreach((Function1)(JProcedure1 & Serializable)dim -> {
            Seq filteredAssetsToLoad = (Seq)assetsByCube.filter((Function1 & Serializable)asset -> asset.getName().startsWith(cube.getName() + AssetFormatConstants$.MODULE$.ASSET_NAME_SEPARATOR()) && asset.getName().startsWith(dim.getName()));
            Seq moreAssetsToLoad = (Seq)assetsByCube.filter((Function1 & Serializable)asset -> asset.getName().startsWith(cube.getName() + AssetFormatConstants$.MODULE$.ASSET_NAME_SEPARATOR()) && asset.getName().startsWith(dim.getName()));
            this.processDimensionAssets((Seq<AssetImportCommand>)((Seq)filteredAssetsToLoad.$plus$plus((IterableOnce)moreAssetsToLoad)), allAssets, sharedAssets, cubeFolderAssets, cube, projectName, project, (AssetImportCommand)dim, physicalMap, failedProjects, combinedAssets, dimList, ctx);
        });
    }

    private Seq<AssetImportCommand> filterMeasureAssetsByCube(AssetImportCommand cube, Seq<AssetImportCommand> measureAssets) {
        return (Seq)measureAssets.filter((Function1 & Serializable)measure -> measure.getName().startsWith(cube.getName() + AssetFormatConstants$.MODULE$.ASSET_NAME_SEPARATOR()));
    }

    private void processDimensionAssets(Seq<AssetImportCommand> assetsToLoad, ListBuffer<AssetImportCommand> allAssets, Seq<AssetImportCommand> sharedAssets, Seq<AssetImportCommand> cubeFolderAssets, AssetImportCommand cube, String projectName, Project project, AssetImportCommand dim, Map<String, String> physicalMap, ListBuffer<String> failedProjects, ListBuffer<AssetImportCommand> combinedAssets, ListBuffer<String> dimList, package.TransformContext ctx) {
        allAssets.$plus$plus$eq(assetsToLoad);
        if (assetsToLoad.size() >= 300) {
            Seq dimensionAssetsToLoad = (Seq)((SeqOps)sharedAssets.toSeq().$plus$plus(cubeFolderAssets)).$colon$plus((Object)cube);
            Logger Logger_this = this.logger();
            if (Logger_this.isInfoEnabled()) {
                Logger_this.info("Loading all assets for dimension '" + projectName + "." + cube.getDisplayName() + "." + dim.getDisplayName() + "'");
            }
            this.validateAllAssets((Seq<AssetImportCommand>)dimensionAssetsToLoad, physicalMap, dim.getDisplayName(), ctx);
            this.importAssets((Seq<AssetImportCommand>)dimensionAssetsToLoad, failedProjects, projectName, dim.getDisplayName(), ctx);
            return;
        }
        combinedAssets.$plus$plus$eq(assetsToLoad);
        dimList.$plus$eq((Object)dim.getDisplayName());
    }

    private void loadAssetsForSmallerDimensionsInCube(ListBuffer<AssetImportCommand> combinedAssets, Seq<AssetImportCommand> sharedAssets, Seq<AssetImportCommand> cubeFolderAssets, AssetImportCommand cube, ListBuffer<String> dimList, String projectName, Project project, Map<String, String> physicalMap, ListBuffer<String> failedProjects, package.TransformContext ctx) {
        if (!combinedAssets.isEmpty()) {
            Seq combinedAssetsToLoad = (Seq)((SeqOps)sharedAssets.toSeq().$plus$plus(cubeFolderAssets)).$colon$plus((Object)cube);
            Logger Logger_this = this.logger();
            if (Logger_this.isInfoEnabled()) {
                Logger_this.info("Loading all assets for smaller dimensions (" + dimList + ") in cube '" + projectName + "." + cube.getDisplayName() + "'");
            }
            this.validateAllAssets((Seq<AssetImportCommand>)combinedAssetsToLoad, physicalMap, cube.getDisplayName(), ctx);
            this.importAssets((Seq<AssetImportCommand>)combinedAssetsToLoad, failedProjects, projectName, cube.getDisplayName(), ctx);
            return;
        }
    }

    private Map<String, Project> addAllSuccessfulProjects(Map<String, Project> projectsMap, ListBuffer<String> failedProjects) {
        return (Map)projectsMap.flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                Project v = (Project)tuple2._2();
                if (!failedProjects.contains((Object)k)) {
                    return Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)k, (Object)v));
                }
            }
            return None$.MODULE$;
        });
    }

    private void importAssets(Seq<AssetImportCommand> assets, ListBuffer<String> failedProjects, String projectName, String cubeName, package.TransformContext ctx) {
        block14: {
            block13: {
                try {
                    Job job = this.importService.importData(assets);
                }
                catch (Exception e) {
                    Logger Logger_this = this.logger();
                    if (!Logger_this.isErrorEnabled()) break block13;
                    Logger_this.error("Error saving assets to file", (Throwable)e);
                }
            }
            if (cubeName.isEmpty()) {
                Logger Logger_this = this.logger();
                if (Logger_this.isInfoEnabled()) {
                    Logger_this.info("Importing " + assets.size() + " assets");
                }
            } else {
                Logger Logger_this = this.logger();
                if (Logger_this.isInfoEnabled()) {
                    Logger_this.info("Importing " + assets.size() + " assets for cube '" + cubeName + "'");
                }
            }
            UUID importId = UUID.randomUUID();
            boolean isSuccessful = false;
            try {
                Logger Logger_this = this.logger();
                if (Logger_this.isInfoEnabled()) {
                    Logger_this.info("Starting import of assets into Collibra with UUID: " + importId);
                }
                isSuccessful = true;
            }
            catch (Exception e) {
                failedProjects.$plus$eq((Object)projectName);
                Logger Logger_this = this.logger();
                if (!Logger_this.isErrorEnabled()) break block14;
                Logger_this.error("Import for project '" + projectName + "' failed so will be skipped", (Throwable)e);
            }
        }
        if (cubeName.isEmpty()) {
            Logger Logger_this = this.logger();
            if (Logger_this.isInfoEnabled()) {
                Logger_this.info("Finished importing the metadata for project '" + projectName + "'");
            }
        } else {
            Logger Logger_this = this.logger();
            if (Logger_this.isInfoEnabled()) {
                Logger_this.info("Finished importing the metadata for cube '" + projectName + "." + cubeName + "'");
            }
        }
    }

    private Seq<Hierarchy> removeHiddenDimensions(Seq<Hierarchy> allHierarchies, Seq<Dimension> allDimensions) {
        return (Seq)allHierarchies.flatMap((Function1 & Serializable)x$1 -> {
            block1: {
                Hierarchy hierarchy = x$1;
                Hierarchy hierarchy2 = hierarchy;
                if (allDimensions.exists((Function1 & Serializable)dim -> {
                    String string = hierarchy2.dimensionUniqueName();
                    String string2 = dim.dimensionUniqueName();
                    return !(string != null ? !string.equals(string2) : string2 != null);
                })) {
                    return Some$.MODULE$.apply((Object)hierarchy2);
                }
                Hierarchy hierarchy3 = hierarchy;
                Logger Logger_this = this.logger();
                if (!Logger_this.isInfoEnabled()) break block1;
                Logger_this.info("Hierarchy " + hierarchy3.hierarchyUniqueName() + " will not be added since its dimension is not found. It may be marked as invisible or be part of a security dimension");
            }
            return None$.MODULE$;
        });
    }

    private Seq<Level> removeHiddenHierarchies(Seq<Level> allLevels, Seq<Hierarchy> allHierarchies) {
        return (Seq)allLevels.flatMap((Function1 & Serializable)x$1 -> {
            block1: {
                Level level = x$1;
                Level level2 = level;
                if (allHierarchies.exists((Function1 & Serializable)hierachy -> {
                    String string = level2.hierarchyUniqueName();
                    String string2 = hierachy.hierarchyUniqueName();
                    return !(string != null ? !string.equals(string2) : string2 != null);
                })) {
                    return Some$.MODULE$.apply((Object)level2);
                }
                Level level3 = level;
                Logger Logger_this = this.logger();
                if (!Logger_this.isInfoEnabled()) break block1;
                Logger_this.info("Level " + level3.levelUniqueName() + " will not be added since its hierarchy is not found. It may be marked as invisible or be part of a security dimension");
            }
            return None$.MODULE$;
        });
    }

    private void validateAllAssets(Seq<AssetImportCommand> allAssets, Map<String, String> physicalMap, String cubeName, package.TransformContext ctx) {
        Predef$.MODULE$.println((Object)"TODO: VALIDATE");
    }

    private final CollibraInstanceData collibraData$lzyINIT1$1(LazyRef collibraData$lzy1$1) {
        CollibraInstanceData collibraInstanceData;
        LazyRef lazyRef = collibraData$lzy1$1;
        synchronized (lazyRef) {
            collibraInstanceData = (CollibraInstanceData)(collibraData$lzy1$1.initialized() ? collibraData$lzy1$1.value() : collibraData$lzy1$1.initialize((Object)this.collibraDataLoader.load()));
        }
        return collibraInstanceData;
    }

    private final CollibraInstanceData collibraData$1(LazyRef collibraData$lzy1$2) {
        return (CollibraInstanceData)(collibraData$lzy1$2.initialized() ? collibraData$lzy1$2.value() : this.collibraData$lzyINIT1$1(collibraData$lzy1$2));
    }

    private final AtscaleServiceConfig atscaleServiceConfig$lzyINIT1$1(LazyRef atscaleServiceConfig$lzy1$1) {
        AtscaleServiceConfig atscaleServiceConfig;
        LazyRef lazyRef = atscaleServiceConfig$lzy1$1;
        synchronized (lazyRef) {
            atscaleServiceConfig = (AtscaleServiceConfig)(atscaleServiceConfig$lzy1$1.initialized() ? atscaleServiceConfig$lzy1$1.value() : atscaleServiceConfig$lzy1$1.initialize((Object)AtscaleServiceConfig$.MODULE$.apply(this.appConfig)));
        }
        return atscaleServiceConfig;
    }

    private final AtscaleServiceConfig atscaleServiceConfig$1(LazyRef atscaleServiceConfig$lzy1$2) {
        return (AtscaleServiceConfig)(atscaleServiceConfig$lzy1$2.initialized() ? atscaleServiceConfig$lzy1$2.value() : this.atscaleServiceConfig$lzyINIT1$1(atscaleServiceConfig$lzy1$2));
    }

    private final package.TransformContext ctx$lzyINIT1$1(LazyRef ctx$lzy1$1, LazyRef atscaleServiceConfig$lzy1$3, LazyRef collibraData$lzy1$3) {
        package.TransformContext transformContext;
        LazyRef lazyRef = ctx$lzy1$1;
        synchronized (lazyRef) {
            transformContext = (package.TransformContext)(ctx$lzy1$1.initialized() ? ctx$lzy1$1.value() : ctx$lzy1$1.initialize((Object)package$TransformContext$.MODULE$.apply(this.atscaleServiceConfig$1(atscaleServiceConfig$lzy1$3), this.collibraData$1(collibraData$lzy1$3))));
        }
        return transformContext;
    }

    private final package.TransformContext ctx$3(LazyRef ctx$lzy1$2, LazyRef atscaleServiceConfig$lzy1$4, LazyRef collibraData$lzy1$4) {
        return (package.TransformContext)(ctx$lzy1$2.initialized() ? ctx$lzy1$2.value() : this.ctx$lzyINIT1$1(ctx$lzy1$2, atscaleServiceConfig$lzy1$4, collibraData$lzy1$4));
    }
}

