/*
 * Decompiled with CFR 0.152.
 */
package com.collibra.marketplace.atscale.processor;

import com.collibra.core.rest.client.model.AssetTypeImpl;
import com.collibra.core.rest.client.model.AttributeType;
import com.collibra.core.rest.client.model.RelationTypeImpl;
import com.collibra.marketplace.atscale.api.AuthContext;
import com.collibra.marketplace.atscale.collibra.service.AssetTypeService;
import com.collibra.marketplace.atscale.collibra.service.AttributeTypeService;
import com.collibra.marketplace.atscale.collibra.service.DomainService;
import com.collibra.marketplace.atscale.collibra.service.RelationTypeService;
import com.collibra.marketplace.atscale.store.CollibraDataLoader;
import com.collibra.marketplace.atscale.store.CollibraInstanceData;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;

public class RemoveAtscaleTypesProcessor {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(RemoveAtscaleTypesProcessor.class.getDeclaredField("logger$lzy1"));
    private final CollibraDataLoader collibraDataLoader;
    private final AssetTypeService assetTypeService;
    private final RelationTypeService relationTypeService;
    private final AttributeTypeService attributeTypeService;
    private final DomainService domainService;
    private volatile Object logger$lzy1;

    public RemoveAtscaleTypesProcessor(CollibraDataLoader collibraDataLoader, AssetTypeService assetTypeService, RelationTypeService relationTypeService, AttributeTypeService attributeTypeService, DomainService domainService) {
        this.collibraDataLoader = collibraDataLoader;
        this.assetTypeService = assetTypeService;
        this.relationTypeService = relationTypeService;
        this.attributeTypeService = attributeTypeService;
        this.domainService = domainService;
    }

    private final Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LoggerFactory.getLogger((String)"com.collibra.marketplace.atscale.processor.RemoveAtscaleTypesProcessor");
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public JsonNode execute(AuthContext authCtx) {
        block0: {
            CollibraInstanceData collibraData = this.collibraDataLoader.load();
            collibraData.relationTypes().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    RelationTypeImpl rt = (RelationTypeImpl)tuple2._2();
                    this.relationTypeService.removeRelationType(rt);
                    return;
                }
                throw new MatchError((Object)tuple2);
            });
            collibraData.assetTypesByName().values().foreach((Function1)(JProcedure1 & Serializable)assetType -> this.assetTypeService.removeAssetType((AssetTypeImpl)assetType));
            collibraData.attributeTypesByName().values().foreach((Function1)(JProcedure1 & Serializable)attributeType -> this.attributeTypeService.removeAttributeType((AttributeType)attributeType));
            this.domainService.removeDomain(collibraData.businessAssetDomain());
            this.domainService.removeDomain(collibraData.dataAssetDomain());
            Logger Logger_this = this.logger();
            if (!Logger_this.isInfoEnabled()) break block0;
            Logger_this.info("Successfully removed all AtScale resource types from Collibra platform");
        }
        return null;
    }
}

