/*
 * Decompiled with CFR 0.152.
 */
package com.collibra.marketplace.atscale.processor;

import com.collibra.core.rest.client.model.AssetImpl;
import com.collibra.core.rest.client.model.DomainImpl;
import com.collibra.marketplace.atscale.api.AuthContext;
import com.collibra.marketplace.atscale.collibra.service.AssetService;
import com.collibra.marketplace.atscale.processor.ProcessorLike;
import com.collibra.marketplace.atscale.store.CollibraDataLoader;
import com.collibra.marketplace.atscale.store.CollibraInstanceData;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.collection.immutable.Seq;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;

public class RemoveAssetsProcessor
implements ProcessorLike {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(RemoveAssetsProcessor.class.getDeclaredField("emptyJsonResponse$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(RemoveAssetsProcessor.class.getDeclaredField("logger$lzy1"));
    private volatile Object emptyJsonResponse$lzy1;
    private final CollibraDataLoader collibraDataLoader;
    private final AssetService assetService;
    private volatile Object logger$lzy1;

    public RemoveAssetsProcessor(CollibraDataLoader collibraDataLoader, AssetService assetService) {
        this.collibraDataLoader = collibraDataLoader;
        this.assetService = assetService;
        ProcessorLike.$init$(this);
    }

    @Override
    public JsonNode emptyJsonResponse() {
        Object object = this.emptyJsonResponse$lzy1;
        if (object instanceof JsonNode) {
            return (JsonNode)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (JsonNode)this.emptyJsonResponse$lzyINIT1();
    }

    private Object emptyJsonResponse$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.emptyJsonResponse$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    JsonNode jsonNode = null;
                    try {
                        jsonNode = ProcessorLike.emptyJsonResponse$(this);
                        object2 = jsonNode == null ? LazyVals.NullValue$.MODULE$ : jsonNode;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.emptyJsonResponse$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return jsonNode;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private final Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LoggerFactory.getLogger((String)"com.collibra.marketplace.atscale.processor.RemoveAssetsProcessor");
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public JsonNode execute(AuthContext authCtx) {
        block0: {
            CollibraInstanceData collibraData = this.collibraDataLoader.load();
            this.removeAssetsForDomain(collibraData.businessAssetDomain());
            this.removeAssetsForDomain(collibraData.dataAssetDomain());
            Logger Logger_this = this.logger();
            if (!Logger_this.isInfoEnabled()) break block0;
            Logger_this.info("Successfully deleted all AtScale assets from Collibra");
        }
        return this.emptyJsonResponse();
    }

    private void removeAssetsForDomain(DomainImpl domain) {
        Seq<AssetImpl> assets = this.assetService.listAssetsForDomainId(domain.getId());
        Logger Logger_this = this.logger();
        if (Logger_this.isInfoEnabled()) {
            Logger_this.info("Deleting " + assets.size() + " AtScale asset(s) from domain " + domain.getName());
        }
        assets.foreach((Function1)(JProcedure1 & Serializable)asset -> this.assetService.removeAsset((AssetImpl)asset));
    }
}

