/*
 * Decompiled with CFR 0.152.
 */
package com.collibra.marketplace.atscale.jobs;

import com.collibra.core.rest.client.api.JobsApi;
import com.collibra.core.rest.client.model.Job;
import com.collibra.marketplace.atscale.jobs.JobsPoller$;
import feign.FeignException;
import java.time.Duration;
import java.time.Instant;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Some$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public class JobsPoller {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(JobsPoller.class.getDeclaredField("logger$lzy1"));
    private final JobsApi jobsApi;
    private volatile Object logger$lzy1;

    public JobsPoller(JobsApi jobsApi) {
        this.jobsApi = jobsApi;
    }

    private final Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LoggerFactory.getLogger((String)"com.collibra.marketplace.atscale.jobs.JobsPoller");
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Job waitUntilJobIsCompleted(UUID jobId) {
        Instant start = Instant.now();
        Job job = this.getJobWithNotFoundExceptionHandled(jobId);
        while (!this.isJobFinished(job) && !this.isTimeoutExceeded(start)) {
            Logger Logger_this = this.logger();
            if (Logger_this.isDebugEnabled()) {
                Logger_this.debug("Job with id " + jobId + " is not finished. Delay for " + JobsPoller$.com$collibra$marketplace$atscale$jobs$JobsPoller$$$POLLING_INTERVAL_SECONDS + " s and call getJob again.");
            }
            this.delay(Int$.MODULE$.int2long(JobsPoller$.com$collibra$marketplace$atscale$jobs$JobsPoller$$$POLLING_INTERVAL_SECONDS));
            job = this.jobsApi.getJob(jobId);
        }
        if (!this.isJobFinished(job)) {
            throw new JobNotFinishedException(job);
        }
        if (!this.isJobCompleted(job)) {
            Logger Logger_this = this.logger();
            if (Logger_this.isInfoEnabled()) {
                Logger_this.info("Error completing job " + job.getMessage());
            }
            throw new JobNotCompletedException(job);
        }
        return job;
    }

    private boolean isTimeoutExceeded(Instant startTime) {
        return Duration.between(startTime, Instant.now()).getSeconds() > (long)JobsPoller$.com$collibra$marketplace$atscale$jobs$JobsPoller$$$WAIT_TIMEOUT_60_SECONDS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isJobFinished(Job job) {
        Job.StateEnum state;
        Job.StateEnum stateEnum = state = job.getState();
        Job.StateEnum stateEnum2 = Job.StateEnum.COMPLETED;
        if (stateEnum == null) {
            if (stateEnum2 == null) return true;
        } else if (((Object)((Object)stateEnum)).equals((Object)stateEnum2)) return true;
        Job.StateEnum stateEnum3 = state;
        Job.StateEnum stateEnum4 = Job.StateEnum.ERROR;
        if (stateEnum3 == null) {
            if (stateEnum4 == null) return true;
        } else if (((Object)((Object)stateEnum3)).equals((Object)stateEnum4)) return true;
        Job.StateEnum stateEnum5 = state;
        Job.StateEnum stateEnum6 = Job.StateEnum.CANCELED;
        if (stateEnum5 != null) {
            if (!((Object)((Object)stateEnum5)).equals((Object)stateEnum6)) return false;
            return true;
        }
        if (stateEnum6 == null) return true;
        return false;
    }

    private boolean isJobCompleted(Job job) {
        Job.StateEnum stateEnum = job.getState();
        Job.StateEnum stateEnum2 = Job.StateEnum.COMPLETED;
        return !(stateEnum != null ? !((Object)((Object)stateEnum)).equals((Object)stateEnum2) : stateEnum2 != null);
    }

    private void delay(long seconds) {
        Thread.sleep(TimeUnit.SECONDS.toMillis(seconds));
    }

    private Job getJobWithNotFoundExceptionHandled(UUID jobId) {
        None$ optionalJob = None$.MODULE$;
        Instant start = Instant.now();
        while (optionalJob.isEmpty() && Duration.between(start, Instant.now()).getSeconds() < (long)JobsPoller$.com$collibra$marketplace$atscale$jobs$JobsPoller$$$POLLING_VALUE_FOR_FIRST_GET_JOB_SECONDS) {
            FeignException e;
            Throwable throwable;
            Try try_ = Try$.MODULE$.apply(() -> this.getJobWithNotFoundExceptionHandled$$anonfun$1(jobId));
            if (try_ instanceof Failure && (throwable = ((Failure)try_).exception()) instanceof FeignException && ((e = (FeignException)throwable).status() == 404 || e.status() == 500)) {
                Logger Logger_this = this.logger();
                if (Logger_this.isDebugEnabled()) {
                    Logger_this.debug("Job with id " + jobId + " not found. Delay for " + JobsPoller$.com$collibra$marketplace$atscale$jobs$JobsPoller$$$POLLING_INTERVAL_SECONDS + " s and call getJob again.");
                }
                this.delay(Int$.MODULE$.int2long(JobsPoller$.com$collibra$marketplace$atscale$jobs$JobsPoller$$$POLLING_INTERVAL_SECONDS));
                continue;
            }
            if (try_ instanceof Success) {
                Job job = (Job)((Success)try_).value();
                optionalJob = Some$.MODULE$.apply((Object)job);
                continue;
            }
            if (try_ instanceof Failure) {
                Throwable e2 = ((Failure)try_).exception();
                throw e2;
            }
            throw new MatchError((Object)try_);
        }
        return (Job)optionalJob.getOrElse(() -> JobsPoller.getJobWithNotFoundExceptionHandled$$anonfun$2(jobId));
    }

    private final Job getJobWithNotFoundExceptionHandled$$anonfun$1(UUID jobId$1) {
        return this.jobsApi.getJob(jobId$1);
    }

    private static final Job getJobWithNotFoundExceptionHandled$$anonfun$2(UUID jobId$2) {
        throw new JobNotFoundException(jobId$2);
    }

    public static class JobNotCompletedException
    extends RuntimeException {
        public JobNotCompletedException(Job job) {
            super("Job with id " + job.getId() + " is finished but it state is not completed but: " + job.getState());
        }
    }

    public static class JobNotFinishedException
    extends RuntimeException {
        public JobNotFinishedException(Job job) {
            super("Job with id " + job.getId() + " does not finished after timeout, has state " + job.getState());
        }
    }

    public static class JobNotFoundException
    extends RuntimeException {
        public JobNotFoundException(UUID jobId) {
            super("Job with id " + jobId + " not found");
        }
    }
}

