/*
 * Decompiled with CFR 0.152.
 */
package com.collibra.marketplace.atscale.controller;

import com.collibra.marketplace.atscale.api.AuthContext;
import com.collibra.marketplace.atscale.api.AuthContext$;
import com.collibra.marketplace.atscale.controller.ServiceDependencies;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import scala.runtime.LazyRef;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;

@RequestMapping(path={"/api"})
@Api(tags={"/api"})
@RestController
public class ApiController {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ApiController.class.getDeclaredField("logger$lzy1"));
    private final ServiceDependencies serviceDependencies;
    private volatile Object logger$lzy1;

    public ApiController(@Autowired ServiceDependencies serviceDependencies) {
        this.serviceDependencies = serviceDependencies;
    }

    private final Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LoggerFactory.getLogger((String)"com.collibra.marketplace.atscale.controller.ApiController");
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @ApiOperation(value="Create required AtScale types in Collibra")
    @PostMapping(path={"/setup"})
    public JsonNode setupTriggeredByApiRequest() {
        LazyRef lazyRef;
        block0: {
            lazyRef = new LazyRef();
            Logger Logger_this = this.logger();
            if (!Logger_this.isInfoEnabled()) break block0;
            Logger_this.info("Creating required AtScale types in Collibra");
        }
        return this.serviceDependencies.setupProcessor().execute(this.given_AuthContext$1(lazyRef));
    }

    @ApiOperation(value="Remove all AtScale assets from both domains")
    @PostMapping(path={"/removeassets"})
    public JsonNode removeAtScaleDomains() {
        LazyRef lazyRef;
        block0: {
            lazyRef = new LazyRef();
            Logger Logger_this = this.logger();
            if (!Logger_this.isInfoEnabled()) break block0;
            Logger_this.info("Removing all business and data AtScale assets from Collibra");
        }
        return this.serviceDependencies.removeAssetsProcessor().execute(this.given_AuthContext$2(lazyRef));
    }

    @ApiOperation(value="Remove all AtScale types (assets, attributes, relations and domains)")
    @PostMapping(path={"/removetypes"})
    public JsonNode removeAllAtScaleTypesFromCollibra() {
        LazyRef lazyRef;
        block0: {
            lazyRef = new LazyRef();
            Logger Logger_this = this.logger();
            if (!Logger_this.isInfoEnabled()) break block0;
            Logger_this.info("Removing all AtScale types from Collibra");
        }
        return this.serviceDependencies.removeAtscaleTypesProcessor().execute(this.given_AuthContext$3(lazyRef));
    }

    @ApiOperation(value="Remove AtScale assets with obsolete status")
    @PostMapping(path={"/removeobsolete"})
    public JsonNode removeObsoleteObjectsFromCollibra() {
        LazyRef lazyRef;
        block0: {
            lazyRef = new LazyRef();
            Logger Logger_this = this.logger();
            if (!Logger_this.isInfoEnabled()) break block0;
            Logger_this.info("Removing obsolete AtScale assets from Collibra");
        }
        return this.serviceDependencies.removeObsoleteAssetsProcessor().execute(this.given_AuthContext$4(lazyRef));
    }

    @ResponseBody
    @ApiOperation(value="Synchronize atscale model data to Collibra")
    @GetMapping(path={"/sync"})
    public JsonNode syncAtscaleToCollibra() {
        LazyRef lazyRef;
        block0: {
            lazyRef = new LazyRef();
            Logger Logger_this = this.logger();
            if (!Logger_this.isInfoEnabled()) break block0;
            Logger_this.info("Synchronizing atscale model data to Collibra");
        }
        return this.serviceDependencies.syncAtscaleToCollibraProcessor().execute(this.given_AuthContext$5(lazyRef));
    }

    @ApiOperation(value="sync-collibra-atscale")
    @PostMapping(path={"/sync-collibra-atscale"})
    public JsonNode syncCollibraToAtscale() {
        LazyRef lazyRef;
        block0: {
            lazyRef = new LazyRef();
            Logger Logger_this = this.logger();
            if (!Logger_this.isInfoEnabled()) break block0;
            Logger_this.info("Synchronizing collibra data into AtScale models");
        }
        return this.serviceDependencies.syncCollibraToAtscaleProcessor().execute(this.given_AuthContext$6(lazyRef));
    }

    private final AuthContext given_AuthContext$lzyINIT1$1(LazyRef given_AuthContext$lzy1$1) {
        AuthContext authContext;
        LazyRef lazyRef = given_AuthContext$lzy1$1;
        synchronized (lazyRef) {
            authContext = (AuthContext)(given_AuthContext$lzy1$1.initialized() ? given_AuthContext$lzy1$1.value() : given_AuthContext$lzy1$1.initialize((Object)AuthContext$.MODULE$.apply(this.serviceDependencies.atscaleAuthClient())));
        }
        return authContext;
    }

    private final AuthContext given_AuthContext$1(LazyRef given_AuthContext$lzy1$2) {
        return (AuthContext)(given_AuthContext$lzy1$2.initialized() ? given_AuthContext$lzy1$2.value() : this.given_AuthContext$lzyINIT1$1(given_AuthContext$lzy1$2));
    }

    private final AuthContext given_AuthContext$lzyINIT2$1(LazyRef given_AuthContext$lzy2$1) {
        AuthContext authContext;
        LazyRef lazyRef = given_AuthContext$lzy2$1;
        synchronized (lazyRef) {
            authContext = (AuthContext)(given_AuthContext$lzy2$1.initialized() ? given_AuthContext$lzy2$1.value() : given_AuthContext$lzy2$1.initialize((Object)AuthContext$.MODULE$.apply(this.serviceDependencies.atscaleAuthClient())));
        }
        return authContext;
    }

    private final AuthContext given_AuthContext$2(LazyRef given_AuthContext$lzy2$2) {
        return (AuthContext)(given_AuthContext$lzy2$2.initialized() ? given_AuthContext$lzy2$2.value() : this.given_AuthContext$lzyINIT2$1(given_AuthContext$lzy2$2));
    }

    private final AuthContext given_AuthContext$lzyINIT3$1(LazyRef given_AuthContext$lzy3$1) {
        AuthContext authContext;
        LazyRef lazyRef = given_AuthContext$lzy3$1;
        synchronized (lazyRef) {
            authContext = (AuthContext)(given_AuthContext$lzy3$1.initialized() ? given_AuthContext$lzy3$1.value() : given_AuthContext$lzy3$1.initialize((Object)AuthContext$.MODULE$.apply(this.serviceDependencies.atscaleAuthClient())));
        }
        return authContext;
    }

    private final AuthContext given_AuthContext$3(LazyRef given_AuthContext$lzy3$2) {
        return (AuthContext)(given_AuthContext$lzy3$2.initialized() ? given_AuthContext$lzy3$2.value() : this.given_AuthContext$lzyINIT3$1(given_AuthContext$lzy3$2));
    }

    private final AuthContext given_AuthContext$lzyINIT4$1(LazyRef given_AuthContext$lzy4$1) {
        AuthContext authContext;
        LazyRef lazyRef = given_AuthContext$lzy4$1;
        synchronized (lazyRef) {
            authContext = (AuthContext)(given_AuthContext$lzy4$1.initialized() ? given_AuthContext$lzy4$1.value() : given_AuthContext$lzy4$1.initialize((Object)AuthContext$.MODULE$.apply(this.serviceDependencies.atscaleAuthClient())));
        }
        return authContext;
    }

    private final AuthContext given_AuthContext$4(LazyRef given_AuthContext$lzy4$2) {
        return (AuthContext)(given_AuthContext$lzy4$2.initialized() ? given_AuthContext$lzy4$2.value() : this.given_AuthContext$lzyINIT4$1(given_AuthContext$lzy4$2));
    }

    private final AuthContext given_AuthContext$lzyINIT5$1(LazyRef given_AuthContext$lzy5$1) {
        AuthContext authContext;
        LazyRef lazyRef = given_AuthContext$lzy5$1;
        synchronized (lazyRef) {
            authContext = (AuthContext)(given_AuthContext$lzy5$1.initialized() ? given_AuthContext$lzy5$1.value() : given_AuthContext$lzy5$1.initialize((Object)AuthContext$.MODULE$.apply(this.serviceDependencies.atscaleAuthClient())));
        }
        return authContext;
    }

    private final AuthContext given_AuthContext$5(LazyRef given_AuthContext$lzy5$2) {
        return (AuthContext)(given_AuthContext$lzy5$2.initialized() ? given_AuthContext$lzy5$2.value() : this.given_AuthContext$lzyINIT5$1(given_AuthContext$lzy5$2));
    }

    private final AuthContext given_AuthContext$lzyINIT6$1(LazyRef given_AuthContext$lzy6$1) {
        AuthContext authContext;
        LazyRef lazyRef = given_AuthContext$lzy6$1;
        synchronized (lazyRef) {
            authContext = (AuthContext)(given_AuthContext$lzy6$1.initialized() ? given_AuthContext$lzy6$1.value() : given_AuthContext$lzy6$1.initialize((Object)AuthContext$.MODULE$.apply(this.serviceDependencies.atscaleAuthClient())));
        }
        return authContext;
    }

    private final AuthContext given_AuthContext$6(LazyRef given_AuthContext$lzy6$2) {
        return (AuthContext)(given_AuthContext$lzy6$2.initialized() ? given_AuthContext$lzy6$2.value() : this.given_AuthContext$lzyINIT6$1(given_AuthContext$lzy6$2));
    }
}

