/*
 * Decompiled with CFR 0.152.
 */
package com.collibra.marketplace.atscale.collibra.service;

import com.collibra.core.rest.client.api.RelationTypesApi;
import com.collibra.core.rest.client.model.AddRelationTypeRequest;
import com.collibra.core.rest.client.model.AssetTypeImpl;
import com.collibra.core.rest.client.model.RelationTypeImpl;
import com.collibra.marketplace.atscale.collibra.api.CollibraApi;
import com.collibra.marketplace.atscale.collibra.service.CollibraServiceLike;
import com.collibra.marketplace.atscale.package;
import com.collibra.marketplace.atscale.package$DataNotFoundException$;
import com.collibra.marketplace.atscale.store.AtscaleRelationType;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.collection.immutable.Map;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;

public class RelationTypeService
implements CollibraServiceLike {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(RelationTypeService.class.getDeclaredField("logger$lzy1"));
    private final CollibraApi collibraApi;
    private volatile Object logger$lzy1;

    public RelationTypeService(CollibraApi collibraApi) {
        this.collibraApi = collibraApi;
    }

    private final Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LoggerFactory.getLogger((String)"com.collibra.marketplace.atscale.collibra.service.RelationTypeService");
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Option<RelationTypeImpl> findRelationType(AtscaleRelationType relationType, Map<String, AssetTypeImpl> assetTypesByName) {
        RelationTypeImpl resolvedRelationType;
        block2: {
            UUID sourceAssetTypeId = this.getAssetTypeId(assetTypesByName, relationType.sourceAssetTypeName());
            UUID targetAssetTypeId = this.getAssetTypeId(assetTypesByName, relationType.targetAssetTypeName());
            RelationTypesApi.FindRelationTypesQueryParams searchParams = new RelationTypesApi.FindRelationTypesQueryParams();
            searchParams.role(relationType.role());
            searchParams.coRole(relationType.coRole());
            searchParams.sourceTypeId(sourceAssetTypeId);
            searchParams.targetTypeId(targetAssetTypeId);
            List<RelationTypeImpl> relationTypes = this.collibraApi.relationTypesApi().findRelationTypes(searchParams).getResults();
            if (relationTypes == null || relationTypes.size() != 1) {
                Logger Logger_this = this.logger();
                if (Logger_this.isErrorEnabled()) {
                    Logger_this.error("No relation type found for relation type " + relationType + ". The search is case sensitive and must match exactly");
                }
                return None$.MODULE$;
            }
            resolvedRelationType = relationTypes.get(0);
            Logger Logger_this = this.logger();
            if (!Logger_this.isDebugEnabled()) break block2;
            Logger_this.debug("Found existing relation type " + resolvedRelationType);
        }
        return Some$.MODULE$.apply((Object)resolvedRelationType);
    }

    public void removeRelationType(RelationTypeImpl relationType) {
        this.collibraApi.relationTypesApi().removeRelationType(relationType.getId());
    }

    public RelationTypeImpl addRelationType(AtscaleRelationType relationType, Map<String, AssetTypeImpl> assetTypesByName) {
        AddRelationTypeRequest request;
        block0: {
            UUID sourceAssetTypeId = this.getAssetTypeId(assetTypesByName, relationType.sourceAssetTypeName());
            UUID targetAssetTypeId = this.getAssetTypeId(assetTypesByName, relationType.targetAssetTypeName());
            request = new AddRelationTypeRequest();
            request.setId(UUID.randomUUID());
            request.setDescription("");
            request.setRole(relationType.role());
            request.setCoRole(relationType.coRole());
            request.setSourceTypeId(sourceAssetTypeId);
            request.setTargetTypeId(targetAssetTypeId);
            Logger Logger_this = this.logger();
            if (!Logger_this.isInfoEnabled()) break block0;
            Logger_this.info("Added relationType " + relationType + " to the Collibra platform");
        }
        return this.collibraApi.relationTypesApi().addRelationType(request);
    }

    private UUID getAssetTypeId(Map<String, AssetTypeImpl> assetTypeNames, String assetTypeName) {
        if (assetTypeNames.contains((Object)assetTypeName)) {
            return ((AssetTypeImpl)assetTypeNames.apply((Object)assetTypeName)).getId();
        }
        Logger Logger_this = this.logger();
        if (Logger_this.isErrorEnabled()) {
            Logger_this.error("Asset type " + assetTypeName + " not found");
        }
        throw new package.DataNotFoundException("Asset type " + assetTypeName + " not found", package$DataNotFoundException$.MODULE$.$lessinit$greater$default$2());
    }
}

