/*
 * Decompiled with CFR 0.152.
 */
package com.collibra.marketplace.atscale.collibra.service;

import com.collibra.core.rest.client.api.AssetsApi;
import com.collibra.core.rest.client.api.AttributesApi;
import com.collibra.core.rest.client.model.AssetImpl;
import com.collibra.core.rest.client.model.AssetTypeImpl;
import com.collibra.core.rest.client.model.AttributePagedResponse;
import com.collibra.core.rest.client.model.AttributeType;
import com.collibra.marketplace.atscale.AssetFormatConstants$;
import com.collibra.marketplace.atscale.collibra.api.CollibraApi;
import com.collibra.marketplace.atscale.collibra.service.CollibraServiceLike;
import com.collibra.marketplace.atscale.model.AtscaleServiceConfig;
import com.collibra.marketplace.atscale.model.Attribute;
import com.collibra.marketplace.atscale.model.Attribute$;
import com.collibra.marketplace.atscale.model.Measure;
import com.collibra.marketplace.atscale.model.Measure$;
import com.collibra.marketplace.atscale.model.Project;
import com.collibra.marketplace.atscale.model.Project$;
import com.collibra.marketplace.atscale.store.AtscaleAssetType$;
import com.collibra.marketplace.atscale.store.CollibraInstanceData;
import java.io.Serializable;
import java.util.Collections;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;

public class ProjectService
implements CollibraServiceLike {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ProjectService.class.getDeclaredField("logger$lzy1"));
    private final CollibraApi collibraApi;
    private volatile Object logger$lzy1;

    public ProjectService(CollibraApi collibraApi) {
        this.collibraApi = collibraApi;
    }

    private final Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LoggerFactory.getLogger((String)"com.collibra.marketplace.atscale.collibra.service.ProjectService");
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Seq<Project> listCollibraProjects(AtscaleServiceConfig atscaleServiceConfig, CollibraInstanceData collibraData) {
        AssetTypeImpl measureAssetType = (AssetTypeImpl)collibraData.assetTypesByName().getOrElse((Object)AtscaleAssetType$.ATSCALE_MEASURE.name(), ProjectService::$anonfun$1);
        AssetsApi.FindAssetsQueryParams params = new AssetsApi.FindAssetsQueryParams();
        params.domainId(collibraData.businessAssetDomain().getId());
        params.typeId(Collections.singletonList(measureAssetType.getId()));
        Map assetMap = ((IterableOps)this.safeResults(this.collibraApi.assetsApi().findAssets(params).getResults()).filter((Function1 & Serializable)x$1 -> {
            AssetImpl assetImpl = x$1;
            AssetImpl asset = assetImpl;
            if (asset.getName() == null) {
                throw new RuntimeException("Asset name is null for asset: " + asset.getId());
            }
            AssetImpl asset2 = assetImpl;
            return asset2.getName().contains(atscaleServiceConfig.apiHost());
        })).groupBy((Function1 & Serializable)asset -> this.extractProjectNameFromMeasure(asset.getName()));
        AttributeType descriptionAttributeType = (AttributeType)collibraData.attributeTypesByName().getOrElse((Object)"Description", ProjectService::$anonfun$4);
        AttributesApi.FindAttributesQueryParams attributesParam = new AttributesApi.FindAttributesQueryParams();
        attributesParam.typeIds(Collections.singletonList(descriptionAttributeType.getId()));
        AttributePagedResponse attributePagedResponse = this.collibraApi.attributesApi().findAttributes(attributesParam);
        return ((IterableOnceOps)assetMap.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String projectNameForAsset = (String)tuple2._1();
                Seq assets = (Seq)tuple2._2();
                Seq measures = (Seq)assets.map((Function1 & Serializable)asset -> {
                    Seq attributes = (Seq)((IterableOps)this.safeResults(attributePagedResponse.getResults()).filter((Function1 & Serializable)_$1 -> {
                        UUID uUID = _$1.getAsset().getId();
                        UUID uUID2 = asset.getId();
                        return !(uUID != null ? !((Object)uUID).equals(uUID2) : uUID2 != null);
                    })).map((Function1 & Serializable)attribute1 -> Attribute$.MODULE$.apply(attribute1.getId().toString(), attribute1.getType().getName(), attribute1.getType().getId().toString(), attribute1.getAsset().getId().toString(), attribute1.getValue().toString()));
                    return Measure$.MODULE$.apply(null, null, null, null, this.getCubeNameFromMeasureName(asset.getName()), null, asset.getDisplayName(), null, null, null, null, null, null, null, null, null, null, null, null, null, null, false, null, null, null, null, null, null, null, null, false, null, null, (Seq<Attribute>)attributes);
                });
                String string = this.extractProjectDisplayName(projectNameForAsset);
                return Project$.MODULE$.apply(projectNameForAsset, null, null, null, null, null, null, null, null, null, null, null, null, false, null, (Seq<Measure>)measures, string);
            }
            throw new MatchError((Object)tuple2);
        })).toSeq();
    }

    private String extractProjectNameFromMeasure(String assetName) {
        int lastIndexOf = assetName.lastIndexOf(AssetFormatConstants$.MODULE$.ASSET_NAME_SEPARATOR());
        return assetName.substring(0, assetName.substring(0, lastIndexOf).lastIndexOf(AssetFormatConstants$.MODULE$.ASSET_NAME_SEPARATOR()));
    }

    private String extractProjectDisplayName(String assetName) {
        String[] assetsArray = assetName.split(AssetFormatConstants$.MODULE$.ASSET_NAME_SEPARATOR());
        return assetsArray[assetsArray.length - 1];
    }

    private String getCubeNameFromMeasureName(String name) {
        String[] assetsArray = name.split(AssetFormatConstants$.MODULE$.ASSET_NAME_SEPARATOR());
        return assetsArray[assetsArray.length - 2];
    }

    private static final AssetTypeImpl $anonfun$1() {
        throw new RuntimeException("Atscale measure asset type not found");
    }

    private static final AttributeType $anonfun$4() {
        throw new RuntimeException("Description attribute type not found");
    }
}

