/*
 * Decompiled with CFR 0.152.
 */
package com.collibra.marketplace.atscale.collibra.service;

import com.collibra.core.rest.client.api.DomainTypesApi;
import com.collibra.core.rest.client.model.AddDomainTypeRequest;
import com.collibra.core.rest.client.model.DomainTypeImpl;
import com.collibra.marketplace.atscale.collibra.api.CollibraApi;
import com.collibra.marketplace.atscale.collibra.service.CollibraServiceLike;
import java.io.Serializable;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;

public class DomainTypeService
implements CollibraServiceLike {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DomainTypeService.class.getDeclaredField("logger$lzy1"));
    private final CollibraApi collibraApi;
    private volatile Object logger$lzy1;

    public DomainTypeService(CollibraApi collibraApi) {
        this.collibraApi = collibraApi;
    }

    private final Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LoggerFactory.getLogger((String)"com.collibra.marketplace.atscale.collibra.service.DomainTypeService");
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public DomainTypeImpl getDomainTypeById(UUID domainTypeId) {
        return this.collibraApi.domainTypesApi().getDomainType(domainTypeId);
    }

    public DomainTypeImpl findDomainTypeByName(String domainTypeName) {
        DomainTypesApi.FindDomainTypesQueryParams searchParams = new DomainTypesApi.FindDomainTypesQueryParams();
        searchParams.name(domainTypeName);
        searchParams.nameMatchMode("EXACT");
        Seq domainTypes = this.safeResults(this.collibraApi.domainTypesApi().findDomainTypes(searchParams).getResults());
        if (domainTypes.size() != 1) {
            Logger Logger_this = this.logger();
            if (Logger_this.isErrorEnabled()) {
                Logger_this.error("No domain type found for domain type name " + domainTypes + ".  The search is case sensitive and must match exactly");
            }
            return null;
        }
        return (DomainTypeImpl)domainTypes.head();
    }

    public DomainTypeImpl addDomainType(String domainTypeName, Option<String> domainTypeDescription) {
        AddDomainTypeRequest request = new AddDomainTypeRequest();
        request.setId(UUID.randomUUID());
        request.setName(domainTypeName);
        domainTypeDescription.foreach((Function1)(JProcedure1 & Serializable)description -> request.setDescription((String)description));
        request.setParentId(UUID.fromString("00000000-0000-0000-0000-000000030002"));
        return this.collibraApi.domainTypesApi().addDomainType(request);
    }

    public void removeDomain(DomainTypeImpl domainType) {
        this.collibraApi.domainTypesApi().removeDomainType(domainType.getId());
    }
}

