/*
 * Decompiled with CFR 0.152.
 */
package com.collibra.marketplace.atscale.collibra.service;

import com.collibra.core.rest.client.api.DomainsApi;
import com.collibra.core.rest.client.model.AddDomainRequest;
import com.collibra.core.rest.client.model.CommunityImpl;
import com.collibra.core.rest.client.model.DomainImpl;
import com.collibra.core.rest.client.model.DomainTypeImpl;
import com.collibra.marketplace.atscale.collibra.api.CollibraApi;
import com.collibra.marketplace.atscale.collibra.service.CollibraServiceLike;
import java.io.Serializable;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;

public class DomainService
implements CollibraServiceLike {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DomainService.class.getDeclaredField("logger$lzy1"));
    private final CollibraApi collibraApi;
    private volatile Object logger$lzy1;

    public DomainService(CollibraApi collibraApi) {
        this.collibraApi = collibraApi;
    }

    private final Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LoggerFactory.getLogger((String)"com.collibra.marketplace.atscale.collibra.service.DomainService");
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Option<DomainImpl> findDomainByName(CommunityImpl community, String domainName) {
        DomainsApi.FindDomainsQueryParams searchParams = new DomainsApi.FindDomainsQueryParams();
        searchParams.communityId(community.getId());
        searchParams.name(domainName);
        searchParams.nameMatchMode("EXACT");
        Seq domains = this.safeResults(this.collibraApi.domainsApi().findDomains(searchParams).getResults());
        if (domains.size() != 1) {
            Logger Logger_this = this.logger();
            if (Logger_this.isErrorEnabled()) {
                Logger_this.error("No domain found for domain name " + domainName + ".  The search is case sensitive and must match exactly");
            }
            return None$.MODULE$;
        }
        return domains.headOption();
    }

    public DomainImpl getDomainById(UUID domainId) {
        return this.collibraApi.domainsApi().getDomain(domainId);
    }

    public DomainImpl addDomain(CommunityImpl community, DomainTypeImpl domainType, String domainName, Option<String> domainDescription) {
        AddDomainRequest request = new AddDomainRequest();
        request.setId(UUID.randomUUID());
        request.setCommunityId(community.getId());
        request.setTypeId(domainType.getId());
        request.setName(domainName);
        domainDescription.foreach((Function1)(JProcedure1 & Serializable)description -> request.setDescription((String)description));
        return this.collibraApi.domainsApi().addDomain(request);
    }

    public void removeDomain(DomainImpl domain) {
        this.collibraApi.domainsApi().removeDomain(domain.getId());
    }
}

