/*
 * Decompiled with CFR 0.152.
 */
package com.collibra.marketplace.atscale.collibra.service;

import com.collibra.core.rest.client.api.CommunitiesApi;
import com.collibra.core.rest.client.model.AddCommunityRequest;
import com.collibra.core.rest.client.model.CommunityImpl;
import com.collibra.marketplace.atscale.collibra.api.CollibraApi;
import com.collibra.marketplace.atscale.collibra.service.CollibraServiceLike;
import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;

public class CommunityService
implements CollibraServiceLike {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(CommunityService.class.getDeclaredField("logger$lzy1"));
    private final CollibraApi collibraApi;
    private volatile Object logger$lzy1;

    public CommunityService(CollibraApi collibraApi) {
        this.collibraApi = collibraApi;
    }

    private final Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LoggerFactory.getLogger((String)"com.collibra.marketplace.atscale.collibra.service.CommunityService");
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public CommunityImpl getCommunityById(UUID communityId) {
        CommunityImpl communityImpl;
        try {
            communityImpl = this.collibraApi.communitiesApi().getCommunity(communityId);
        }
        catch (Exception e) {
            if (!e.getMessage().contains("communityNotFoundId")) {
                throw e;
            }
            communityImpl = null;
        }
        return communityImpl;
    }

    public Option<CommunityImpl> findCommunityByName(String communityName) {
        CommunitiesApi.FindCommunitiesQueryParams searchParams = new CommunitiesApi.FindCommunitiesQueryParams();
        searchParams.name(communityName);
        searchParams.nameMatchMode("EXACT");
        List<CommunityImpl> communities = this.collibraApi.communitiesApi().findCommunities(searchParams).getResults();
        if (communities == null || communities.size() != 1) {
            Logger Logger_this = this.logger();
            if (Logger_this.isErrorEnabled()) {
                Logger_this.error("No community found for community name " + communityName + ".  The search is case sensitive and must match exactly");
            }
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply((Object)communities.get(0));
    }

    public CommunityImpl addCommunity(String communityName, Option<String> communityDescription) {
        AddCommunityRequest request = new AddCommunityRequest();
        request.setName(communityName);
        request.setId(UUID.randomUUID());
        communityDescription.foreach((Function1)(JProcedure1 & Serializable)description -> request.setDescription((String)description));
        return this.collibraApi.communitiesApi().addCommunity(request);
    }
}

