/*
 * Decompiled with CFR 0.152.
 */
package com.collibra.marketplace.atscale.collibra.service;

import com.collibra.core.rest.client.api.AttributeTypesApi;
import com.collibra.core.rest.client.model.AddAttributeTypeRequest;
import com.collibra.core.rest.client.model.AttributeType;
import com.collibra.marketplace.atscale.collibra.api.CollibraApi;
import com.collibra.marketplace.atscale.collibra.service.CollibraServiceLike;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Predef$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;

public class AttributeTypeService
implements CollibraServiceLike {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(AttributeTypeService.class.getDeclaredField("logger$lzy1"));
    private final CollibraApi collibraApi;
    private volatile Object logger$lzy1;

    public AttributeTypeService(CollibraApi collibraApi) {
        this.collibraApi = collibraApi;
    }

    private final Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LoggerFactory.getLogger((String)"com.collibra.marketplace.atscale.collibra.service.AttributeTypeService");
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public AttributeType findAttributeTypeByName(String attributeTypeName) {
        List<AttributeType> attributeTypes;
        block2: {
            AttributeTypesApi.FindAttributeTypesQueryParams searchParams = new AttributeTypesApi.FindAttributeTypesQueryParams();
            searchParams.name(attributeTypeName);
            searchParams.nameMatchMode("EXACT");
            attributeTypes = this.collibraApi.attributeTypesApi().findAttributeTypes(searchParams).getResults();
            if (attributeTypes == null || attributeTypes.size() != 1) {
                Logger Logger_this = this.logger();
                if (Logger_this.isErrorEnabled()) {
                    Logger_this.error("No attribute type found for type name " + attributeTypeName + ".  The search is case sensitive and must match exactly");
                }
                return null;
            }
            Logger Logger_this = this.logger();
            if (!Logger_this.isDebugEnabled()) break block2;
            Logger_this.debug("Found existing attribute type " + attributeTypes.get(0));
        }
        return attributeTypes.get(0);
    }

    public AttributeType getAttributeTypeById(UUID attributeTypeId) {
        return this.collibraApi.attributeTypesApi().getAttributeType(attributeTypeId);
    }

    public AttributeType addAttributeType(String name, String description) {
        AddAttributeTypeRequest request = new AddAttributeTypeRequest();
        request.setId(UUID.randomUUID());
        request.setName(name);
        request.setDescription(description);
        request.setIsInteger(Predef$.MODULE$.boolean2Boolean(false));
        request.setStringType(AddAttributeTypeRequest.StringTypeEnum.PLAIN_TEXT);
        request.setKind(AddAttributeTypeRequest.KindEnum.STRING);
        return this.collibraApi.attributeTypesApi().addAttributeType(request);
    }

    public void removeAttributeType(AttributeType attributeType) {
        this.collibraApi.attributeTypesApi().removeAttributeType(attributeType.getId());
    }
}

