/*
 * Decompiled with CFR 0.152.
 */
package com.collibra.marketplace.atscale.collibra.service;

import com.collibra.core.rest.client.api.AssetTypesApi;
import com.collibra.core.rest.client.model.AddAssetTypeRequest;
import com.collibra.core.rest.client.model.AssetTypeImpl;
import com.collibra.marketplace.atscale.collibra.api.CollibraApi;
import com.collibra.marketplace.atscale.collibra.service.CollibraServiceLike;
import java.io.Serializable;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.collection.immutable.Seq;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;

public class AssetTypeService
implements CollibraServiceLike {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(AssetTypeService.class.getDeclaredField("logger$lzy1"));
    private final CollibraApi collibraApi;
    private volatile Object logger$lzy1;

    public AssetTypeService(CollibraApi collibraApi) {
        this.collibraApi = collibraApi;
    }

    private final Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LoggerFactory.getLogger((String)"com.collibra.marketplace.atscale.collibra.service.AssetTypeService");
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public AssetTypeImpl findAssetTypeByName(String assetTypeName) {
        Seq assetTypes;
        block2: {
            AssetTypesApi.FindAssetTypesQueryParams searchParams = new AssetTypesApi.FindAssetTypesQueryParams();
            searchParams.name(assetTypeName);
            searchParams.nameMatchMode("EXACT");
            assetTypes = this.safeResults(this.collibraApi.assetsTypesApi().findAssetTypes(searchParams).getResults());
            if (assetTypes.size() != 1) {
                Logger Logger_this = this.logger();
                if (Logger_this.isErrorEnabled()) {
                    Logger_this.error("No asset type found for asset type name " + assetTypeName + ".  The search is case sensitive and must match exactly");
                }
                return null;
            }
            Logger Logger_this = this.logger();
            if (!Logger_this.isDebugEnabled()) break block2;
            Logger_this.debug("Found existing asset type " + assetTypes.head());
        }
        return (AssetTypeImpl)assetTypes.head();
    }

    public AssetTypeImpl addAssetType(Option<UUID> parentId2, String assetTypeName, Option<String> description2) {
        AddAssetTypeRequest request = new AddAssetTypeRequest();
        request.setId(UUID.randomUUID());
        request.setName(assetTypeName);
        request.setSymbolType(AddAssetTypeRequest.SymbolTypeEnum.NONE);
        parentId2.foreach((Function1)(JProcedure1 & Serializable)parentId -> request.setParentId((UUID)parentId));
        description2.foreach((Function1)(JProcedure1 & Serializable)description -> request.setDescription((String)description));
        return this.collibraApi.assetsTypesApi().addAssetType(request);
    }

    public Option<String> addAssetType$default$3() {
        return None$.MODULE$;
    }

    public Option<AssetTypeImpl> getAssetTypeById(UUID assetTypeId) {
        return Option$.MODULE$.apply((Object)this.collibraApi.assetsTypesApi().getAssetType(assetTypeId));
    }

    public void removeAssetType(AssetTypeImpl assetType) {
        this.collibraApi.assetsTypesApi().removeAssetType(assetType.getId());
    }
}

