/*
 * Decompiled with CFR 0.152.
 */
package com.collibra.marketplace.atscale.collibra.service;

import com.collibra.core.rest.client.api.AssetsApi;
import com.collibra.core.rest.client.model.AssetImpl;
import com.collibra.marketplace.atscale.collibra.api.CollibraApi;
import com.collibra.marketplace.atscale.collibra.service.CollibraServiceLike;
import java.io.Serializable;
import java.util.Collections;
import java.util.Locale;
import java.util.UUID;
import scala.Function1;
import scala.collection.immutable.Seq;

public class AssetService
implements CollibraServiceLike {
    private final CollibraApi collibraApi;

    public AssetService(CollibraApi collibraApi) {
        this.collibraApi = collibraApi;
    }

    public Seq<AssetImpl> listObsoleteAssetsForDomainId(UUID domainId) {
        AssetsApi.FindAssetsQueryParams searchParams = new AssetsApi.FindAssetsQueryParams();
        searchParams.domainId(domainId);
        return (Seq)this.safeResults(this.collibraApi.assetsApi().findAssets(searchParams).getResults()).filter((Function1 & Serializable)x$1 -> {
            String statusName;
            AssetImpl assetImpl = x$1;
            AssetImpl asset = assetImpl;
            if (asset.getStatus() == null || asset.getStatus().getName() == null) {
                return false;
            }
            AssetImpl asset2 = assetImpl;
            String string = statusName = asset2.getStatus().getName().toLowerCase(Locale.ROOT);
            String string2 = "obsolete";
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
    }

    public Seq<AssetImpl> listAssetsForDomainId(UUID domainId) {
        AssetsApi.FindAssetsQueryParams searchParams = new AssetsApi.FindAssetsQueryParams();
        searchParams.domainId(domainId);
        return this.safeResults(this.collibraApi.assetsApi().findAssets(searchParams).getResults());
    }

    public Seq<AssetImpl> listAssetsForAssetTypeId(UUID assetTypeId) {
        AssetsApi.FindAssetsQueryParams params = new AssetsApi.FindAssetsQueryParams();
        params.typeId(Collections.singletonList(assetTypeId));
        return this.safeResults(this.collibraApi.assetsApi().findAssets(params).getResults());
    }

    public Seq<AssetImpl> listAssetsForName(String name) {
        AssetsApi.FindAssetsQueryParams params = new AssetsApi.FindAssetsQueryParams();
        params.name(name);
        return this.safeResults(this.collibraApi.assetsApi().findAssets(params).getResults());
    }

    public void removeAsset(AssetImpl asset) {
        this.collibraApi.assetsApi().removeAsset(asset.getId());
    }
}

