/*
 * Decompiled with CFR 0.152.
 */
package com.collibra.marketplace.atscale.api;

import com.collibra.marketplace.atscale.api.AtscaleApiRequest;
import com.collibra.marketplace.atscale.api.AuthContext;
import com.collibra.marketplace.atscale.model.Column;
import com.collibra.marketplace.atscale.model.Connection;
import com.collibra.marketplace.atscale.model.ConnectionGroup;
import com.collibra.marketplace.atscale.model.Cube;
import com.collibra.marketplace.atscale.model.Dataset;
import com.collibra.marketplace.atscale.model.Dependency;
import com.collibra.marketplace.atscale.model.Dimension;
import com.collibra.marketplace.atscale.model.Folder;
import com.collibra.marketplace.atscale.model.Hierarchy;
import com.collibra.marketplace.atscale.model.Level;
import com.collibra.marketplace.atscale.model.Measure;
import com.collibra.marketplace.atscale.model.Project;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;

public class AtscaleService {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(AtscaleService.class.getDeclaredField("logger$lzy1"));
    private final AtscaleApiRequest atscaleApiRequest;
    private volatile Object logger$lzy1;

    public AtscaleService(AtscaleApiRequest atscaleApiRequest) {
        this.atscaleApiRequest = atscaleApiRequest;
    }

    private final Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LoggerFactory.getLogger((String)"com.collibra.marketplace.atscale.api.AtscaleService");
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Map<String, Project> retrieveProjects(AuthContext authCtx) {
        Map<String, Project> projectsMap;
        block1: {
            Logger Logger_this = this.logger();
            if (Logger_this.isInfoEnabled()) {
                Logger_this.info("Retrieving projects...");
            }
            projectsMap = this.atscaleApiRequest.getProjects(authCtx);
            Logger Logger_this2 = this.logger();
            if (!Logger_this2.isInfoEnabled()) break block1;
            Logger_this2.info("Retrieved " + projectsMap.size() + " projects");
        }
        return projectsMap;
    }

    public Seq<Cube> retrieveCubes(Map<String, Project> currentProject, AuthContext authCtx) {
        Seq<Cube> allCubes;
        block1: {
            Logger Logger_this = this.logger();
            if (Logger_this.isInfoEnabled()) {
                Logger_this.info("Retrieving cubes...");
            }
            allCubes = this.atscaleApiRequest.retrieveAllCubes(currentProject, authCtx);
            Logger Logger_this2 = this.logger();
            if (!Logger_this2.isInfoEnabled()) break block1;
            Logger_this2.info("Retrieved " + allCubes.size() + " cubes");
        }
        return allCubes;
    }

    public Seq<Measure> retrieveMeasures(Map<String, Project> currentProject, AuthContext authCtx) {
        Seq<Measure> allMeasures;
        block1: {
            Logger Logger_this = this.logger();
            if (Logger_this.isInfoEnabled()) {
                Logger_this.info("Retrieving measures...");
            }
            allMeasures = this.atscaleApiRequest.retrieveAllMeasures(currentProject, authCtx);
            Logger Logger_this2 = this.logger();
            if (!Logger_this2.isInfoEnabled()) break block1;
            Logger_this2.info("Retrieved " + allMeasures.size() + " measures");
        }
        return allMeasures;
    }

    public Seq<Dimension> retrieveDimensions(Map<String, Project> currentProject, AuthContext authCtx) {
        Seq<Dimension> allDimensions;
        block1: {
            Logger Logger_this = this.logger();
            if (Logger_this.isInfoEnabled()) {
                Logger_this.info("Retrieving dimensions...");
            }
            allDimensions = this.atscaleApiRequest.retrieveAllDimensions(currentProject, authCtx);
            Logger Logger_this2 = this.logger();
            if (!Logger_this2.isInfoEnabled()) break block1;
            Logger_this2.info("Retrieved " + allDimensions.size() + " dimensions");
        }
        return allDimensions;
    }

    public Seq<Hierarchy> retrieveHierarchies(Map<String, Project> currentProject, AuthContext authCtx) {
        Seq<Hierarchy> allHierarchies;
        block1: {
            Logger Logger_this = this.logger();
            if (Logger_this.isInfoEnabled()) {
                Logger_this.info("Retrieving hierarchies...");
            }
            allHierarchies = this.atscaleApiRequest.retrieveAllHierarchies(currentProject, authCtx);
            Logger Logger_this2 = this.logger();
            if (!Logger_this2.isInfoEnabled()) break block1;
            Logger_this2.info("Retrieved " + allHierarchies.size() + " hierarchies");
        }
        return allHierarchies;
    }

    public Seq<Level> retrieveLevels(Map<String, Project> currentProject, AuthContext authCtx) {
        Seq<Level> allLevels;
        block1: {
            Logger Logger_this = this.logger();
            if (Logger_this.isInfoEnabled()) {
                Logger_this.info("Retrieving levels...");
            }
            allLevels = this.atscaleApiRequest.retrieveAllLevels(currentProject, authCtx);
            Logger Logger_this2 = this.logger();
            if (!Logger_this2.isInfoEnabled()) break block1;
            Logger_this2.info("Retrieved " + allLevels.size() + " levels");
        }
        return allLevels;
    }

    public Map<String, Folder> retrieveFolders(Seq<Measure> allMeasures, Seq<Hierarchy> allHierarchies, AuthContext authCtx) {
        Map<String, Folder> allFolders;
        block1: {
            Logger Logger_this = this.logger();
            if (Logger_this.isInfoEnabled()) {
                Logger_this.info("Retrieving folders...");
            }
            allFolders = this.atscaleApiRequest.retrieveAllFolders(allMeasures, allHierarchies);
            Logger Logger_this2 = this.logger();
            if (!Logger_this2.isInfoEnabled()) break block1;
            Logger_this2.info("Retrieved " + allFolders.size() + " folders");
        }
        return allFolders;
    }

    public Seq<ConnectionGroup> retrieveConnectionGroups(AuthContext authCtx) {
        Seq<ConnectionGroup> allConnectionGroups;
        block1: {
            Logger Logger_this = this.logger();
            if (Logger_this.isInfoEnabled()) {
                Logger_this.info("Retrieving connection groups...");
            }
            allConnectionGroups = this.atscaleApiRequest.retrieveAllConnectionGroups(this.atscaleApiRequest.getProjects(authCtx), authCtx);
            Logger Logger_this2 = this.logger();
            if (!Logger_this2.isInfoEnabled()) break block1;
            Logger_this2.info("Retrieved " + allConnectionGroups.size() + " connection groups");
        }
        return allConnectionGroups;
    }

    public Seq<Connection> retrieveConnections(AuthContext authCtx) {
        Seq<Connection> allConnections;
        block1: {
            Logger Logger_this = this.logger();
            if (Logger_this.isInfoEnabled()) {
                Logger_this.info("Retrieving connections...");
            }
            allConnections = this.atscaleApiRequest.retrieveAllConnections(this.atscaleApiRequest.getProjects(authCtx), authCtx);
            Logger Logger_this2 = this.logger();
            if (!Logger_this2.isInfoEnabled()) break block1;
            Logger_this2.info("Retrieved " + allConnections.size() + " connections");
        }
        return allConnections;
    }

    public Seq<Dataset> retrieveDatasets(Map<String, Project> currentProject, AuthContext authCtx) {
        Seq<Dataset> allDatasets;
        block1: {
            Logger Logger_this = this.logger();
            if (Logger_this.isInfoEnabled()) {
                Logger_this.info("Retrieving datasets...");
            }
            allDatasets = this.atscaleApiRequest.retrieveAllDatasets(currentProject, authCtx);
            Logger Logger_this2 = this.logger();
            if (!Logger_this2.isInfoEnabled()) break block1;
            Logger_this2.info("Retrieved " + allDatasets.size() + " datasets");
        }
        return allDatasets;
    }

    public Seq<Column> retrieveColumns(Map<String, Project> currentProject, AuthContext authCtx) {
        Seq<Column> allColumns;
        block1: {
            Logger Logger_this = this.logger();
            if (Logger_this.isInfoEnabled()) {
                Logger_this.info("Retrieving columns...");
            }
            allColumns = this.atscaleApiRequest.retrieveAllColumns(currentProject, authCtx);
            Logger Logger_this2 = this.logger();
            if (!Logger_this2.isInfoEnabled()) break block1;
            Logger_this2.info("Retrieved " + allColumns.size() + " columns");
        }
        return allColumns;
    }

    public Seq<Dependency> retrieveDependencies(Map<String, Project> currentProject, Seq<Column> allColumns, AuthContext authCtx) {
        Seq<Dependency> allDependencies;
        block0: {
            allDependencies = this.atscaleApiRequest.retrieveAllDependencies(currentProject, allColumns, authCtx);
            Logger Logger_this = this.logger();
            if (!Logger_this.isInfoEnabled()) break block0;
            Logger_this.info("Retrieved " + allDependencies.size() + " dependencies");
        }
        return allDependencies;
    }

    public void publishProject(String projectId, Project project, Map<String, Measure> updatedMeasureMap, AuthContext authCtx) {
        this.atscaleApiRequest.publishProject(projectId, project, updatedMeasureMap, authCtx);
    }
}

