/*
 * Decompiled with CFR 0.152.
 */
package com.collibra.marketplace.atscale.api;

import com.collibra.marketplace.atscale.AssetFormatConstants$;
import com.collibra.marketplace.atscale.api.AtscaleApiClient;
import com.collibra.marketplace.atscale.api.AtscaleApiRequest$;
import com.collibra.marketplace.atscale.api.AtscaleApiRequest$ProjectXmlHeaders$;
import com.collibra.marketplace.atscale.api.AuthContext;
import com.collibra.marketplace.atscale.api.DaxQuery$;
import com.collibra.marketplace.atscale.api.DaxResultJdbcKeys$;
import com.collibra.marketplace.atscale.api.ParameterizedTypeReferenceMapper;
import com.collibra.marketplace.atscale.api.SoapQueryExecutor;
import com.collibra.marketplace.atscale.config.ApplicationConfig;
import com.collibra.marketplace.atscale.config.CollibraConstants$;
import com.collibra.marketplace.atscale.helpers.JdbcHelpers$;
import com.collibra.marketplace.atscale.model.Column;
import com.collibra.marketplace.atscale.model.Column$;
import com.collibra.marketplace.atscale.model.Connection;
import com.collibra.marketplace.atscale.model.Connection$;
import com.collibra.marketplace.atscale.model.ConnectionGroup;
import com.collibra.marketplace.atscale.model.ConnectionGroup$;
import com.collibra.marketplace.atscale.model.Cube;
import com.collibra.marketplace.atscale.model.Cube$;
import com.collibra.marketplace.atscale.model.Dataset;
import com.collibra.marketplace.atscale.model.Dataset$;
import com.collibra.marketplace.atscale.model.Dependency;
import com.collibra.marketplace.atscale.model.Dependency$;
import com.collibra.marketplace.atscale.model.Dimension;
import com.collibra.marketplace.atscale.model.Dimension$;
import com.collibra.marketplace.atscale.model.Folder;
import com.collibra.marketplace.atscale.model.Folder$;
import com.collibra.marketplace.atscale.model.Hierarchy;
import com.collibra.marketplace.atscale.model.Hierarchy$;
import com.collibra.marketplace.atscale.model.Level;
import com.collibra.marketplace.atscale.model.Level$;
import com.collibra.marketplace.atscale.model.Measure;
import com.collibra.marketplace.atscale.model.Measure$;
import com.collibra.marketplace.atscale.model.Project;
import com.collibra.marketplace.atscale.model.Project$;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.sql.ResultSet;
import java.util.Date;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public class AtscaleApiRequest {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(AtscaleApiRequest.class.getDeclaredField("logger$lzy1"));
    private final ApplicationConfig appConfig;
    private final AtscaleApiClient atscaleApiClient;
    private final SoapQueryExecutor soapQueryExecutor;
    private volatile Object logger$lzy1;
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(AtscaleApiRequest$.class.getDeclaredField("dataTypeNamesLookup$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(AtscaleApiRequest$.class.getDeclaredField("logger$lzy2"));

    public static scala.collection.immutable.Map<Object, String> dataTypeNamesLookup() {
        return AtscaleApiRequest$.MODULE$.dataTypeNamesLookup();
    }

    public static <T> Seq<T> doRetrieve(SoapQueryExecutor soapQueryExecutor, String string, scala.collection.immutable.Map<String, Project> map, String string2, Option<String> option, Function2<String, ResultSet, T> function2, AuthContext authContext) {
        return AtscaleApiRequest$.MODULE$.doRetrieve(soapQueryExecutor, string, map, string2, option, function2, authContext);
    }

    public static <T> Option<String> doRetrieve$default$5(SoapQueryExecutor soapQueryExecutor) {
        return AtscaleApiRequest$.MODULE$.doRetrieve$default$5(soapQueryExecutor);
    }

    public AtscaleApiRequest(ApplicationConfig appConfig, AtscaleApiClient atscaleApiClient, SoapQueryExecutor soapQueryExecutor) {
        this.appConfig = appConfig;
        this.atscaleApiClient = atscaleApiClient;
        this.soapQueryExecutor = soapQueryExecutor;
    }

    private final Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LoggerFactory.getLogger((String)"com.collibra.marketplace.atscale.api.AtscaleApiRequest");
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private String formatDocumentToXml(Document document1) {
        StringWriter writer1 = new StringWriter();
        TransformerFactory transformerFactory1 = TransformerFactory.newInstance();
        Transformer transformer1 = null;
        try {
            transformer1 = transformerFactory1.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        try {
            transformer1.transform(new DOMSource(document1), new StreamResult(writer1));
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
        return writer1.toString();
    }

    public void modifySchema(NodeList parentNode, Document document1, scala.collection.immutable.Map<String, Measure> updatedMeasureMap) {
        if (parentNode != null) {
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), parentNode.getLength()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                Element attributeElement = (Element)parentNode.item(i);
                String attributeId = attributeElement.getAttribute("id");
                if (updatedMeasureMap.contains((Object)attributeId)) {
                    NodeList propertyNodes = attributeElement.getElementsByTagName("properties");
                    if (propertyNodes.getLength() > 0) {
                        Element propertyElement = (Element)propertyNodes.item(0);
                        updatedMeasureMap.get((Object)attributeId).map((Function1 & Serializable)_$1 -> _$1.description()).foreach((Function1 & Serializable)measureDescription -> {
                            NodeList descriptionNodes = propertyElement.getElementsByTagName("description");
                            if (descriptionNodes.getLength() > 0) {
                                Element descriptionElement = (Element)descriptionNodes.item(0);
                                descriptionElement.setTextContent((String)measureDescription);
                                return BoxedUnit.UNIT;
                            }
                            Element descriptionElement = document1.createElement("description");
                            descriptionElement.setTextContent((String)measureDescription);
                            return propertyElement.appendChild(descriptionElement);
                        });
                        return;
                    }
                    return;
                }
            });
            return;
        }
    }

    private String getProjectSchema(String projectId, Project project, scala.collection.immutable.Map<String, Measure> updatedMeasureMap, AuthContext authCtx) {
        String string;
        HttpHeaders headers = authCtx.getAtscaleAuthHeaders(authCtx.getAtscaleAuthHeaders$default$1(), authCtx);
        HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)headers);
        RestTemplate restTemplate = new RestTemplate();
        try {
            ResponseEntity getSchemaResponse = restTemplate.exchange(this.atscaleApiClient.atscaleEngineUri() + "/projects" + this.atscaleApiClient.atscaleOrgSegment() + "/schema/" + project.catalogId(), HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReferenceMapper(), new Object[0]);
            Map responseBody = (Map)getSchemaResponse.getBody();
            Map responseMap = (Map)responseBody.get(AtscaleApiRequest$.com$collibra$marketplace$atscale$api$AtscaleApiRequest$$$JSON_RESPONSE_PROPERTY);
            Object projectSchema = String.valueOf(responseMap.get(AtscaleApiRequest$.com$collibra$marketplace$atscale$api$AtscaleApiRequest$$$JSON_RESPONSE_PROPERTY));
            projectSchema = ((String)projectSchema).replace(AtscaleApiRequest$ProjectXmlHeaders$.MODULE$.XML_VERSION(), "");
            projectSchema = AtscaleApiRequest$ProjectXmlHeaders$.MODULE$.PROJECT_SCHEMA_START_TAG() + (String)projectSchema + AtscaleApiRequest$ProjectXmlHeaders$.MODULE$.PROJECT_SCHEMA_END_TAG();
            DocumentBuilderFactory factory1 = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder1 = null;
            builder1 = factory1.newDocumentBuilder();
            Document document1 = null;
            document1 = builder1.parse(new InputSource(new StringReader((String)projectSchema)));
            String originalXml = this.formatDocumentToXml(document1);
            document1 = builder1.parse(new InputSource(new StringReader(originalXml)));
            Element cubesElement = (Element)document1.getElementsByTagName("cubes").item(0);
            NodeList attributeNodes = cubesElement.getElementsByTagName("attribute");
            this.modifySchema(attributeNodes, document1, updatedMeasureMap);
            NodeList calculatedMembersNodes = document1.getElementsByTagName("calculated-member");
            this.modifySchema(calculatedMembersNodes, document1, updatedMeasureMap);
            string = this.formatDocumentToXml(document1);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return string;
    }

    public void publishProject(String projectId, Project project, scala.collection.immutable.Map<String, Measure> updatedMeasureMap, AuthContext authCtx) {
        String requestBody = this.getProjectSchema(projectId, project, updatedMeasureMap, authCtx);
        HttpHeaders headers = authCtx.getAtscaleAuthHeaders("application/xml", authCtx);
        HttpEntity httpEntity = new HttpEntity((Object)requestBody, (MultiValueMap)headers);
        RestTemplate restTemplate = new RestTemplate();
        String publishType = "normal_publish";
        String publisherId = "system";
        String linkedProjectId = project.catalogId();
        String schemaType = "project";
        String publishProjectUrl = this.atscaleApiClient.atscaleEngineUri() + "/projects" + this.atscaleApiClient.atscaleOrgSegment() + "/schema/publish/" + projectId + "?publishType=" + publishType + "&publisherId=" + publisherId + "&linkedProjectId=" + linkedProjectId + "&schemaType=" + schemaType;
        ResponseEntity responseEntity = restTemplate.exchange(publishProjectUrl, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReferenceMapper(), new Object[0]);
        scala.collection.mutable.Map responseBody = CollectionConverters$.MODULE$.MapHasAsScala((Map)responseEntity.getBody()).asScala();
        Logger Logger_this = this.logger();
        if (Logger_this.isInfoEnabled()) {
            Logger_this.info("Publish project response " + responseBody);
            return;
        }
    }

    public Seq<Cube> retrieveAllCubes(scala.collection.immutable.Map<String, Project> allProjects, AuthContext authCtx) {
        return AtscaleApiRequest$.MODULE$.doRetrieve(this.soapQueryExecutor, "Cubes", allProjects, DaxQuery$.MODULE$.cubeNameFromCatalogSelective(), AtscaleApiRequest$.MODULE$.doRetrieve$default$5(this.soapQueryExecutor), (Function2 & Serializable)(_$2, rs) -> Cube$.MODULE$.apply(null, null, null, rs.getString(DaxResultJdbcKeys$.MODULE$.CATALOG_NAME()), null, rs.getString(DaxResultJdbcKeys$.MODULE$.CUBE_NAME()), rs.getString("CUBE_TYPE"), rs.getString(DaxResultJdbcKeys$.MODULE$.CUBE_GUID()), null, null, null, null, rs.getString("LAST_DATA_UPDATE"), null, rs.getString(DaxResultJdbcKeys$.MODULE$.DESCRIPTION()), rs.getString("CUBE_CAPTION"), rs.getString("BASE_CUBE_NAME"), Predef$.MODULE$.int2Integer(rs.getInt("CUBE_SOURCE")), rs.getString("PREFERRED_QUERY_PATTERNS"), rs.getBoolean("IS_DRILLTHROUGH_ENABLED"), false, false, false), authCtx);
    }

    public Seq<Dimension> retrieveAllDimensions(scala.collection.immutable.Map<String, Project> allProjects, AuthContext authCtx) {
        return AtscaleApiRequest$.MODULE$.doRetrieve(this.soapQueryExecutor, "Dimensions", allProjects, DaxQuery$.MODULE$.dimensionSelective(), AtscaleApiRequest$.MODULE$.doRetrieve$default$5(this.soapQueryExecutor), (Function2 & Serializable)(_$3, rs) -> Dimension$.MODULE$.apply(Predef$.MODULE$.int2Integer(rs.getRow()), Predef$.MODULE$.int2Integer(rs.getRow()), new Date().toString(), rs.getString(DaxResultJdbcKeys$.MODULE$.CATALOG_NAME()), rs.getString(DaxResultJdbcKeys$.MODULE$.SCHEMA_NAME()), rs.getString(DaxResultJdbcKeys$.MODULE$.CUBE_NAME()), rs.getString(DaxResultJdbcKeys$.MODULE$.CUBE_GUID()), rs.getString("DIMENSION_NAME"), rs.getString(DaxResultJdbcKeys$.MODULE$.DIMENSION_UNIQUE_NAME()), rs.getString("DIMENSION_GUID"), rs.getString("DIMENSION_CAPTION"), Predef$.MODULE$.int2Integer(rs.getInt("DIMENSION_ORDINAL")), Predef$.MODULE$.int2Integer(rs.getInt("DIMENSION_TYPE")), Predef$.MODULE$.int2Integer(rs.getInt("DIMENSION_CARDINALITY")), rs.getString("DEFAULT_HIERARCHY"), rs.getString(DaxResultJdbcKeys$.MODULE$.DESCRIPTION()), rs.getBoolean("IS_VIRTUAL"), rs.getBoolean("IS_READWRITE"), rs.getBoolean("DIMENSION_IS_VISIBLE"), Predef$.MODULE$.int2Integer(rs.getInt("DIMENSION_UNIQUE_SETTINGS")), rs.getString("DIMENSION_MASTER_NAME"), null, null, null), authCtx);
    }

    public Seq<Measure> retrieveAllMeasures(scala.collection.immutable.Map<String, Project> allProjects, AuthContext authCtx) {
        return AtscaleApiRequest$.MODULE$.doRetrieve(this.soapQueryExecutor, "Measures", allProjects, DaxQuery$.MODULE$.measureSelective(), AtscaleApiRequest$.MODULE$.doRetrieve$default$5(this.soapQueryExecutor), (Function2 & Serializable)(_$4, rs) -> Measure$.MODULE$.apply(Predef$.MODULE$.int2Integer(rs.getRow()), new Date().toString(), rs.getString(DaxResultJdbcKeys$.MODULE$.CATALOG_NAME()), rs.getString(DaxResultJdbcKeys$.MODULE$.SCHEMA_NAME()), rs.getString(DaxResultJdbcKeys$.MODULE$.CUBE_NAME()), rs.getString(DaxResultJdbcKeys$.MODULE$.CUBE_GUID()), rs.getString("MEASURE_NAME"), rs.getString("MEASURE_UNIQUE_NAME"), rs.getString("MEASURE_GUID"), Predef$.MODULE$.int2Integer(rs.getRow()), rs.getString("MEASURE_CAPTION"), Predef$.MODULE$.int2Integer(rs.getInt("MEASURE_AGGREGATOR")), null, null, rs.getString("COLUMN_NAME"), null, Predef$.MODULE$.int2Integer(rs.getInt("NUMERIC_PRECISION")), Predef$.MODULE$.int2Integer(rs.getInt("NUMERIC_SCALE")), Predef$.MODULE$.int2Integer(rs.getInt("MEASURE_UNITS")), rs.getString(DaxResultJdbcKeys$.MODULE$.DESCRIPTION()), rs.getString(DaxResultJdbcKeys$.MODULE$.EXPRESSION()), rs.getBoolean("MEASURE_IS_VISIBLE"), rs.getString("MEASURE_IS_VISIBLE"), rs.getString("MEASURE_NAME_SQL_COLUMN_NAME"), rs.getString("MEASURE_UNQUALIFIED_CAPTION"), rs.getString("MEASUREGROUP_NAME"), rs.getString("MEASURE_DISPLAY_FOLDER"), rs.getString("DEFAULT_FORMAT_STRING"), rs.getString(DaxResultJdbcKeys$.MODULE$.DATASET_NAME()), null, rs.getBoolean("IS_METRICAL_ATTRIBUTE"), rs.getString("PARENT_LEVEL_ID"), rs.getString("PARENT_LEVEL_NAME"), null), authCtx);
    }

    public Seq<Hierarchy> retrieveAllHierarchies(scala.collection.immutable.Map<String, Project> allProjects, AuthContext authCtx) {
        return AtscaleApiRequest$.MODULE$.doRetrieve(this.soapQueryExecutor, "Hierarchies", allProjects, DaxQuery$.MODULE$.hierarchySelective(), AtscaleApiRequest$.MODULE$.doRetrieve$default$5(this.soapQueryExecutor), (Function2 & Serializable)(_$5, rs) -> Hierarchy$.MODULE$.apply(Predef$.MODULE$.int2Integer(rs.getRow()), new Date().toString(), rs.getString(DaxResultJdbcKeys$.MODULE$.CATALOG_NAME()), Predef$.MODULE$.int2Integer(rs.getRow()), rs.getString(DaxResultJdbcKeys$.MODULE$.SCHEMA_NAME()), rs.getString(DaxResultJdbcKeys$.MODULE$.CUBE_NAME()), rs.getString(DaxResultJdbcKeys$.MODULE$.CUBE_GUID()), rs.getString(DaxResultJdbcKeys$.MODULE$.DIMENSION_UNIQUE_NAME()), rs.getString("HIERARCHY_NAME"), rs.getString("HIERARCHY_UNIQUE_NAME"), rs.getString("HIERARCHY_GUID"), rs.getString("HIERARCHY_CAPTION"), Predef$.MODULE$.int2Integer(rs.getInt("DIMENSION_TYPE")), Predef$.MODULE$.int2Integer(rs.getInt("HIERARCHY_CARDINALITY")), rs.getString("DEFAULT_MEMBER"), rs.getString("ALL_MEMBER"), rs.getString(DaxResultJdbcKeys$.MODULE$.DESCRIPTION()), Predef$.MODULE$.int2Integer(rs.getInt("STRUCTURE")), rs.getBoolean("IS_VIRTUAL"), rs.getBoolean("IS_READWRITE"), Predef$.MODULE$.int2Integer(rs.getInt("DIMENSION_UNIQUE_SETTINGS")), rs.getString("DIMENSION_MASTER_UNIQUE_NAME"), rs.getBoolean("DIMENSION_IS_VISIBLE"), Predef$.MODULE$.int2Integer(rs.getInt("HIERARCHY_ORIGIN")), rs.getString("HIERARCHY_DISPLAY_FOLDER"), Predef$.MODULE$.int2Integer(rs.getInt("INSTANCE_SELECTION")), Predef$.MODULE$.int2Integer(rs.getInt("GROUPING_BEHAVIOR")), rs.getString("STRUCTURE_TYPE"), rs.getBoolean("DIMENSION_IS_SHARED"), rs.getBoolean("HIERARCHY_IS_VISIBLE"), Predef$.MODULE$.int2Integer(rs.getInt("HIERARCHY_ORDINAL"))), authCtx);
    }

    public Seq<Level> retrieveAllLevels(scala.collection.immutable.Map<String, Project> allProjects, AuthContext authCtx) {
        return AtscaleApiRequest$.MODULE$.doRetrieve(this.soapQueryExecutor, "Levels", allProjects, DaxQuery$.MODULE$.levelSelective(), AtscaleApiRequest$.MODULE$.doRetrieve$default$5(this.soapQueryExecutor), (Function2 & Serializable)(_$6, rs) -> {
            void var2_2;
            String guid;
            return Level$.MODULE$.apply(Predef$.MODULE$.int2Integer(rs.getRow()), Predef$.MODULE$.int2Integer(rs.getRow()), new Date().toString(), rs.getString(DaxResultJdbcKeys$.MODULE$.CATALOG_NAME()), rs.getString(DaxResultJdbcKeys$.MODULE$.SCHEMA_NAME()), rs.getString(DaxResultJdbcKeys$.MODULE$.CUBE_NAME()), rs.getString(DaxResultJdbcKeys$.MODULE$.CUBE_GUID()), rs.getString(DaxResultJdbcKeys$.MODULE$.DATASET_NAME()), rs.getString(DaxResultJdbcKeys$.MODULE$.DIMENSION_UNIQUE_NAME()), rs.getString("HIERARCHY_UNIQUE_NAME"), rs.getString("LEVEL_NAME"), Predef$.MODULE$.int2Integer(rs.getInt("LEVEL_NUMBER")), rs.getString("LEVEL_UNIQUE_NAME"), (String)((guid = rs.getString("LEVEL_GUID")).contains("+") ? guid.substring(0, guid.indexOf("+")) : var2_2), rs.getString("LEVEL_CAPTION"), rs.getString(DaxResultJdbcKeys$.MODULE$.DESCRIPTION()), false, rs.getString("LEVEL_NAME_SQL_COLUMN_NAME"), rs.getString("LEVEL_KEY_SQL_COLUMN_NAME"), rs.getString("LEVEL_SORT_SQL_COLUMN_NAME"), rs.getString("LEVEL_DBTYPE_NAME_COLUMN"), rs.getString("LEVEL_DBTYPE_SORT_COLUMN"), rs.getBoolean("IS_PRIMARY"), rs.getString("PARENT_LEVEL_ID"));
        }, authCtx);
    }

    public Seq<ConnectionGroup> retrieveAllConnectionGroups(scala.collection.immutable.Map<String, Project> allProjects, AuthContext authCtx) {
        return AtscaleApiRequest$.MODULE$.doRetrieve(this.soapQueryExecutor, "Connection Groups", allProjects, DaxQuery$.MODULE$.connectionGroups(), AtscaleApiRequest$.MODULE$.doRetrieve$default$5(this.soapQueryExecutor), (Function2 & Serializable)(_$7, rs) -> ConnectionGroup$.MODULE$.apply(rs.getString("ID"), rs.getString("NAME"), rs.getString("PLATFORM_TYPE"), rs.getString(DaxResultJdbcKeys$.MODULE$.CONNECTION_ID()), rs.getString("FILESYSTEM_URI"), rs.getString("FILESYSTEM_TYPE"), rs.getString("AGGREGATE_SCHEMA"), rs.getString(DaxResultJdbcKeys$.MODULE$.DATABASE()), rs.getBoolean("IS_IMPERSONATION_ENABLED"), rs.getBoolean("IS_CANARY_ALWAYS_ENABLED"), rs.getBoolean("IS_PARTIAL_AGG_HIT_ENABLED"), rs.getBoolean("READ_ONLY")), authCtx);
    }

    public Seq<Connection> retrieveAllConnections(scala.collection.immutable.Map<String, Project> allProjects, AuthContext authCtx) {
        return AtscaleApiRequest$.MODULE$.doRetrieve(this.soapQueryExecutor, "Connection Subgroups", allProjects, DaxQuery$.MODULE$.connectionSubgroups(), AtscaleApiRequest$.MODULE$.doRetrieve$default$5(this.soapQueryExecutor), (Function2 & Serializable)(_$8, rs) -> Connection$.MODULE$.apply(rs.getString("ID"), rs.getString("GROUP_ID"), rs.getString("NAME"), rs.getString("HOSTS"), rs.getString("PORT"), rs.getString("USERNAME"), rs.getString("CONNECTOR_TYPE"), rs.getBoolean("IS_KERBEROS_CLIENT_ENABLED"), rs.getString("EXTRA_JDBC_FLAGS"), rs.getString("MANAGEMENT_CONSOLE_URL"), rs.getString(DaxResultJdbcKeys$.MODULE$.DATABASE()), rs.getString("QUERY_ROLES")), authCtx);
    }

    public Seq<Dataset> retrieveAllDatasets(scala.collection.immutable.Map<String, Project> allProjects, AuthContext authCtx) {
        return AtscaleApiRequest$.MODULE$.doRetrieve(this.soapQueryExecutor, "Datasets", allProjects, DaxQuery$.MODULE$.datasetSelective(), AtscaleApiRequest$.MODULE$.doRetrieve$default$5(this.soapQueryExecutor), (Function2 & Serializable)(_$9, rs) -> Dataset$.MODULE$.apply(rs.getString(DaxResultJdbcKeys$.MODULE$.CATALOG_NAME()), rs.getString(DaxResultJdbcKeys$.MODULE$.CUBE_GUID()), rs.getString(DaxResultJdbcKeys$.MODULE$.DATASET_NAME()), rs.getString(DaxResultJdbcKeys$.MODULE$.DATABASE()), rs.getString("TABLE"), rs.getString("SCHEMA"), rs.getString(DaxResultJdbcKeys$.MODULE$.EXPRESSION()), rs.getString(DaxResultJdbcKeys$.MODULE$.CONNECTION_ID())), authCtx);
    }

    public Seq<Column> retrieveAllColumns(scala.collection.immutable.Map<String, Project> allProjects, AuthContext authCtx) {
        return AtscaleApiRequest$.MODULE$.doRetrieve(this.soapQueryExecutor, "Columns", allProjects, DaxQuery$.MODULE$.columnSelective(), AtscaleApiRequest$.MODULE$.doRetrieve$default$5(this.soapQueryExecutor), (Function2 & Serializable)(_$10, rs) -> Column$.MODULE$.apply(rs.getString(DaxResultJdbcKeys$.MODULE$.CATALOG_NAME()), rs.getString(DaxResultJdbcKeys$.MODULE$.DATASET_NAME()), rs.getString("COLUMN_NAME"), (String)AtscaleApiRequest$.MODULE$.dataTypeNamesLookup().getOrElse((Object)BoxesRunTime.boxToInteger((int)rs.getInt("DATA_TYPE")), () -> AtscaleApiRequest.retrieveAllColumns$$anonfun$1$$anonfun$1(rs)), rs.getString(DaxResultJdbcKeys$.MODULE$.EXPRESSION()), rs.getString(DaxResultJdbcKeys$.MODULE$.CONNECTION_ID()), null), authCtx);
    }

    public Seq<Dependency> retrieveAllDependencies(scala.collection.immutable.Map<String, Project> allProjects, Seq<Column> allColumns, AuthContext authCtx) {
        return (Seq)AtscaleApiRequest$.MODULE$.doRetrieve(this.soapQueryExecutor, "Dependencies", allProjects, DaxQuery$.MODULE$.discoverCalculatedDependencies(), (Option<String>)Some$.MODULE$.apply((Object)"<Catalog>%s</Catalog>"), (Function2 & Serializable)(projectName, rs) -> {
            String referencedObjectType;
            String string = referencedObjectType = rs.getString("REFERENCED_OBJECT_TYPE");
            String string2 = CollibraConstants$.MODULE$.AssetTypeColumnName();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                String referencedObject = rs.getString("REFERENCED_OBJECT");
                String table = rs.getString("TABLE");
                String object = rs.getString("OBJECT");
                if (allColumns.exists((Function1 & Serializable)col -> {
                    String string = col.columnName();
                    String string2 = referencedObject;
                    if (string == null) {
                        if (string2 != null) {
                            return false;
                        }
                    } else if (!string.equals(string2)) return false;
                    String string3 = col.datasetName();
                    String string4 = table;
                    if (string3 == null) {
                        if (string4 == null) return true;
                        return false;
                    } else {
                        if (!string3.equals(string4)) return false;
                        return true;
                    }
                })) {
                    return Some$.MODULE$.apply((Object)Dependency$.MODULE$.apply((String)projectName, rs.getString(DaxResultJdbcKeys$.MODULE$.CUBE_NAME()), rs.getString("DATABASE_NAME"), rs.getString("OBJECT_TYPE"), rs.getString("TABLE"), object, rs.getString(DaxResultJdbcKeys$.MODULE$.EXPRESSION()), rs.getString("REFERENCED_OBJECT_TYPE"), rs.getString("REFERENCED_TABLE"), referencedObject, rs.getString("REFERENCED_EXPRESSION")));
                }
                Logger Logger_this = this.logger();
                if (Logger_this.isWarnEnabled()) {
                    Logger_this.warn(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Dependency from '" + object + "' in project '" + projectName + "' not added\n                          | because column '" + table + AssetFormatConstants$.MODULE$.ASSET_NAME_SEPARATOR() + object + " not found")));
                }
                return None$.MODULE$;
            }
            return None$.MODULE$;
        }, authCtx).flatten(Predef$.MODULE$.$conforms());
    }

    private final Tuple2<String, Folder> createFolderPair(String catalogName, String cubeName, String folderName) {
        String folderPath = catalogName + "." + cubeName + "." + folderName;
        Folder folder = Folder$.MODULE$.apply(catalogName, cubeName, folderName);
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)folderPath);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)folder);
    }

    public scala.collection.immutable.Map<String, Folder> retrieveAllFolders(Seq<Measure> allMeasures, Seq<Hierarchy> allHierarchies) {
        Seq measureFolders = (Seq)allMeasures.flatMap((Function1 & Serializable)x$1 -> {
            Measure measure = x$1;
            Measure measure2 = measure;
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(measure2.measureDisplayFolder()))) {
                return Some$.MODULE$.apply(this.createFolderPair(measure2.catalogName(), measure2.cubeName(), measure2.measureDisplayFolder()));
            }
            Measure measure3 = measure;
            return None$.MODULE$;
        });
        Seq hierarchyFolders = (Seq)allHierarchies.flatMap((Function1 & Serializable)x$1 -> {
            Hierarchy hierarchy = x$1;
            Hierarchy hierarchy2 = hierarchy;
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(hierarchy2.hierarchyDisplayFolder()))) {
                return Some$.MODULE$.apply(this.createFolderPair(hierarchy2.catalogName(), hierarchy2.cubeName(), hierarchy2.hierarchyDisplayFolder()));
            }
            Hierarchy measure = hierarchy;
            return None$.MODULE$;
        });
        return ((IterableOnceOps)measureFolders.$plus$plus((IterableOnce)hierarchyFolders)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Seq<String> getPublishedProjectNames(AuthContext authCtx) {
        Seq seq;
        try {
            String jsonResponseStr = this.atscaleApiClient.executeApiCall(AtscaleApiRequest$.com$collibra$marketplace$atscale$api$AtscaleApiRequest$$$PublishProjectsPath, authCtx);
            JSONParser jsonParser = new JSONParser();
            JSONArray jsonProjects = (JSONArray)((JSONObject)((JSONObject)jsonParser.parse(jsonResponseStr)).get((Object)"response")).get((Object)"projects");
            Object object = Predef$.MODULE$.refArrayOps(jsonProjects.toArray());
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)x$1 -> {
                Object object = x$1;
                if (object instanceof JSONObject) {
                    JSONObject project = (JSONObject)object;
                    return project.get((Object)"name").toString();
                }
                Object other = object;
                throw new RuntimeException("Unexpected JSON object: " + other);
            }, ClassTag$.MODULE$.apply(String.class)));
            Seq projectNames = ArrayOps$.MODULE$.toSeq$extension(object2);
            Logger Logger_this = this.logger();
            if (Logger_this.isInfoEnabled()) {
                Logger_this.info("AtScale api returned the following project names " + projectNames);
            }
            if (projectNames.isEmpty()) {
                Logger Logger_this2 = this.logger();
                if (Logger_this2.isErrorEnabled()) {
                    Logger_this2.error("No published projects found via atscale API to return");
                }
                seq = (Seq)package$.MODULE$.Seq().empty();
            } else {
                seq = projectNames;
            }
        }
        catch (Exception e) {
            Logger Logger_this = this.logger();
            if (Logger_this.isErrorEnabled()) {
                Logger_this.error("Error retrieving list of published project names", (Throwable)e);
            }
            throw e;
        }
        return seq;
    }

    public scala.collection.immutable.Map<String, Project> getProjects(AuthContext authCtx) {
        scala.collection.immutable.Map map;
        String query = DaxQuery$.MODULE$.listProjects();
        Logger Logger_this = this.logger();
        if (Logger_this.isDebugEnabled()) {
            Logger_this.debug("Retrieving and deduplicating all catalogs / projects from AtScale api using xmla query " + query);
        }
        try {
            scala.collection.mutable.Map projectsByProjectName = (scala.collection.mutable.Map)Map$.MODULE$.empty();
            Seq projectsToLoad = JdbcHelpers$.MODULE$.readResultSetAsOpts(this.soapQueryExecutor.executeQuery(query, authCtx), (Function1 & Serializable)rs -> {
                block5: {
                    String projectName = rs.getString(DaxResultJdbcKeys$.MODULE$.CATALOG_NAME());
                    if (this.appConfig.filterProjects().isEmpty() || this.appConfig.filterProjects().contains((Object)projectName)) {
                        Seq<String> publishedProjects = this.getPublishedProjectNames(authCtx);
                        if (publishedProjects.contains((Object)rs.getString("CATALOG_NAME"))) {
                            Some some;
                            try {
                                Project project = Project$.MODULE$.apply(projectName, null, Predef$.MODULE$.int2Integer(rs.getRow()), Predef$.MODULE$.int2Integer(rs.getRow()), new Date().toString(), rs.getString("CATALOG_GUID"), rs.getString("ROLES"), rs.getString("DATE_MODIFIED"), Predef$.MODULE$.int2Integer(rs.getInt("COMPATIBILITY_LEVEL")), Predef$.MODULE$.int2Integer(rs.getInt("TYPE")), Predef$.MODULE$.int2Integer(rs.getInt("VERSION")), rs.getString("DATABASE_ID"), rs.getString("DATE_QUERIED"), rs.getBoolean("CURRENTLY_USED"), null, (Seq<Measure>)((Seq)package$.MODULE$.Seq().empty()), null);
                                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)projectName);
                                projectsByProjectName.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)project));
                                some = Some$.MODULE$.apply((Object)(projectName + "(" + project.catalogId() + ")"));
                            }
                            catch (Exception exception) {
                                Logger Logger_this = this.logger();
                                if (Logger_this.isErrorEnabled()) {
                                    Logger_this.error("Error parsing project from the xmla result set", (Throwable)exception);
                                }
                                throw exception;
                            }
                            return some;
                        }
                        return None$.MODULE$;
                    }
                    Logger Logger_this = this.logger();
                    if (!Logger_this.isInfoEnabled()) break block5;
                    Logger_this.info("Skipping project '" + projectName + "' since atscale.filter.project setting is '" + this.appConfig.filterProjectString() + "'");
                }
                return None$.MODULE$;
            });
            Logger Logger_this2 = this.logger();
            if (Logger_this2.isInfoEnabled()) {
                Logger_this2.info("Populated list of " + projectsByProjectName.size() + " published and deduplicated project(s): " + projectsToLoad);
            }
            map = projectsByProjectName.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        catch (Exception ex) {
            Logger Logger_this3 = this.logger();
            if (Logger_this3.isErrorEnabled()) {
                Logger_this3.error("Error while getting project names for extraction.", (Throwable)ex);
            }
            throw ex;
        }
        return map;
    }

    private static final String retrieveAllColumns$$anonfun$1$$anonfun$1(ResultSet rs$1) {
        throw new IllegalArgumentException("Unknown data type " + rs$1.getInt("DATA_TYPE"));
    }
}

