/*
 * Decompiled with CFR 0.152.
 */
package com.collibra.importer.rest.client.model;

import com.collibra.importer.rest.client.model.ImportCounters;
import com.collibra.importer.rest.client.model.SubcategorySummary;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"resourceType", "counters", "subcategories"})
public class ResourceTypeSummary {
    public static final String JSON_PROPERTY_RESOURCE_TYPE = "resourceType";
    @Nullable
    private ResourceTypeEnum resourceType;
    public static final String JSON_PROPERTY_COUNTERS = "counters";
    @Nullable
    private ImportCounters counters;
    public static final String JSON_PROPERTY_SUBCATEGORIES = "subcategories";
    @Nullable
    private List<SubcategorySummary> subcategories = new ArrayList<SubcategorySummary>();

    public ResourceTypeSummary resourceType(@Nullable ResourceTypeEnum resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    @Nullable
    @JsonProperty(value="resourceType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ResourceTypeEnum getResourceType() {
        return this.resourceType;
    }

    @JsonProperty(value="resourceType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResourceType(@Nullable ResourceTypeEnum resourceType) {
        this.resourceType = resourceType;
    }

    public ResourceTypeSummary counters(@Nullable ImportCounters counters) {
        this.counters = counters;
        return this;
    }

    @Nullable
    @JsonProperty(value="counters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ImportCounters getCounters() {
        return this.counters;
    }

    @JsonProperty(value="counters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCounters(@Nullable ImportCounters counters) {
        this.counters = counters;
    }

    public ResourceTypeSummary subcategories(@Nullable List<SubcategorySummary> subcategories) {
        this.subcategories = subcategories;
        return this;
    }

    public ResourceTypeSummary addSubcategoriesItem(SubcategorySummary subcategoriesItem) {
        if (this.subcategories == null) {
            this.subcategories = new ArrayList<SubcategorySummary>();
        }
        this.subcategories.add(subcategoriesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="subcategories")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SubcategorySummary> getSubcategories() {
        return this.subcategories;
    }

    @JsonProperty(value="subcategories")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubcategories(@Nullable List<SubcategorySummary> subcategories) {
        this.subcategories = subcategories;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceTypeSummary resourceTypeSummary = (ResourceTypeSummary)o;
        return Objects.equals((Object)this.resourceType, (Object)resourceTypeSummary.resourceType) && Objects.equals(this.counters, resourceTypeSummary.counters) && Objects.equals(this.subcategories, resourceTypeSummary.subcategories);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.resourceType, this.counters, this.subcategories});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourceTypeSummary {\n");
        sb.append("    resourceType: ").append(this.toIndentedString((Object)this.resourceType)).append("\n");
        sb.append("    counters: ").append(this.toIndentedString(this.counters)).append("\n");
        sb.append("    subcategories: ").append(this.toIndentedString(this.subcategories)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ResourceTypeEnum {
        COMMUNITY(String.valueOf("COMMUNITY")),
        DOMAIN(String.valueOf("DOMAIN")),
        ASSET(String.valueOf("ASSET")),
        ATTRIBUTE(String.valueOf("ATTRIBUTE")),
        RELATION(String.valueOf("RELATION")),
        COMPLEX_RELATION(String.valueOf("COMPLEX_RELATION")),
        MAPPING(String.valueOf("MAPPING")),
        RESPONSIBILITY(String.valueOf("RESPONSIBILITY"));

        private String value;

        private ResourceTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ResourceTypeEnum fromValue(String value) {
            for (ResourceTypeEnum b : ResourceTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

