/*
 * Decompiled with CFR 0.152.
 */
package com.collibra.importer.rest.client.model;

import com.collibra.importer.rest.client.model.ResourceTypeSummary;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"resourceTypes", "errorsCount", "importJobState"})
public class ImportSummary {
    public static final String JSON_PROPERTY_RESOURCE_TYPES = "resourceTypes";
    @Nullable
    private List<ResourceTypeSummary> resourceTypes = new ArrayList<ResourceTypeSummary>();
    public static final String JSON_PROPERTY_ERRORS_COUNT = "errorsCount";
    @Nullable
    private Integer errorsCount;
    public static final String JSON_PROPERTY_IMPORT_JOB_STATE = "importJobState";
    @Nullable
    private ImportJobStateEnum importJobState;

    public ImportSummary resourceTypes(@Nullable List<ResourceTypeSummary> resourceTypes) {
        this.resourceTypes = resourceTypes;
        return this;
    }

    public ImportSummary addResourceTypesItem(ResourceTypeSummary resourceTypesItem) {
        if (this.resourceTypes == null) {
            this.resourceTypes = new ArrayList<ResourceTypeSummary>();
        }
        this.resourceTypes.add(resourceTypesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="resourceTypes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ResourceTypeSummary> getResourceTypes() {
        return this.resourceTypes;
    }

    @JsonProperty(value="resourceTypes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResourceTypes(@Nullable List<ResourceTypeSummary> resourceTypes) {
        this.resourceTypes = resourceTypes;
    }

    public ImportSummary errorsCount(@Nullable Integer errorsCount) {
        this.errorsCount = errorsCount;
        return this;
    }

    @Nullable
    @JsonProperty(value="errorsCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getErrorsCount() {
        return this.errorsCount;
    }

    @JsonProperty(value="errorsCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setErrorsCount(@Nullable Integer errorsCount) {
        this.errorsCount = errorsCount;
    }

    public ImportSummary importJobState(@Nullable ImportJobStateEnum importJobState) {
        this.importJobState = importJobState;
        return this;
    }

    @Nullable
    @JsonProperty(value="importJobState")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ImportJobStateEnum getImportJobState() {
        return this.importJobState;
    }

    @JsonProperty(value="importJobState")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setImportJobState(@Nullable ImportJobStateEnum importJobState) {
        this.importJobState = importJobState;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImportSummary importSummary = (ImportSummary)o;
        return Objects.equals(this.resourceTypes, importSummary.resourceTypes) && Objects.equals(this.errorsCount, importSummary.errorsCount) && Objects.equals((Object)this.importJobState, (Object)importSummary.importJobState);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.resourceTypes, this.errorsCount, this.importJobState});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ImportSummary {\n");
        sb.append("    resourceTypes: ").append(this.toIndentedString(this.resourceTypes)).append("\n");
        sb.append("    errorsCount: ").append(this.toIndentedString(this.errorsCount)).append("\n");
        sb.append("    importJobState: ").append(this.toIndentedString((Object)this.importJobState)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ImportJobStateEnum {
        COMPLETED(String.valueOf("COMPLETED")),
        FAILED(String.valueOf("FAILED")),
        COMPLETED_WITH_ERRORS(String.valueOf("COMPLETED_WITH_ERRORS")),
        ABORTED(String.valueOf("ABORTED"));

        private String value;

        private ImportJobStateEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ImportJobStateEnum fromValue(String value) {
            for (ImportJobStateEnum b : ImportJobStateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

