/*
 * Decompiled with CFR 0.152.
 */
package com.collibra.importer.rest.client.model;

import com.collibra.importer.rest.client.model.ImportCommandReference;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nullable;
import java.util.Objects;

@JsonPropertyOrder(value={"errorType", "resourceType", "errorMessage", "command"})
public class ImportError {
    public static final String JSON_PROPERTY_ERROR_TYPE = "errorType";
    @Nullable
    private ErrorTypeEnum errorType;
    public static final String JSON_PROPERTY_RESOURCE_TYPE = "resourceType";
    @Nullable
    private ResourceTypeEnum resourceType;
    public static final String JSON_PROPERTY_ERROR_MESSAGE = "errorMessage";
    @Nullable
    private String errorMessage;
    public static final String JSON_PROPERTY_COMMAND = "command";
    @Nullable
    private ImportCommandReference command;

    public ImportError errorType(@Nullable ErrorTypeEnum errorType) {
        this.errorType = errorType;
        return this;
    }

    @Nullable
    @JsonProperty(value="errorType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ErrorTypeEnum getErrorType() {
        return this.errorType;
    }

    @JsonProperty(value="errorType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setErrorType(@Nullable ErrorTypeEnum errorType) {
        this.errorType = errorType;
    }

    public ImportError resourceType(@Nullable ResourceTypeEnum resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    @Nullable
    @JsonProperty(value="resourceType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ResourceTypeEnum getResourceType() {
        return this.resourceType;
    }

    @JsonProperty(value="resourceType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResourceType(@Nullable ResourceTypeEnum resourceType) {
        this.resourceType = resourceType;
    }

    public ImportError errorMessage(@Nullable String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @Nullable
    @JsonProperty(value="errorMessage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @JsonProperty(value="errorMessage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setErrorMessage(@Nullable String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public ImportError command(@Nullable ImportCommandReference command) {
        this.command = command;
        return this;
    }

    @Nullable
    @JsonProperty(value="command")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ImportCommandReference getCommand() {
        return this.command;
    }

    @JsonProperty(value="command")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCommand(@Nullable ImportCommandReference command) {
        this.command = command;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImportError importError = (ImportError)o;
        return Objects.equals((Object)this.errorType, (Object)importError.errorType) && Objects.equals((Object)this.resourceType, (Object)importError.resourceType) && Objects.equals(this.errorMessage, importError.errorMessage) && Objects.equals(this.command, importError.command);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.errorType, this.resourceType, this.errorMessage, this.command});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ImportError {\n");
        sb.append("    errorType: ").append(this.toIndentedString((Object)this.errorType)).append("\n");
        sb.append("    resourceType: ").append(this.toIndentedString((Object)this.resourceType)).append("\n");
        sb.append("    errorMessage: ").append(this.toIndentedString(this.errorMessage)).append("\n");
        sb.append("    command: ").append(this.toIndentedString(this.command)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ErrorTypeEnum {
        VALIDATION(String.valueOf("VALIDATION")),
        RUNTIME(String.valueOf("RUNTIME"));

        private String value;

        private ErrorTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ErrorTypeEnum fromValue(String value) {
            for (ErrorTypeEnum b : ErrorTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ResourceTypeEnum {
        COMMUNITY(String.valueOf("COMMUNITY")),
        DOMAIN(String.valueOf("DOMAIN")),
        ASSET(String.valueOf("ASSET")),
        ATTRIBUTE(String.valueOf("ATTRIBUTE")),
        RELATION(String.valueOf("RELATION")),
        COMPLEX_RELATION(String.valueOf("COMPLEX_RELATION")),
        MAPPING(String.valueOf("MAPPING")),
        RESPONSIBILITY(String.valueOf("RESPONSIBILITY"));

        private String value;

        private ResourceTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ResourceTypeEnum fromValue(String value) {
            for (ResourceTypeEnum b : ResourceTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

