/*
 * Decompiled with CFR 0.152.
 */
package com.collibra.core.rest.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

@JsonPropertyOrder(value={"workflowDefinitionId", "businessItemIds", "businessItemType", "formProperties", "guestUserId", "sendNotification"})
public class StartWorkflowInstancesRequest {
    public static final String JSON_PROPERTY_WORKFLOW_DEFINITION_ID = "workflowDefinitionId";
    @Nonnull
    private UUID workflowDefinitionId;
    public static final String JSON_PROPERTY_BUSINESS_ITEM_IDS = "businessItemIds";
    @Nullable
    private List<UUID> businessItemIds = new ArrayList<UUID>();
    public static final String JSON_PROPERTY_BUSINESS_ITEM_TYPE = "businessItemType";
    @Nullable
    private BusinessItemTypeEnum businessItemType;
    public static final String JSON_PROPERTY_FORM_PROPERTIES = "formProperties";
    @Nullable
    private Map<String, String> formProperties = new HashMap<String, String>();
    public static final String JSON_PROPERTY_GUEST_USER_ID = "guestUserId";
    @Nullable
    private UUID guestUserId;
    public static final String JSON_PROPERTY_SEND_NOTIFICATION = "sendNotification";
    @Nullable
    private Boolean sendNotification;

    public StartWorkflowInstancesRequest workflowDefinitionId(@Nonnull UUID workflowDefinitionId) {
        this.workflowDefinitionId = workflowDefinitionId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="workflowDefinitionId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getWorkflowDefinitionId() {
        return this.workflowDefinitionId;
    }

    @JsonProperty(value="workflowDefinitionId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setWorkflowDefinitionId(@Nonnull UUID workflowDefinitionId) {
        this.workflowDefinitionId = workflowDefinitionId;
    }

    public StartWorkflowInstancesRequest businessItemIds(@Nullable List<UUID> businessItemIds) {
        this.businessItemIds = businessItemIds;
        return this;
    }

    public StartWorkflowInstancesRequest addBusinessItemIdsItem(UUID businessItemIdsItem) {
        if (this.businessItemIds == null) {
            this.businessItemIds = new ArrayList<UUID>();
        }
        this.businessItemIds.add(businessItemIdsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="businessItemIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<UUID> getBusinessItemIds() {
        return this.businessItemIds;
    }

    @JsonProperty(value="businessItemIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBusinessItemIds(@Nullable List<UUID> businessItemIds) {
        this.businessItemIds = businessItemIds;
    }

    public StartWorkflowInstancesRequest businessItemType(@Nullable BusinessItemTypeEnum businessItemType) {
        this.businessItemType = businessItemType;
        return this;
    }

    @Nullable
    @JsonProperty(value="businessItemType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BusinessItemTypeEnum getBusinessItemType() {
        return this.businessItemType;
    }

    @JsonProperty(value="businessItemType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBusinessItemType(@Nullable BusinessItemTypeEnum businessItemType) {
        this.businessItemType = businessItemType;
    }

    public StartWorkflowInstancesRequest formProperties(@Nullable Map<String, String> formProperties) {
        this.formProperties = formProperties;
        return this;
    }

    public StartWorkflowInstancesRequest putFormPropertiesItem(String key, String formPropertiesItem) {
        if (this.formProperties == null) {
            this.formProperties = new HashMap<String, String>();
        }
        this.formProperties.put(key, formPropertiesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="formProperties")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getFormProperties() {
        return this.formProperties;
    }

    @JsonProperty(value="formProperties")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFormProperties(@Nullable Map<String, String> formProperties) {
        this.formProperties = formProperties;
    }

    public StartWorkflowInstancesRequest guestUserId(@Nullable UUID guestUserId) {
        this.guestUserId = guestUserId;
        return this;
    }

    @Nullable
    @JsonProperty(value="guestUserId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getGuestUserId() {
        return this.guestUserId;
    }

    @JsonProperty(value="guestUserId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGuestUserId(@Nullable UUID guestUserId) {
        this.guestUserId = guestUserId;
    }

    public StartWorkflowInstancesRequest sendNotification(@Nullable Boolean sendNotification) {
        this.sendNotification = sendNotification;
        return this;
    }

    @Nullable
    @JsonProperty(value="sendNotification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSendNotification() {
        return this.sendNotification;
    }

    @JsonProperty(value="sendNotification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSendNotification(@Nullable Boolean sendNotification) {
        this.sendNotification = sendNotification;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StartWorkflowInstancesRequest startWorkflowInstancesRequest = (StartWorkflowInstancesRequest)o;
        return Objects.equals(this.workflowDefinitionId, startWorkflowInstancesRequest.workflowDefinitionId) && Objects.equals(this.businessItemIds, startWorkflowInstancesRequest.businessItemIds) && Objects.equals((Object)this.businessItemType, (Object)startWorkflowInstancesRequest.businessItemType) && Objects.equals(this.formProperties, startWorkflowInstancesRequest.formProperties) && Objects.equals(this.guestUserId, startWorkflowInstancesRequest.guestUserId) && Objects.equals(this.sendNotification, startWorkflowInstancesRequest.sendNotification);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.workflowDefinitionId, this.businessItemIds, this.businessItemType, this.formProperties, this.guestUserId, this.sendNotification});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StartWorkflowInstancesRequest {\n");
        sb.append("    workflowDefinitionId: ").append(this.toIndentedString(this.workflowDefinitionId)).append("\n");
        sb.append("    businessItemIds: ").append(this.toIndentedString(this.businessItemIds)).append("\n");
        sb.append("    businessItemType: ").append(this.toIndentedString((Object)this.businessItemType)).append("\n");
        sb.append("    formProperties: ").append(this.toIndentedString(this.formProperties)).append("\n");
        sb.append("    guestUserId: ").append(this.toIndentedString(this.guestUserId)).append("\n");
        sb.append("    sendNotification: ").append(this.toIndentedString(this.sendNotification)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum BusinessItemTypeEnum {
        ASSET(String.valueOf("ASSET")),
        DOMAIN(String.valueOf("DOMAIN")),
        COMMUNITY(String.valueOf("COMMUNITY")),
        GLOBAL(String.valueOf("GLOBAL"));

        private String value;

        private BusinessItemTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static BusinessItemTypeEnum fromValue(String value) {
            for (BusinessItemTypeEnum b : BusinessItemTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

