/*
 * Decompiled with CFR 0.152.
 */
package com.collibra.core.rest.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

@JsonPropertyOrder(value={"typeId", "relatedAssetIds", "relationDirection"})
public class SetAssetRelationsRequest {
    public static final String JSON_PROPERTY_TYPE_ID = "typeId";
    @Nonnull
    private UUID typeId;
    public static final String JSON_PROPERTY_RELATED_ASSET_IDS = "relatedAssetIds";
    @Nonnull
    private List<UUID> relatedAssetIds = new ArrayList<UUID>();
    public static final String JSON_PROPERTY_RELATION_DIRECTION = "relationDirection";
    @Nonnull
    private RelationDirectionEnum relationDirection;

    public SetAssetRelationsRequest typeId(@Nonnull UUID typeId) {
        this.typeId = typeId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="typeId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getTypeId() {
        return this.typeId;
    }

    @JsonProperty(value="typeId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTypeId(@Nonnull UUID typeId) {
        this.typeId = typeId;
    }

    public SetAssetRelationsRequest relatedAssetIds(@Nonnull List<UUID> relatedAssetIds) {
        this.relatedAssetIds = relatedAssetIds;
        return this;
    }

    public SetAssetRelationsRequest addRelatedAssetIdsItem(UUID relatedAssetIdsItem) {
        if (this.relatedAssetIds == null) {
            this.relatedAssetIds = new ArrayList<UUID>();
        }
        this.relatedAssetIds.add(relatedAssetIdsItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="relatedAssetIds")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<UUID> getRelatedAssetIds() {
        return this.relatedAssetIds;
    }

    @JsonProperty(value="relatedAssetIds")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRelatedAssetIds(@Nonnull List<UUID> relatedAssetIds) {
        this.relatedAssetIds = relatedAssetIds;
    }

    public SetAssetRelationsRequest relationDirection(@Nonnull RelationDirectionEnum relationDirection) {
        this.relationDirection = relationDirection;
        return this;
    }

    @Nonnull
    @JsonProperty(value="relationDirection")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public RelationDirectionEnum getRelationDirection() {
        return this.relationDirection;
    }

    @JsonProperty(value="relationDirection")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRelationDirection(@Nonnull RelationDirectionEnum relationDirection) {
        this.relationDirection = relationDirection;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetAssetRelationsRequest setAssetRelationsRequest = (SetAssetRelationsRequest)o;
        return Objects.equals(this.typeId, setAssetRelationsRequest.typeId) && Objects.equals(this.relatedAssetIds, setAssetRelationsRequest.relatedAssetIds) && Objects.equals((Object)this.relationDirection, (Object)setAssetRelationsRequest.relationDirection);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.typeId, this.relatedAssetIds, this.relationDirection});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SetAssetRelationsRequest {\n");
        sb.append("    typeId: ").append(this.toIndentedString(this.typeId)).append("\n");
        sb.append("    relatedAssetIds: ").append(this.toIndentedString(this.relatedAssetIds)).append("\n");
        sb.append("    relationDirection: ").append(this.toIndentedString((Object)this.relationDirection)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum RelationDirectionEnum {
        TO_TARGET(String.valueOf("TO_TARGET")),
        TO_SOURCE(String.valueOf("TO_SOURCE"));

        private String value;

        private RelationDirectionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RelationDirectionEnum fromValue(String value) {
            for (RelationDirectionEnum b : RelationDirectionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

