/*
 * Decompiled with CFR 0.152.
 */
package com.collibra.core.rest.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

@JsonPropertyOrder(value={"taskIds", "formProperties", "taskFormProperties", "guestUserId"})
public class CompleteWorkflowTasksRequest {
    public static final String JSON_PROPERTY_TASK_IDS = "taskIds";
    @Nonnull
    private List<UUID> taskIds = new ArrayList<UUID>();
    public static final String JSON_PROPERTY_FORM_PROPERTIES = "formProperties";
    @Nullable
    private Map<String, String> formProperties = new HashMap<String, String>();
    public static final String JSON_PROPERTY_TASK_FORM_PROPERTIES = "taskFormProperties";
    @Nullable
    private Map<String, Object> taskFormProperties = new HashMap<String, Object>();
    public static final String JSON_PROPERTY_GUEST_USER_ID = "guestUserId";
    @Nullable
    private UUID guestUserId;

    public CompleteWorkflowTasksRequest taskIds(@Nonnull List<UUID> taskIds) {
        this.taskIds = taskIds;
        return this;
    }

    public CompleteWorkflowTasksRequest addTaskIdsItem(UUID taskIdsItem) {
        if (this.taskIds == null) {
            this.taskIds = new ArrayList<UUID>();
        }
        this.taskIds.add(taskIdsItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="taskIds")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<UUID> getTaskIds() {
        return this.taskIds;
    }

    @JsonProperty(value="taskIds")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTaskIds(@Nonnull List<UUID> taskIds) {
        this.taskIds = taskIds;
    }

    public CompleteWorkflowTasksRequest formProperties(@Nullable Map<String, String> formProperties) {
        this.formProperties = formProperties;
        return this;
    }

    public CompleteWorkflowTasksRequest putFormPropertiesItem(String key, String formPropertiesItem) {
        if (this.formProperties == null) {
            this.formProperties = new HashMap<String, String>();
        }
        this.formProperties.put(key, formPropertiesItem);
        return this;
    }

    @Deprecated
    @Nullable
    @JsonProperty(value="formProperties")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getFormProperties() {
        return this.formProperties;
    }

    @JsonProperty(value="formProperties")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFormProperties(@Nullable Map<String, String> formProperties) {
        this.formProperties = formProperties;
    }

    public CompleteWorkflowTasksRequest taskFormProperties(@Nullable Map<String, Object> taskFormProperties) {
        this.taskFormProperties = taskFormProperties;
        return this;
    }

    public CompleteWorkflowTasksRequest putTaskFormPropertiesItem(String key, Object taskFormPropertiesItem) {
        if (this.taskFormProperties == null) {
            this.taskFormProperties = new HashMap<String, Object>();
        }
        this.taskFormProperties.put(key, taskFormPropertiesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="taskFormProperties")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getTaskFormProperties() {
        return this.taskFormProperties;
    }

    @JsonProperty(value="taskFormProperties")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTaskFormProperties(@Nullable Map<String, Object> taskFormProperties) {
        this.taskFormProperties = taskFormProperties;
    }

    public CompleteWorkflowTasksRequest guestUserId(@Nullable UUID guestUserId) {
        this.guestUserId = guestUserId;
        return this;
    }

    @Deprecated
    @Nullable
    @JsonProperty(value="guestUserId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getGuestUserId() {
        return this.guestUserId;
    }

    @JsonProperty(value="guestUserId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGuestUserId(@Nullable UUID guestUserId) {
        this.guestUserId = guestUserId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompleteWorkflowTasksRequest completeWorkflowTasksRequest = (CompleteWorkflowTasksRequest)o;
        return Objects.equals(this.taskIds, completeWorkflowTasksRequest.taskIds) && Objects.equals(this.formProperties, completeWorkflowTasksRequest.formProperties) && Objects.equals(this.taskFormProperties, completeWorkflowTasksRequest.taskFormProperties) && Objects.equals(this.guestUserId, completeWorkflowTasksRequest.guestUserId);
    }

    public int hashCode() {
        return Objects.hash(this.taskIds, this.formProperties, this.taskFormProperties, this.guestUserId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CompleteWorkflowTasksRequest {\n");
        sb.append("    taskIds: ").append(this.toIndentedString(this.taskIds)).append("\n");
        sb.append("    formProperties: ").append(this.toIndentedString(this.formProperties)).append("\n");
        sb.append("    taskFormProperties: ").append(this.toIndentedString(this.taskFormProperties)).append("\n");
        sb.append("    guestUserId: ").append(this.toIndentedString(this.guestUserId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

