/*
 * Decompiled with CFR 0.152.
 */
package com.collibra.core.rest.client.model;

import com.collibra.core.rest.client.model.ApplicationVersionImpl;
import com.collibra.core.rest.client.model.SolutionInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"solutions", "buildNumber", "baseUrl", "version"})
public class ApplicationInfo {
    public static final String JSON_PROPERTY_SOLUTIONS = "solutions";
    @Nullable
    private List<SolutionInfo> solutions = new ArrayList<SolutionInfo>();
    public static final String JSON_PROPERTY_BUILD_NUMBER = "buildNumber";
    @Nullable
    private String buildNumber;
    public static final String JSON_PROPERTY_BASE_URL = "baseUrl";
    @Nullable
    private String baseUrl;
    public static final String JSON_PROPERTY_VERSION = "version";
    @Nullable
    private ApplicationVersionImpl version;

    public ApplicationInfo solutions(@Nullable List<SolutionInfo> solutions) {
        this.solutions = solutions;
        return this;
    }

    public ApplicationInfo addSolutionsItem(SolutionInfo solutionsItem) {
        if (this.solutions == null) {
            this.solutions = new ArrayList<SolutionInfo>();
        }
        this.solutions.add(solutionsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="solutions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SolutionInfo> getSolutions() {
        return this.solutions;
    }

    @JsonProperty(value="solutions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSolutions(@Nullable List<SolutionInfo> solutions) {
        this.solutions = solutions;
    }

    public ApplicationInfo buildNumber(@Nullable String buildNumber) {
        this.buildNumber = buildNumber;
        return this;
    }

    @Nullable
    @JsonProperty(value="buildNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBuildNumber() {
        return this.buildNumber;
    }

    @JsonProperty(value="buildNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBuildNumber(@Nullable String buildNumber) {
        this.buildNumber = buildNumber;
    }

    public ApplicationInfo baseUrl(@Nullable String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    @Nullable
    @JsonProperty(value="baseUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @JsonProperty(value="baseUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBaseUrl(@Nullable String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public ApplicationInfo version(@Nullable ApplicationVersionImpl version) {
        this.version = version;
        return this;
    }

    @Nullable
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApplicationVersionImpl getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVersion(@Nullable ApplicationVersionImpl version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationInfo applicationInfo = (ApplicationInfo)o;
        return Objects.equals(this.solutions, applicationInfo.solutions) && Objects.equals(this.buildNumber, applicationInfo.buildNumber) && Objects.equals(this.baseUrl, applicationInfo.baseUrl) && Objects.equals(this.version, applicationInfo.version);
    }

    public int hashCode() {
        return Objects.hash(this.solutions, this.buildNumber, this.baseUrl, this.version);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationInfo {\n");
        sb.append("    solutions: ").append(this.toIndentedString(this.solutions)).append("\n");
        sb.append("    buildNumber: ").append(this.toIndentedString(this.buildNumber)).append("\n");
        sb.append("    baseUrl: ").append(this.toIndentedString(this.baseUrl)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

