/*
 * Decompiled with CFR 0.152.
 */
package com.collibra.core.rest.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

@JsonPropertyOrder(value={"id", "name", "global", "description", "permissions"})
public class AddRoleRequest {
    public static final String JSON_PROPERTY_ID = "id";
    @Nullable
    private UUID id;
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_GLOBAL = "global";
    @Nullable
    private Boolean global;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    @Nullable
    private String description;
    public static final String JSON_PROPERTY_PERMISSIONS = "permissions";
    @Nullable
    private List<PermissionsEnum> permissions = new ArrayList<PermissionsEnum>();

    public AddRoleRequest id(@Nullable UUID id) {
        this.id = id;
        return this;
    }

    @Nullable
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(@Nullable UUID id) {
        this.id = id;
    }

    public AddRoleRequest name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public AddRoleRequest global(@Nullable Boolean global) {
        this.global = global;
        return this;
    }

    @Nullable
    @JsonProperty(value="global")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getGlobal() {
        return this.global;
    }

    @JsonProperty(value="global")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGlobal(@Nullable Boolean global) {
        this.global = global;
    }

    public AddRoleRequest description(@Nullable String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public AddRoleRequest permissions(@Nullable List<PermissionsEnum> permissions) {
        this.permissions = permissions;
        return this;
    }

    public AddRoleRequest addPermissionsItem(PermissionsEnum permissionsItem) {
        if (this.permissions == null) {
            this.permissions = new ArrayList<PermissionsEnum>();
        }
        this.permissions.add(permissionsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="permissions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<PermissionsEnum> getPermissions() {
        return this.permissions;
    }

    @JsonProperty(value="permissions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPermissions(@Nullable List<PermissionsEnum> permissions) {
        this.permissions = permissions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddRoleRequest addRoleRequest = (AddRoleRequest)o;
        return Objects.equals(this.id, addRoleRequest.id) && Objects.equals(this.name, addRoleRequest.name) && Objects.equals(this.global, addRoleRequest.global) && Objects.equals(this.description, addRoleRequest.description) && Objects.equals(this.permissions, addRoleRequest.permissions);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.global, this.description, this.permissions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AddRoleRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    global: ").append(this.toIndentedString(this.global)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    permissions: ").append(this.toIndentedString(this.permissions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PermissionsEnum {
        EDGE(String.valueOf("EDGE")),
        EDGE_SITE_CONNECT(String.valueOf("EDGE_SITE_CONNECT")),
        EDGE_SITE_MANAGE(String.valueOf("EDGE_SITE_MANAGE")),
        EDGE_SITE_ADMINISTER(String.valueOf("EDGE_SITE_ADMINISTER")),
        EDGE_INTEGRATION_CAPABILITY_MANAGE(String.valueOf("EDGE_INTEGRATION_CAPABILITY_MANAGE")),
        EDGE_VIEW_CONNECTIONS_AND_CAPABILITIES(String.valueOf("EDGE_VIEW_CONNECTIONS_AND_CAPABILITIES")),
        EDGE_VIEW_LOGS(String.valueOf("EDGE_VIEW_LOGS")),
        ASSET_GRID_ADMINISTRATION(String.valueOf("ASSET_GRID_ADMINISTRATION")),
        ATTACHMENT_ADD(String.valueOf("ATTACHMENT_ADD")),
        ATTACHMENT_CHANGE(String.valueOf("ATTACHMENT_CHANGE")),
        ATTACHMENT_REMOVE(String.valueOf("ATTACHMENT_REMOVE")),
        COMMENT_ADD(String.valueOf("COMMENT_ADD")),
        COMMENT_CHANGE(String.valueOf("COMMENT_CHANGE")),
        COMMENT_REMOVE(String.valueOf("COMMENT_REMOVE")),
        RATING_ADD(String.valueOf("RATING_ADD")),
        RATING_CHANGE(String.valueOf("RATING_CHANGE")),
        RATING_REMOVE(String.valueOf("RATING_REMOVE")),
        RESOURCE_EXPORT(String.valueOf("RESOURCE_EXPORT")),
        RESOURCE_IMPORT(String.valueOf("RESOURCE_IMPORT")),
        COMMUNITY_ADD(String.valueOf("COMMUNITY_ADD")),
        COMMUNITY_CHANGE(String.valueOf("COMMUNITY_CHANGE")),
        COMMUNITY_REMOVE(String.valueOf("COMMUNITY_REMOVE")),
        COMMUNITY_CONFIGURE_EXTERNAL_SYSTEM(String.valueOf("COMMUNITY_CONFIGURE_EXTERNAL_SYSTEM")),
        COMMUNITY_RESPONSIBILITY_ADD(String.valueOf("COMMUNITY_RESPONSIBILITY_ADD")),
        COMMUNITY_RESPONSIBILITY_CHANGE(String.valueOf("COMMUNITY_RESPONSIBILITY_CHANGE")),
        COMMUNITY_RESPONSIBILITY_REMOVE(String.valueOf("COMMUNITY_RESPONSIBILITY_REMOVE")),
        DOMAIN_ADD(String.valueOf("DOMAIN_ADD")),
        DOMAIN_CHANGE(String.valueOf("DOMAIN_CHANGE")),
        DOMAIN_REMOVE(String.valueOf("DOMAIN_REMOVE")),
        DOMAIN_RESPONSIBILITY_ADD(String.valueOf("DOMAIN_RESPONSIBILITY_ADD")),
        DOMAIN_RESPONSIBILITY_CHANGE(String.valueOf("DOMAIN_RESPONSIBILITY_CHANGE")),
        DOMAIN_RESPONSIBILITY_REMOVE(String.valueOf("DOMAIN_RESPONSIBILITY_REMOVE")),
        WORKFLOW_MANAGE(String.valueOf("WORKFLOW_MANAGE")),
        WORKFLOW_DESIGNER_ACCESS(String.valueOf("WORKFLOW_DESIGNER_ACCESS")),
        ASSET_ADD(String.valueOf("ASSET_ADD")),
        ASSET_CHANGE(String.valueOf("ASSET_CHANGE")),
        ASSET_REMOVE(String.valueOf("ASSET_REMOVE")),
        ASSET_STATUS_CHANGE(String.valueOf("ASSET_STATUS_CHANGE")),
        ASSET_TYPE_CHANGE(String.valueOf("ASSET_TYPE_CHANGE")),
        ASSET_TAG_CHANGE(String.valueOf("ASSET_TAG_CHANGE")),
        ASSET_ATTRIBUTE_ADD(String.valueOf("ASSET_ATTRIBUTE_ADD")),
        ASSET_ATTRIBUTE_CHANGE(String.valueOf("ASSET_ATTRIBUTE_CHANGE")),
        ASSET_ATTRIBUTE_REMOVE(String.valueOf("ASSET_ATTRIBUTE_REMOVE")),
        ASSET_RESPONSIBILITY_ADD(String.valueOf("ASSET_RESPONSIBILITY_ADD")),
        ASSET_RESPONSIBILITY_CHANGE(String.valueOf("ASSET_RESPONSIBILITY_CHANGE")),
        ASSET_RESPONSIBILITY_REMOVE(String.valueOf("ASSET_RESPONSIBILITY_REMOVE")),
        ASSET_DECISION_RECORD(String.valueOf("ASSET_DECISION_RECORD")),
        VIEW_PERMISSIONS_CHANGE(String.valueOf("VIEW_PERMISSIONS_CHANGE")),
        BUSINESS_SEMANTICS_GLOSSARY(String.valueOf("BUSINESS_SEMANTICS_GLOSSARY")),
        REFERENCE_DATA_MANAGER(String.valueOf("REFERENCE_DATA_MANAGER")),
        DATA_STEWARDSHIP_MANAGER(String.valueOf("DATA_STEWARDSHIP_MANAGER")),
        SYSTEM_ADMINISTRATION(String.valueOf("SYSTEM_ADMINISTRATION")),
        USER_ADMINISTRATION(String.valueOf("USER_ADMINISTRATION")),
        WORKFLOW_ADMINISTRATION(String.valueOf("WORKFLOW_ADMINISTRATION")),
        DATA_HELPDESK(String.valueOf("DATA_HELPDESK")),
        POLICY_MANAGER(String.valueOf("POLICY_MANAGER")),
        DATA_DICTIONARY(String.valueOf("DATA_DICTIONARY")),
        CATALOG(String.valueOf("CATALOG")),
        WORKFLOW_MANAGE_ALL(String.valueOf("WORKFLOW_MANAGE_ALL")),
        WORKFLOW_MESSAGE_EVENTS_USE(String.valueOf("WORKFLOW_MESSAGE_EVENTS_USE")),
        VIEW_PERMISSIONS_VIEW_ALL(String.valueOf("VIEW_PERMISSIONS_VIEW_ALL")),
        VIEW_MANAGE(String.valueOf("VIEW_MANAGE")),
        VIEW_SHARE(String.valueOf("VIEW_SHARE")),
        VIEW_MANAGE_ALL(String.valueOf("VIEW_MANAGE_ALL")),
        DATA_CLASSES_READ(String.valueOf("DATA_CLASSES_READ")),
        DATA_CLASSES_ADD(String.valueOf("DATA_CLASSES_ADD")),
        DATA_CLASSES_EDIT(String.valueOf("DATA_CLASSES_EDIT")),
        DATA_CLASSES_REMOVE(String.valueOf("DATA_CLASSES_REMOVE")),
        DATA_CLASSES_LIST_VALUES(String.valueOf("DATA_CLASSES_LIST_VALUES")),
        ADVANCED_DATA_TYPE_ADD(String.valueOf("ADVANCED_DATA_TYPE_ADD")),
        ADVANCED_DATA_TYPE_EDIT(String.valueOf("ADVANCED_DATA_TYPE_EDIT")),
        ADVANCED_DATA_TYPE_REMOVE(String.valueOf("ADVANCED_DATA_TYPE_REMOVE")),
        TAGS_VIEW(String.valueOf("TAGS_VIEW")),
        TAGS_MANAGE(String.valueOf("TAGS_MANAGE")),
        VALIDATION_EXECUTION(String.valueOf("VALIDATION_EXECUTION")),
        ACCESS_DATA(String.valueOf("ACCESS_DATA")),
        VIEW_SAMPLES(String.valueOf("VIEW_SAMPLES")),
        RELATION_TYPE_ADD(String.valueOf("RELATION_TYPE_ADD")),
        RELATION_TYPE_REMOVE(String.valueOf("RELATION_TYPE_REMOVE")),
        RELATION_TYPE_CHANGE(String.valueOf("RELATION_TYPE_CHANGE")),
        REGISTER_PROFILING_INFORMATION(String.valueOf("REGISTER_PROFILING_INFORMATION")),
        REPORTING_DOWNLOAD_INSIGHTS_DATA(String.valueOf("REPORTING_DOWNLOAD_INSIGHTS_DATA")),
        REPORTING_VIEW_INSIGHTS_REPORTS(String.valueOf("REPORTING_VIEW_INSIGHTS_REPORTS")),
        INSIGHTS_VIEW(String.valueOf("INSIGHTS_VIEW")),
        INSIGHTS_SUMMARY(String.valueOf("INSIGHTS_SUMMARY")),
        TECHNICAL_LINEAGE(String.valueOf("TECHNICAL_LINEAGE")),
        LOGS_VIEW(String.valueOf("LOGS_VIEW")),
        RESOURCE_MANAGE_ALL(String.valueOf("RESOURCE_MANAGE_ALL")),
        CONFIGURATION_VIEW(String.valueOf("CONFIGURATION_VIEW")),
        CONFIGURATION_EDIT(String.valueOf("CONFIGURATION_EDIT")),
        BACKSTORE_VIEW(String.valueOf("BACKSTORE_VIEW")),
        BACKSTORE_EDIT(String.valueOf("BACKSTORE_EDIT")),
        ASSESSMENTS(String.valueOf("ASSESSMENTS")),
        ASSESSMENTS_ADMINISTRATION(String.valueOf("ASSESSMENTS_ADMINISTRATION")),
        ASSESSMENTS_CONDUCT_ASSESSMENTS(String.valueOf("ASSESSMENTS_CONDUCT_ASSESSMENTS")),
        ASSESSMENTS_MANAGE_TEMPLATES(String.valueOf("ASSESSMENTS_MANAGE_TEMPLATES")),
        METADATA_LAKE(String.valueOf("METADATA_LAKE")),
        PROTECT(String.valueOf("PROTECT")),
        PROTECT_EDIT(String.valueOf("PROTECT_EDIT")),
        PROTECT_ADMINISTRATION(String.valueOf("PROTECT_ADMINISTRATION")),
        AI_GOVERNANCE(String.valueOf("AI_GOVERNANCE")),
        PRIVACY(String.valueOf("PRIVACY")),
        DATA_MARKETPLACE(String.valueOf("DATA_MARKETPLACE")),
        CLASSIFY(String.valueOf("CLASSIFY")),
        WORKFLOW_START(String.valueOf("WORKFLOW_START")),
        WORKFLOW_PARTICIPATION(String.valueOf("WORKFLOW_PARTICIPATION")),
        DATA_NOTEBOOK(String.valueOf("DATA_NOTEBOOK")),
        DATA_NOTEBOOK_MANAGE_DATA_SOURCES(String.valueOf("DATA_NOTEBOOK_MANAGE_DATA_SOURCES")),
        DATA_NOTEBOOK_MANAGE_SETTINGS(String.valueOf("DATA_NOTEBOOK_MANAGE_SETTINGS")),
        DATA_NOTEBOOK_MANAGE_ALL_NOTEBOOKS(String.valueOf("DATA_NOTEBOOK_MANAGE_ALL_NOTEBOOKS")),
        VIEW_NOTEBOOK(String.valueOf("VIEW_NOTEBOOK")),
        GUIDED_STEWARDSHIP(String.valueOf("GUIDED_STEWARDSHIP")),
        DATA_QUALITY(String.valueOf("DATA_QUALITY"));

        private String value;

        private PermissionsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PermissionsEnum fromValue(String value) {
            for (PermissionsEnum b : PermissionsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

