/*
 * Decompiled with CFR 0.152.
 */
package com.collibra.core.rest.client.model;

import com.collibra.core.rest.client.model.ResourceReference;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.UUID;

@JsonPropertyOrder(value={"content", "baseResource", "parentId", "baseResourceId", "baseResourceType"})
public class AddCommentRequest {
    public static final String JSON_PROPERTY_CONTENT = "content";
    @Nonnull
    private String content;
    public static final String JSON_PROPERTY_BASE_RESOURCE = "baseResource";
    @Nonnull
    private ResourceReference baseResource;
    public static final String JSON_PROPERTY_PARENT_ID = "parentId";
    @Nullable
    private UUID parentId;
    public static final String JSON_PROPERTY_BASE_RESOURCE_ID = "baseResourceId";
    @Nullable
    private UUID baseResourceId;
    public static final String JSON_PROPERTY_BASE_RESOURCE_TYPE = "baseResourceType";
    @Nullable
    private BaseResourceTypeEnum baseResourceType;

    public AddCommentRequest content(@Nonnull String content) {
        this.content = content;
        return this;
    }

    @Nonnull
    @JsonProperty(value="content")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getContent() {
        return this.content;
    }

    @JsonProperty(value="content")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setContent(@Nonnull String content) {
        this.content = content;
    }

    public AddCommentRequest baseResource(@Nonnull ResourceReference baseResource) {
        this.baseResource = baseResource;
        return this;
    }

    @Nonnull
    @JsonProperty(value="baseResource")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ResourceReference getBaseResource() {
        return this.baseResource;
    }

    @JsonProperty(value="baseResource")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBaseResource(@Nonnull ResourceReference baseResource) {
        this.baseResource = baseResource;
    }

    public AddCommentRequest parentId(@Nullable UUID parentId) {
        this.parentId = parentId;
        return this;
    }

    @Nullable
    @JsonProperty(value="parentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getParentId() {
        return this.parentId;
    }

    @JsonProperty(value="parentId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setParentId(@Nullable UUID parentId) {
        this.parentId = parentId;
    }

    public AddCommentRequest baseResourceId(@Nullable UUID baseResourceId) {
        this.baseResourceId = baseResourceId;
        return this;
    }

    @Nullable
    @JsonProperty(value="baseResourceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getBaseResourceId() {
        return this.baseResourceId;
    }

    @JsonProperty(value="baseResourceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBaseResourceId(@Nullable UUID baseResourceId) {
        this.baseResourceId = baseResourceId;
    }

    public AddCommentRequest baseResourceType(@Nullable BaseResourceTypeEnum baseResourceType) {
        this.baseResourceType = baseResourceType;
        return this;
    }

    @Nullable
    @JsonProperty(value="baseResourceType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BaseResourceTypeEnum getBaseResourceType() {
        return this.baseResourceType;
    }

    @JsonProperty(value="baseResourceType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBaseResourceType(@Nullable BaseResourceTypeEnum baseResourceType) {
        this.baseResourceType = baseResourceType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddCommentRequest addCommentRequest = (AddCommentRequest)o;
        return Objects.equals(this.content, addCommentRequest.content) && Objects.equals(this.baseResource, addCommentRequest.baseResource) && Objects.equals(this.parentId, addCommentRequest.parentId) && Objects.equals(this.baseResourceId, addCommentRequest.baseResourceId) && Objects.equals((Object)this.baseResourceType, (Object)addCommentRequest.baseResourceType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.content, this.baseResource, this.parentId, this.baseResourceId, this.baseResourceType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AddCommentRequest {\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    baseResource: ").append(this.toIndentedString(this.baseResource)).append("\n");
        sb.append("    parentId: ").append(this.toIndentedString(this.parentId)).append("\n");
        sb.append("    baseResourceId: ").append(this.toIndentedString(this.baseResourceId)).append("\n");
        sb.append("    baseResourceType: ").append(this.toIndentedString((Object)this.baseResourceType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum BaseResourceTypeEnum {
        VIEW(String.valueOf("View")),
        ASSET(String.valueOf("Asset")),
        COMMUNITY(String.valueOf("Community")),
        DOMAIN(String.valueOf("Domain")),
        ASSET_TYPE(String.valueOf("AssetType")),
        DOMAIN_TYPE(String.valueOf("DomainType")),
        STATUS(String.valueOf("Status")),
        USER(String.valueOf("User")),
        CLASSIFICATION_MATCH(String.valueOf("ClassificationMatch")),
        USER_GROUP(String.valueOf("UserGroup")),
        ATTRIBUTE(String.valueOf("Attribute")),
        STRING_ATTRIBUTE(String.valueOf("StringAttribute")),
        SCRIPT_ATTRIBUTE(String.valueOf("ScriptAttribute")),
        BOOLEAN_ATTRIBUTE(String.valueOf("BooleanAttribute")),
        DATE_ATTRIBUTE(String.valueOf("DateAttribute")),
        NUMERIC_ATTRIBUTE(String.valueOf("NumericAttribute")),
        SINGLE_VALUE_LIST_ATTRIBUTE(String.valueOf("SingleValueListAttribute")),
        MULTI_VALUE_LIST_ATTRIBUTE(String.valueOf("MultiValueListAttribute")),
        COMMENT(String.valueOf("Comment")),
        ATTACHMENT(String.valueOf("Attachment")),
        RESPONSIBILITY(String.valueOf("Responsibility")),
        WORKFLOW(String.valueOf("Workflow")),
        JOB(String.valueOf("Job")),
        RELATION(String.valueOf("Relation")),
        RELATION_TYPE(String.valueOf("RelationType")),
        COMPLEX_RELATION(String.valueOf("ComplexRelation")),
        COMPLEX_RELATION_TYPE(String.valueOf("ComplexRelationType")),
        ARTICULATION_RULE(String.valueOf("ArticulationRule")),
        ASSIGNMENT(String.valueOf("Assignment")),
        SCOPE(String.valueOf("Scope")),
        RELATION_TRACE(String.valueOf("RelationTrace")),
        VALIDATION_RULE(String.valueOf("ValidationRule")),
        DATA_QUALITY_RULE(String.valueOf("DataQualityRule")),
        DATA_QUALITY_METRIC(String.valueOf("DataQualityMetric")),
        ADDRESS(String.valueOf("Address")),
        INSTANT_MESSAGING_ACCOUNT(String.valueOf("InstantMessagingAccount")),
        EMAIL(String.valueOf("Email")),
        PHONE_NUMBER(String.valueOf("PhoneNumber")),
        WEBSITE(String.valueOf("Website")),
        ACTIVITY(String.valueOf("Activity")),
        FORM_PROPERTY(String.valueOf("FormProperty")),
        WORKFLOW_TASK(String.valueOf("WorkflowTask")),
        ACTIVITY_CHANGE(String.valueOf("ActivityChange")),
        WORKFLOW_INSTANCE(String.valueOf("WorkflowInstance")),
        ROLE(String.valueOf("Role")),
        ATTRIBUTE_TYPE(String.valueOf("AttributeType")),
        BOOLEAN_ATTRIBUTE_TYPE(String.valueOf("BooleanAttributeType")),
        DATE_ATTRIBUTE_TYPE(String.valueOf("DateAttributeType")),
        DATE_TIME_ATTRIBUTE_TYPE(String.valueOf("DateTimeAttributeType")),
        MULTI_VALUE_LIST_ATTRIBUTE_TYPE(String.valueOf("MultiValueListAttributeType")),
        NUMERIC_ATTRIBUTE_TYPE(String.valueOf("NumericAttributeType")),
        SCRIPT_ATTRIBUTE_TYPE(String.valueOf("ScriptAttributeType")),
        SINGLE_VALUE_LIST_ATTRIBUTE_TYPE(String.valueOf("SingleValueListAttributeType")),
        STRING_ATTRIBUTE_TYPE(String.valueOf("StringAttributeType")),
        VIEW_SHARING_RULE(String.valueOf("ViewSharingRule")),
        VIEW_ASSIGNMENT_RULE(String.valueOf("ViewAssignmentRule")),
        JDBC_DRIVER_FILE(String.valueOf("JdbcDriverFile")),
        JDBC_DRIVER(String.valueOf("JdbcDriver")),
        JDBC_INGESTION_PROPERTIES(String.valueOf("JdbcIngestionProperties")),
        CSV_INGESTION_PROPERTIES(String.valueOf("CsvIngestionProperties")),
        EXCEL_INGESTION_PROPERTIES(String.valueOf("ExcelIngestionProperties")),
        CONNECTION_STRING_PARAMETER(String.valueOf("ConnectionStringParameter")),
        ASSIGNED_CHARACTERISTIC_TYPE(String.valueOf("AssignedCharacteristicType")),
        NOTIFICATION(String.valueOf("Notification")),
        TAG(String.valueOf("Tag")),
        COMPLEX_RELATION_LEG_TYPE(String.valueOf("ComplexRelationLegType")),
        COMPLEX_RELATION_ATTRIBUTE_TYPE(String.valueOf("ComplexRelationAttributeType")),
        COMPLEX_RELATION_LEG(String.valueOf("ComplexRelationLeg")),
        BASE_DATA_TYPE(String.valueOf("BaseDataType")),
        ADVANCED_DATA_TYPE(String.valueOf("AdvancedDataType")),
        DIAGRAM_PICTURE(String.valueOf("DiagramPicture")),
        DIAGRAM_PICTURE_SHARING_RULE(String.valueOf("DiagramPictureSharingRule")),
        DIAGRAM_PICTURE_ASSIGNMENT_RULE(String.valueOf("DiagramPictureAssignmentRule")),
        RATING(String.valueOf("Rating")),
        CLASSIFICATION(String.valueOf("Classification")),
        PHYSICAL_DATA_CONNECTOR(String.valueOf("PhysicalDataConnector")),
        CONTEXT(String.valueOf("Context"));

        private String value;

        private BaseResourceTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static BaseResourceTypeEnum fromValue(String value) {
            for (BaseResourceTypeEnum b : BaseResourceTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

