/*
 * Decompiled with CFR 0.152.
 */
package com.collibra.core.rest.client.api;

import com.collibra.core.rest.client.invoker.ApiClient;
import com.collibra.core.rest.client.invoker.EncodingUtils;
import com.collibra.core.rest.client.model.AddUserRequest;
import com.collibra.core.rest.client.model.AddUserToUserGroupsRequest;
import com.collibra.core.rest.client.model.ApiResponse;
import com.collibra.core.rest.client.model.ChangeUserAvatarRequest;
import com.collibra.core.rest.client.model.ChangeUserRequest;
import com.collibra.core.rest.client.model.RemoveUserFromUserGroupsRequest;
import com.collibra.core.rest.client.model.SetUserGroupsForUserRequest;
import com.collibra.core.rest.client.model.User;
import com.collibra.core.rest.client.model.UserGroupImpl;
import com.collibra.core.rest.client.model.UserPagedResponse;
import com.collibra.core.rest.client.model.UserPermissions;
import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public interface UsersApi
extends ApiClient.Api {
    @RequestLine(value="POST /users")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public User addUser(AddUserRequest var1);

    @RequestLine(value="POST /users")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<User> addUserWithHttpInfo(AddUserRequest var1);

    @RequestLine(value="POST /users/{userId}/userGroups")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public List<UserGroupImpl> addUserGroupsForUser(@Param(value="userId") UUID var1, AddUserToUserGroupsRequest var2);

    @RequestLine(value="POST /users/{userId}/userGroups")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<List<UserGroupImpl>> addUserGroupsForUserWithHttpInfo(@Param(value="userId") UUID var1, AddUserToUserGroupsRequest var2);

    @RequestLine(value="POST /users/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public List<User> addUsers(List<AddUserRequest> var1);

    @RequestLine(value="POST /users/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<List<User>> addUsersWithHttpInfo(List<AddUserRequest> var1);

    @RequestLine(value="PATCH /users/{userId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public User changeUser(@Param(value="userId") UUID var1, ChangeUserRequest var2);

    @RequestLine(value="PATCH /users/{userId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<User> changeUserWithHttpInfo(@Param(value="userId") UUID var1, ChangeUserRequest var2);

    @RequestLine(value="PATCH /users/{userId}/avatar")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public User changeUserAvatar(@Param(value="userId") UUID var1, ChangeUserAvatarRequest var2);

    @RequestLine(value="PATCH /users/{userId}/avatar")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<User> changeUserAvatarWithHttpInfo(@Param(value="userId") UUID var1, ChangeUserAvatarRequest var2);

    @RequestLine(value="DELETE /users/{userId}")
    @Headers(value={"Accept: application/json"})
    public void deleteUser(@Param(value="userId") UUID var1);

    @RequestLine(value="DELETE /users/{userId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteUserWithHttpInfo(@Param(value="userId") UUID var1);

    @RequestLine(value="DELETE /users/{userId}/avatar")
    @Headers(value={"Accept: application/json"})
    public void deleteUserAvatar(@Param(value="userId") UUID var1);

    @RequestLine(value="DELETE /users/{userId}/avatar")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteUserAvatarWithHttpInfo(@Param(value="userId") UUID var1);

    @RequestLine(value="GET /users?offset={offset}&limit={limit}&countLimit={countLimit}&userId={userId}&name={name}&nameSearchFields={nameSearchFields}&groupId={groupId}&onlyLoggedIn={onlyLoggedIn}&includeDisabled={includeDisabled}&sortOrder={sortOrder}&sortField={sortField}")
    @Headers(value={"Accept: application/json"})
    public UserPagedResponse findUsers(@Param(value="offset") Integer var1, @Param(value="limit") Integer var2, @Param(value="countLimit") Integer var3, @Param(value="userId") List<String> var4, @Param(value="name") String var5, @Param(value="nameSearchFields") Set<String> var6, @Param(value="groupId") UUID var7, @Param(value="onlyLoggedIn") Boolean var8, @Param(value="includeDisabled") Boolean var9, @Param(value="sortOrder") String var10, @Param(value="sortField") String var11);

    @RequestLine(value="GET /users?offset={offset}&limit={limit}&countLimit={countLimit}&userId={userId}&name={name}&nameSearchFields={nameSearchFields}&groupId={groupId}&onlyLoggedIn={onlyLoggedIn}&includeDisabled={includeDisabled}&sortOrder={sortOrder}&sortField={sortField}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<UserPagedResponse> findUsersWithHttpInfo(@Param(value="offset") Integer var1, @Param(value="limit") Integer var2, @Param(value="countLimit") Integer var3, @Param(value="userId") List<String> var4, @Param(value="name") String var5, @Param(value="nameSearchFields") Set<String> var6, @Param(value="groupId") UUID var7, @Param(value="onlyLoggedIn") Boolean var8, @Param(value="includeDisabled") Boolean var9, @Param(value="sortOrder") String var10, @Param(value="sortField") String var11);

    @RequestLine(value="GET /users?offset={offset}&limit={limit}&countLimit={countLimit}&userId={userId}&name={name}&nameSearchFields={nameSearchFields}&groupId={groupId}&onlyLoggedIn={onlyLoggedIn}&includeDisabled={includeDisabled}&sortOrder={sortOrder}&sortField={sortField}")
    @Headers(value={"Accept: application/json"})
    public UserPagedResponse findUsers(@QueryMap(encoded=true) FindUsersQueryParams var1);

    @RequestLine(value="GET /users?offset={offset}&limit={limit}&countLimit={countLimit}&userId={userId}&name={name}&nameSearchFields={nameSearchFields}&groupId={groupId}&onlyLoggedIn={onlyLoggedIn}&includeDisabled={includeDisabled}&sortOrder={sortOrder}&sortField={sortField}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<UserPagedResponse> findUsersWithHttpInfo(@QueryMap(encoded=true) FindUsersQueryParams var1);

    @RequestLine(value="GET /users/{userId}/avatar?width={width}&height={height}")
    @Headers(value={"Accept: application/json"})
    public File getAvatarFile(@Param(value="userId") UUID var1, @Param(value="width") Integer var2, @Param(value="height") Integer var3);

    @RequestLine(value="GET /users/{userId}/avatar?width={width}&height={height}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<File> getAvatarFileWithHttpInfo(@Param(value="userId") UUID var1, @Param(value="width") Integer var2, @Param(value="height") Integer var3);

    @RequestLine(value="GET /users/{userId}/avatar?width={width}&height={height}")
    @Headers(value={"Accept: application/json"})
    public File getAvatarFile(@Param(value="userId") UUID var1, @QueryMap(encoded=true) GetAvatarFileQueryParams var2);

    @RequestLine(value="GET /users/{userId}/avatar?width={width}&height={height}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<File> getAvatarFileWithHttpInfo(@Param(value="userId") UUID var1, @QueryMap(encoded=true) GetAvatarFileQueryParams var2);

    @RequestLine(value="GET /users/current")
    @Headers(value={"Accept: application/json"})
    public User getCurrentUser();

    @RequestLine(value="GET /users/current")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<User> getCurrentUserWithHttpInfo();

    @RequestLine(value="GET /users/current/permissions")
    @Headers(value={"Accept: application/json"})
    public UserPermissions getCurrentUserPermissions();

    @RequestLine(value="GET /users/current/permissions")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<UserPermissions> getCurrentUserPermissionsWithHttpInfo();

    @RequestLine(value="GET /users/{userId}")
    @Headers(value={"Accept: application/json"})
    public User getUser(@Param(value="userId") UUID var1);

    @RequestLine(value="GET /users/{userId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<User> getUserWithHttpInfo(@Param(value="userId") UUID var1);

    @Deprecated
    @RequestLine(value="GET /users/email/{emailAddress}")
    @Headers(value={"Accept: application/json"})
    public User getUserByEmailAddress(@Param(value="emailAddress") String var1);

    @Deprecated
    @RequestLine(value="GET /users/email/{emailAddress}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<User> getUserByEmailAddressWithHttpInfo(@Param(value="emailAddress") String var1);

    @Deprecated
    @RequestLine(value="GET /users/{userId}/licenseType")
    @Headers(value={"Accept: application/json"})
    public String getUserRequiredLicenseType(@Param(value="userId") UUID var1);

    @Deprecated
    @RequestLine(value="GET /users/{userId}/licenseType")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<String> getUserRequiredLicenseTypeWithHttpInfo(@Param(value="userId") UUID var1);

    @RequestLine(value="DELETE /users/{userId}/userGroups")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void removeUserFromUserGroups(@Param(value="userId") UUID var1, RemoveUserFromUserGroupsRequest var2);

    @RequestLine(value="DELETE /users/{userId}/userGroups")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Void> removeUserFromUserGroupsWithHttpInfo(@Param(value="userId") UUID var1, RemoveUserFromUserGroupsRequest var2);

    @RequestLine(value="PUT /users/{userId}/userGroups")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public User setUserGroupsForUser(@Param(value="userId") UUID var1, SetUserGroupsForUserRequest var2);

    @RequestLine(value="PUT /users/{userId}/userGroups")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<User> setUserGroupsForUserWithHttpInfo(@Param(value="userId") UUID var1, SetUserGroupsForUserRequest var2);

    public static class GetAvatarFileQueryParams
    extends HashMap<String, Object> {
        public GetAvatarFileQueryParams width(Integer value) {
            this.put("width", EncodingUtils.encode(value));
            return this;
        }

        public GetAvatarFileQueryParams height(Integer value) {
            this.put("height", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class FindUsersQueryParams
    extends HashMap<String, Object> {
        public FindUsersQueryParams offset(Integer value) {
            this.put("offset", EncodingUtils.encode(value));
            return this;
        }

        public FindUsersQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public FindUsersQueryParams countLimit(Integer value) {
            this.put("countLimit", EncodingUtils.encode(value));
            return this;
        }

        public FindUsersQueryParams userId(List<String> value) {
            this.put("userId", EncodingUtils.encodeCollection(value, "multi"));
            return this;
        }

        public FindUsersQueryParams name(String value) {
            this.put("name", EncodingUtils.encode(value));
            return this;
        }

        public FindUsersQueryParams nameSearchFields(Set<String> value) {
            this.put("nameSearchFields", EncodingUtils.encodeCollection(value, "multi"));
            return this;
        }

        public FindUsersQueryParams groupId(UUID value) {
            this.put("groupId", EncodingUtils.encode(value));
            return this;
        }

        public FindUsersQueryParams onlyLoggedIn(Boolean value) {
            this.put("onlyLoggedIn", EncodingUtils.encode(value));
            return this;
        }

        public FindUsersQueryParams includeDisabled(Boolean value) {
            this.put("includeDisabled", EncodingUtils.encode(value));
            return this;
        }

        public FindUsersQueryParams sortOrder(String value) {
            this.put("sortOrder", EncodingUtils.encode(value));
            return this;
        }

        public FindUsersQueryParams sortField(String value) {
            this.put("sortField", EncodingUtils.encode(value));
            return this;
        }
    }
}

