/*
 * Decompiled with CFR 0.152.
 */
package com.collibra.core.rest.client.api;

import com.collibra.core.rest.client.invoker.ApiClient;
import com.collibra.core.rest.client.invoker.EncodingUtils;
import com.collibra.core.rest.client.model.AddUserGroupRequest;
import com.collibra.core.rest.client.model.AddUsersToUserGroupRequest;
import com.collibra.core.rest.client.model.ApiResponse;
import com.collibra.core.rest.client.model.ChangeUserGroupRequest;
import com.collibra.core.rest.client.model.RemoveUsersFromUserGroupRequest;
import com.collibra.core.rest.client.model.User;
import com.collibra.core.rest.client.model.UserGroupImpl;
import com.collibra.core.rest.client.model.UserGroupPagedResponse;
import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

public interface UserGroupsApi
extends ApiClient.Api {
    @RequestLine(value="POST /userGroups")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public UserGroupImpl addUserGroup(AddUserGroupRequest var1);

    @RequestLine(value="POST /userGroups")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<UserGroupImpl> addUserGroupWithHttpInfo(AddUserGroupRequest var1);

    @RequestLine(value="POST /userGroups/{userGroupId}/users")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public List<User> addUsersToUserGroup(@Param(value="userGroupId") UUID var1, AddUsersToUserGroupRequest var2);

    @RequestLine(value="POST /userGroups/{userGroupId}/users")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<List<User>> addUsersToUserGroupWithHttpInfo(@Param(value="userGroupId") UUID var1, AddUsersToUserGroupRequest var2);

    @RequestLine(value="PATCH /userGroups/{userGroupId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public UserGroupImpl changeUserGroup(@Param(value="userGroupId") UUID var1, ChangeUserGroupRequest var2);

    @RequestLine(value="PATCH /userGroups/{userGroupId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<UserGroupImpl> changeUserGroupWithHttpInfo(@Param(value="userGroupId") UUID var1, ChangeUserGroupRequest var2);

    @RequestLine(value="GET /userGroups?offset={offset}&limit={limit}&countLimit={countLimit}&name={name}&nameMatchMode={nameMatchMode}&userId={userId}&includeEveryone={includeEveryone}")
    @Headers(value={"Accept: application/json"})
    public UserGroupPagedResponse findUserGroups(@Param(value="offset") Integer var1, @Param(value="limit") Integer var2, @Param(value="countLimit") Integer var3, @Param(value="name") String var4, @Param(value="nameMatchMode") String var5, @Param(value="userId") UUID var6, @Param(value="includeEveryone") Boolean var7);

    @RequestLine(value="GET /userGroups?offset={offset}&limit={limit}&countLimit={countLimit}&name={name}&nameMatchMode={nameMatchMode}&userId={userId}&includeEveryone={includeEveryone}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<UserGroupPagedResponse> findUserGroupsWithHttpInfo(@Param(value="offset") Integer var1, @Param(value="limit") Integer var2, @Param(value="countLimit") Integer var3, @Param(value="name") String var4, @Param(value="nameMatchMode") String var5, @Param(value="userId") UUID var6, @Param(value="includeEveryone") Boolean var7);

    @RequestLine(value="GET /userGroups?offset={offset}&limit={limit}&countLimit={countLimit}&name={name}&nameMatchMode={nameMatchMode}&userId={userId}&includeEveryone={includeEveryone}")
    @Headers(value={"Accept: application/json"})
    public UserGroupPagedResponse findUserGroups(@QueryMap(encoded=true) FindUserGroupsQueryParams var1);

    @RequestLine(value="GET /userGroups?offset={offset}&limit={limit}&countLimit={countLimit}&name={name}&nameMatchMode={nameMatchMode}&userId={userId}&includeEveryone={includeEveryone}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<UserGroupPagedResponse> findUserGroupsWithHttpInfo(@QueryMap(encoded=true) FindUserGroupsQueryParams var1);

    @RequestLine(value="GET /userGroups/{userGroupId}")
    @Headers(value={"Accept: application/json"})
    public UserGroupImpl getUserGroup(@Param(value="userGroupId") UUID var1);

    @RequestLine(value="GET /userGroups/{userGroupId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<UserGroupImpl> getUserGroupWithHttpInfo(@Param(value="userGroupId") UUID var1);

    @RequestLine(value="DELETE /userGroups/{userGroupId}")
    @Headers(value={"Accept: application/json"})
    public void removeUserGroup(@Param(value="userGroupId") UUID var1);

    @RequestLine(value="DELETE /userGroups/{userGroupId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> removeUserGroupWithHttpInfo(@Param(value="userGroupId") UUID var1);

    @RequestLine(value="DELETE /userGroups/{userGroupId}/users")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void removeUsersFromUserGroup(@Param(value="userGroupId") UUID var1, RemoveUsersFromUserGroupRequest var2);

    @RequestLine(value="DELETE /userGroups/{userGroupId}/users")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Void> removeUsersFromUserGroupWithHttpInfo(@Param(value="userGroupId") UUID var1, RemoveUsersFromUserGroupRequest var2);

    public static class FindUserGroupsQueryParams
    extends HashMap<String, Object> {
        public FindUserGroupsQueryParams offset(Integer value) {
            this.put("offset", EncodingUtils.encode(value));
            return this;
        }

        public FindUserGroupsQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public FindUserGroupsQueryParams countLimit(Integer value) {
            this.put("countLimit", EncodingUtils.encode(value));
            return this;
        }

        public FindUserGroupsQueryParams name(String value) {
            this.put("name", EncodingUtils.encode(value));
            return this;
        }

        public FindUserGroupsQueryParams nameMatchMode(String value) {
            this.put("nameMatchMode", EncodingUtils.encode(value));
            return this;
        }

        public FindUserGroupsQueryParams userId(UUID value) {
            this.put("userId", EncodingUtils.encode(value));
            return this;
        }

        public FindUserGroupsQueryParams includeEveryone(Boolean value) {
            this.put("includeEveryone", EncodingUtils.encode(value));
            return this;
        }
    }
}

