/*
 * Decompiled with CFR 0.152.
 */
package com.collibra.core.rest.client.api;

import com.collibra.core.rest.client.invoker.ApiClient;
import com.collibra.core.rest.client.invoker.EncodingUtils;
import com.collibra.core.rest.client.model.ApiResponse;
import com.collibra.core.rest.client.model.ChangeTagRequest;
import com.collibra.core.rest.client.model.MergeTagsRequest;
import com.collibra.core.rest.client.model.Tag;
import com.collibra.core.rest.client.model.TagPagedResponse;
import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

public interface TagsApi
extends ApiClient.Api {
    @RequestLine(value="PATCH /tags/{tagId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Tag changeTag(@Param(value="tagId") UUID var1, ChangeTagRequest var2);

    @RequestLine(value="PATCH /tags/{tagId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Tag> changeTagWithHttpInfo(@Param(value="tagId") UUID var1, ChangeTagRequest var2);

    @RequestLine(value="GET /tags/exists/{tagName}?encoded={encoded}")
    @Headers(value={"Accept: application/json"})
    public Boolean exists(@Param(value="tagName") String var1, @Param(value="encoded") Boolean var2);

    @RequestLine(value="GET /tags/exists/{tagName}?encoded={encoded}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Boolean> existsWithHttpInfo(@Param(value="tagName") String var1, @Param(value="encoded") Boolean var2);

    @RequestLine(value="GET /tags/exists/{tagName}?encoded={encoded}")
    @Headers(value={"Accept: application/json"})
    public Boolean exists(@Param(value="tagName") String var1, @QueryMap(encoded=true) ExistsQueryParams var2);

    @RequestLine(value="GET /tags/exists/{tagName}?encoded={encoded}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Boolean> existsWithHttpInfo(@Param(value="tagName") String var1, @QueryMap(encoded=true) ExistsQueryParams var2);

    @RequestLine(value="GET /tags?offset={offset}&limit={limit}&countLimit={countLimit}&name={name}&nameMatchMode={nameMatchMode}")
    @Headers(value={"Accept: application/json"})
    public TagPagedResponse findTags(@Param(value="offset") Integer var1, @Param(value="limit") Integer var2, @Param(value="countLimit") Integer var3, @Param(value="name") String var4, @Param(value="nameMatchMode") String var5);

    @RequestLine(value="GET /tags?offset={offset}&limit={limit}&countLimit={countLimit}&name={name}&nameMatchMode={nameMatchMode}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TagPagedResponse> findTagsWithHttpInfo(@Param(value="offset") Integer var1, @Param(value="limit") Integer var2, @Param(value="countLimit") Integer var3, @Param(value="name") String var4, @Param(value="nameMatchMode") String var5);

    @RequestLine(value="GET /tags?offset={offset}&limit={limit}&countLimit={countLimit}&name={name}&nameMatchMode={nameMatchMode}")
    @Headers(value={"Accept: application/json"})
    public TagPagedResponse findTags(@QueryMap(encoded=true) FindTagsQueryParams var1);

    @RequestLine(value="GET /tags?offset={offset}&limit={limit}&countLimit={countLimit}&name={name}&nameMatchMode={nameMatchMode}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<TagPagedResponse> findTagsWithHttpInfo(@QueryMap(encoded=true) FindTagsQueryParams var1);

    @RequestLine(value="GET /tags/{tagId}")
    @Headers(value={"Accept: application/json"})
    public Tag getTag(@Param(value="tagId") UUID var1);

    @RequestLine(value="GET /tags/{tagId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Tag> getTagWithHttpInfo(@Param(value="tagId") UUID var1);

    @RequestLine(value="GET /tags/asset/{assetId}")
    @Headers(value={"Accept: application/json"})
    public List<Tag> getTagsByAssetId(@Param(value="assetId") UUID var1);

    @RequestLine(value="GET /tags/asset/{assetId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<List<Tag>> getTagsByAssetIdWithHttpInfo(@Param(value="assetId") UUID var1);

    @RequestLine(value="POST /tags/merge")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void mergeTags(MergeTagsRequest var1);

    @RequestLine(value="POST /tags/merge")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Void> mergeTagsWithHttpInfo(MergeTagsRequest var1);

    @RequestLine(value="DELETE /tags/{tagId}")
    @Headers(value={"Accept: application/json"})
    public void removeTag(@Param(value="tagId") UUID var1);

    @RequestLine(value="DELETE /tags/{tagId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> removeTagWithHttpInfo(@Param(value="tagId") UUID var1);

    @RequestLine(value="DELETE /tags/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void removeTags(List<UUID> var1);

    @RequestLine(value="DELETE /tags/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Void> removeTagsWithHttpInfo(List<UUID> var1);

    public static class FindTagsQueryParams
    extends HashMap<String, Object> {
        public FindTagsQueryParams offset(Integer value) {
            this.put("offset", EncodingUtils.encode(value));
            return this;
        }

        public FindTagsQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public FindTagsQueryParams countLimit(Integer value) {
            this.put("countLimit", EncodingUtils.encode(value));
            return this;
        }

        public FindTagsQueryParams name(String value) {
            this.put("name", EncodingUtils.encode(value));
            return this;
        }

        public FindTagsQueryParams nameMatchMode(String value) {
            this.put("nameMatchMode", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ExistsQueryParams
    extends HashMap<String, Object> {
        public ExistsQueryParams encoded(Boolean value) {
            this.put("encoded", EncodingUtils.encode(value));
            return this;
        }
    }
}

