/*
 * Decompiled with CFR 0.152.
 */
package com.collibra.core.rest.client.api;

import com.collibra.core.rest.client.invoker.ApiClient;
import com.collibra.core.rest.client.invoker.EncodingUtils;
import com.collibra.core.rest.client.model.AddStatusRequest;
import com.collibra.core.rest.client.model.ApiResponse;
import com.collibra.core.rest.client.model.ChangeStatusRequest;
import com.collibra.core.rest.client.model.StatusImpl;
import com.collibra.core.rest.client.model.StatusPagedResponse;
import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

public interface StatusesApi
extends ApiClient.Api {
    @RequestLine(value="POST /statuses")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public StatusImpl addStatus(AddStatusRequest var1);

    @RequestLine(value="POST /statuses")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<StatusImpl> addStatusWithHttpInfo(AddStatusRequest var1);

    @RequestLine(value="POST /statuses/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public List<StatusImpl> addStatuses(List<AddStatusRequest> var1);

    @RequestLine(value="POST /statuses/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<List<StatusImpl>> addStatusesWithHttpInfo(List<AddStatusRequest> var1);

    @RequestLine(value="PATCH /statuses/{statusId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public StatusImpl changeStatus(@Param(value="statusId") UUID var1, ChangeStatusRequest var2);

    @RequestLine(value="PATCH /statuses/{statusId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<StatusImpl> changeStatusWithHttpInfo(@Param(value="statusId") UUID var1, ChangeStatusRequest var2);

    @RequestLine(value="PATCH /statuses/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public List<StatusImpl> changeStatuses(List<ChangeStatusRequest> var1);

    @RequestLine(value="PATCH /statuses/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<List<StatusImpl>> changeStatusesWithHttpInfo(List<ChangeStatusRequest> var1);

    @RequestLine(value="GET /statuses?offset={offset}&limit={limit}&countLimit={countLimit}&name={name}&nameMatchMode={nameMatchMode}&description={description}")
    @Headers(value={"Accept: application/json"})
    public StatusPagedResponse findStatuses(@Param(value="offset") Integer var1, @Param(value="limit") Integer var2, @Param(value="countLimit") Integer var3, @Param(value="name") String var4, @Param(value="nameMatchMode") String var5, @Param(value="description") String var6);

    @RequestLine(value="GET /statuses?offset={offset}&limit={limit}&countLimit={countLimit}&name={name}&nameMatchMode={nameMatchMode}&description={description}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<StatusPagedResponse> findStatusesWithHttpInfo(@Param(value="offset") Integer var1, @Param(value="limit") Integer var2, @Param(value="countLimit") Integer var3, @Param(value="name") String var4, @Param(value="nameMatchMode") String var5, @Param(value="description") String var6);

    @RequestLine(value="GET /statuses?offset={offset}&limit={limit}&countLimit={countLimit}&name={name}&nameMatchMode={nameMatchMode}&description={description}")
    @Headers(value={"Accept: application/json"})
    public StatusPagedResponse findStatuses(@QueryMap(encoded=true) FindStatusesQueryParams var1);

    @RequestLine(value="GET /statuses?offset={offset}&limit={limit}&countLimit={countLimit}&name={name}&nameMatchMode={nameMatchMode}&description={description}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<StatusPagedResponse> findStatusesWithHttpInfo(@QueryMap(encoded=true) FindStatusesQueryParams var1);

    @RequestLine(value="GET /statuses/{statusId}")
    @Headers(value={"Accept: application/json"})
    public StatusImpl getStatus(@Param(value="statusId") UUID var1);

    @RequestLine(value="GET /statuses/{statusId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<StatusImpl> getStatusWithHttpInfo(@Param(value="statusId") UUID var1);

    @RequestLine(value="GET /statuses/name/{statusName}")
    @Headers(value={"Accept: application/json"})
    public StatusImpl getStatusByName(@Param(value="statusName") String var1);

    @RequestLine(value="GET /statuses/name/{statusName}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<StatusImpl> getStatusByNameWithHttpInfo(@Param(value="statusName") String var1);

    @RequestLine(value="DELETE /statuses/{statusId}")
    @Headers(value={"Accept: application/json"})
    public void removeStatus(@Param(value="statusId") UUID var1);

    @RequestLine(value="DELETE /statuses/{statusId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> removeStatusWithHttpInfo(@Param(value="statusId") UUID var1);

    @RequestLine(value="DELETE /statuses/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void removeStatuses(List<UUID> var1);

    @RequestLine(value="DELETE /statuses/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Void> removeStatusesWithHttpInfo(List<UUID> var1);

    public static class FindStatusesQueryParams
    extends HashMap<String, Object> {
        public FindStatusesQueryParams offset(Integer value) {
            this.put("offset", EncodingUtils.encode(value));
            return this;
        }

        public FindStatusesQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public FindStatusesQueryParams countLimit(Integer value) {
            this.put("countLimit", EncodingUtils.encode(value));
            return this;
        }

        public FindStatusesQueryParams name(String value) {
            this.put("name", EncodingUtils.encode(value));
            return this;
        }

        public FindStatusesQueryParams nameMatchMode(String value) {
            this.put("nameMatchMode", EncodingUtils.encode(value));
            return this;
        }

        public FindStatusesQueryParams description(String value) {
            this.put("description", EncodingUtils.encode(value));
            return this;
        }
    }
}

