/*
 * Decompiled with CFR 0.152.
 */
package com.collibra.core.rest.client.api;

import com.collibra.core.rest.client.invoker.ApiClient;
import com.collibra.core.rest.client.invoker.EncodingUtils;
import com.collibra.core.rest.client.model.AddRoleRequest;
import com.collibra.core.rest.client.model.ApiResponse;
import com.collibra.core.rest.client.model.ChangeRoleRequest;
import com.collibra.core.rest.client.model.PagedResponseRole;
import com.collibra.core.rest.client.model.RoleImpl;
import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;

public interface RolesApi
extends ApiClient.Api {
    @RequestLine(value="POST /roles")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public RoleImpl addRole(AddRoleRequest var1);

    @RequestLine(value="POST /roles")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<RoleImpl> addRoleWithHttpInfo(AddRoleRequest var1);

    @RequestLine(value="PATCH /roles/{roleId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public RoleImpl changeRole(@Param(value="roleId") UUID var1, ChangeRoleRequest var2);

    @RequestLine(value="PATCH /roles/{roleId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<RoleImpl> changeRoleWithHttpInfo(@Param(value="roleId") UUID var1, ChangeRoleRequest var2);

    @RequestLine(value="GET /roles?offset={offset}&limit={limit}&countLimit={countLimit}&name={name}&nameMatchMode={nameMatchMode}&description={description}&global={global}&type={type}")
    @Headers(value={"Accept: application/json"})
    public PagedResponseRole findRoles(@Param(value="offset") Integer var1, @Param(value="limit") Integer var2, @Param(value="countLimit") Integer var3, @Param(value="name") String var4, @Param(value="nameMatchMode") String var5, @Param(value="description") String var6, @Param(value="global") Boolean var7, @Param(value="type") String var8);

    @RequestLine(value="GET /roles?offset={offset}&limit={limit}&countLimit={countLimit}&name={name}&nameMatchMode={nameMatchMode}&description={description}&global={global}&type={type}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<PagedResponseRole> findRolesWithHttpInfo(@Param(value="offset") Integer var1, @Param(value="limit") Integer var2, @Param(value="countLimit") Integer var3, @Param(value="name") String var4, @Param(value="nameMatchMode") String var5, @Param(value="description") String var6, @Param(value="global") Boolean var7, @Param(value="type") String var8);

    @RequestLine(value="GET /roles?offset={offset}&limit={limit}&countLimit={countLimit}&name={name}&nameMatchMode={nameMatchMode}&description={description}&global={global}&type={type}")
    @Headers(value={"Accept: application/json"})
    public PagedResponseRole findRoles(@QueryMap(encoded=true) FindRolesQueryParams var1);

    @RequestLine(value="GET /roles?offset={offset}&limit={limit}&countLimit={countLimit}&name={name}&nameMatchMode={nameMatchMode}&description={description}&global={global}&type={type}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<PagedResponseRole> findRolesWithHttpInfo(@QueryMap(encoded=true) FindRolesQueryParams var1);

    @RequestLine(value="GET /roles/{roleId}")
    @Headers(value={"Accept: application/json"})
    public RoleImpl getRole(@Param(value="roleId") UUID var1);

    @RequestLine(value="GET /roles/{roleId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<RoleImpl> getRoleWithHttpInfo(@Param(value="roleId") UUID var1);

    @RequestLine(value="DELETE /roles/{roleId}")
    @Headers(value={"Accept: application/json"})
    public void removeRole(@Param(value="roleId") UUID var1);

    @RequestLine(value="DELETE /roles/{roleId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> removeRoleWithHttpInfo(@Param(value="roleId") UUID var1);

    public static class FindRolesQueryParams
    extends HashMap<String, Object> {
        public FindRolesQueryParams offset(Integer value) {
            this.put("offset", EncodingUtils.encode(value));
            return this;
        }

        public FindRolesQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public FindRolesQueryParams countLimit(Integer value) {
            this.put("countLimit", EncodingUtils.encode(value));
            return this;
        }

        public FindRolesQueryParams name(String value) {
            this.put("name", EncodingUtils.encode(value));
            return this;
        }

        public FindRolesQueryParams nameMatchMode(String value) {
            this.put("nameMatchMode", EncodingUtils.encode(value));
            return this;
        }

        public FindRolesQueryParams description(String value) {
            this.put("description", EncodingUtils.encode(value));
            return this;
        }

        public FindRolesQueryParams global(Boolean value) {
            this.put("global", EncodingUtils.encode(value));
            return this;
        }

        public FindRolesQueryParams type(String value) {
            this.put("type", EncodingUtils.encode(value));
            return this;
        }
    }
}

