/*
 * Decompiled with CFR 0.152.
 */
package com.collibra.core.rest.client.api;

import com.collibra.core.rest.client.invoker.ApiClient;
import com.collibra.core.rest.client.invoker.EncodingUtils;
import com.collibra.core.rest.client.model.AddRelationRequest;
import com.collibra.core.rest.client.model.ApiResponse;
import com.collibra.core.rest.client.model.ChangeRelationRequest;
import com.collibra.core.rest.client.model.RelationImpl;
import com.collibra.core.rest.client.model.RelationPagedResponse;
import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

public interface RelationsApi
extends ApiClient.Api {
    @RequestLine(value="POST /relations")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public RelationImpl addRelation(AddRelationRequest var1);

    @RequestLine(value="POST /relations")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<RelationImpl> addRelationWithHttpInfo(AddRelationRequest var1);

    @RequestLine(value="POST /relations/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public List<RelationImpl> addRelations(List<AddRelationRequest> var1);

    @RequestLine(value="POST /relations/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<List<RelationImpl>> addRelationsWithHttpInfo(List<AddRelationRequest> var1);

    @RequestLine(value="PATCH /relations/{relationId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public RelationImpl changeRelation(@Param(value="relationId") UUID var1, ChangeRelationRequest var2);

    @RequestLine(value="PATCH /relations/{relationId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<RelationImpl> changeRelationWithHttpInfo(@Param(value="relationId") UUID var1, ChangeRelationRequest var2);

    @RequestLine(value="PATCH /relations/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public List<RelationImpl> changeRelations(List<ChangeRelationRequest> var1);

    @RequestLine(value="PATCH /relations/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<List<RelationImpl>> changeRelationsWithHttpInfo(List<ChangeRelationRequest> var1);

    @RequestLine(value="GET /relations?offset={offset}&limit={limit}&countLimit={countLimit}&cursor={cursor}&relationTypeId={relationTypeId}&sourceId={sourceId}&targetId={targetId}&sourceTargetLogicalOperator={sourceTargetLogicalOperator}")
    @Headers(value={"Accept: application/json"})
    public RelationPagedResponse findRelations(@Param(value="offset") Integer var1, @Param(value="limit") Integer var2, @Param(value="countLimit") Integer var3, @Param(value="cursor") String var4, @Param(value="relationTypeId") UUID var5, @Param(value="sourceId") UUID var6, @Param(value="targetId") UUID var7, @Param(value="sourceTargetLogicalOperator") String var8);

    @RequestLine(value="GET /relations?offset={offset}&limit={limit}&countLimit={countLimit}&cursor={cursor}&relationTypeId={relationTypeId}&sourceId={sourceId}&targetId={targetId}&sourceTargetLogicalOperator={sourceTargetLogicalOperator}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<RelationPagedResponse> findRelationsWithHttpInfo(@Param(value="offset") Integer var1, @Param(value="limit") Integer var2, @Param(value="countLimit") Integer var3, @Param(value="cursor") String var4, @Param(value="relationTypeId") UUID var5, @Param(value="sourceId") UUID var6, @Param(value="targetId") UUID var7, @Param(value="sourceTargetLogicalOperator") String var8);

    @RequestLine(value="GET /relations?offset={offset}&limit={limit}&countLimit={countLimit}&cursor={cursor}&relationTypeId={relationTypeId}&sourceId={sourceId}&targetId={targetId}&sourceTargetLogicalOperator={sourceTargetLogicalOperator}")
    @Headers(value={"Accept: application/json"})
    public RelationPagedResponse findRelations(@QueryMap(encoded=true) FindRelationsQueryParams var1);

    @RequestLine(value="GET /relations?offset={offset}&limit={limit}&countLimit={countLimit}&cursor={cursor}&relationTypeId={relationTypeId}&sourceId={sourceId}&targetId={targetId}&sourceTargetLogicalOperator={sourceTargetLogicalOperator}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<RelationPagedResponse> findRelationsWithHttpInfo(@QueryMap(encoded=true) FindRelationsQueryParams var1);

    @RequestLine(value="GET /relations/{relationId}")
    @Headers(value={"Accept: application/json"})
    public RelationImpl getRelation(@Param(value="relationId") UUID var1);

    @RequestLine(value="GET /relations/{relationId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<RelationImpl> getRelationWithHttpInfo(@Param(value="relationId") UUID var1);

    @RequestLine(value="DELETE /relations/{relationId}")
    @Headers(value={"Accept: application/json"})
    public void removeRelation(@Param(value="relationId") UUID var1);

    @RequestLine(value="DELETE /relations/{relationId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> removeRelationWithHttpInfo(@Param(value="relationId") UUID var1);

    @RequestLine(value="DELETE /relations/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void removeRelations(List<UUID> var1);

    @RequestLine(value="DELETE /relations/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Void> removeRelationsWithHttpInfo(List<UUID> var1);

    public static class FindRelationsQueryParams
    extends HashMap<String, Object> {
        public FindRelationsQueryParams offset(Integer value) {
            this.put("offset", EncodingUtils.encode(value));
            return this;
        }

        public FindRelationsQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public FindRelationsQueryParams countLimit(Integer value) {
            this.put("countLimit", EncodingUtils.encode(value));
            return this;
        }

        public FindRelationsQueryParams cursor(String value) {
            this.put("cursor", EncodingUtils.encode(value));
            return this;
        }

        public FindRelationsQueryParams relationTypeId(UUID value) {
            this.put("relationTypeId", EncodingUtils.encode(value));
            return this;
        }

        public FindRelationsQueryParams sourceId(UUID value) {
            this.put("sourceId", EncodingUtils.encode(value));
            return this;
        }

        public FindRelationsQueryParams targetId(UUID value) {
            this.put("targetId", EncodingUtils.encode(value));
            return this;
        }

        public FindRelationsQueryParams sourceTargetLogicalOperator(String value) {
            this.put("sourceTargetLogicalOperator", EncodingUtils.encode(value));
            return this;
        }
    }
}

