/*
 * Decompiled with CFR 0.152.
 */
package com.collibra.core.rest.client.api;

import com.collibra.core.rest.client.invoker.ApiClient;
import com.collibra.core.rest.client.invoker.EncodingUtils;
import com.collibra.core.rest.client.model.AddRatingRequest;
import com.collibra.core.rest.client.model.ApiResponse;
import com.collibra.core.rest.client.model.ChangeRatingRequest;
import com.collibra.core.rest.client.model.Rating;
import com.collibra.core.rest.client.model.RatingsPagedResponse;
import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;

public interface RatingsApi
extends ApiClient.Api {
    @RequestLine(value="POST /ratings")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Rating addRating(AddRatingRequest var1);

    @RequestLine(value="POST /ratings")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Rating> addRatingWithHttpInfo(AddRatingRequest var1);

    @RequestLine(value="PATCH /ratings/{ratingId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Rating changeRating(@Param(value="ratingId") UUID var1, ChangeRatingRequest var2);

    @RequestLine(value="PATCH /ratings/{ratingId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Rating> changeRatingWithHttpInfo(@Param(value="ratingId") UUID var1, ChangeRatingRequest var2);

    @RequestLine(value="GET /ratings?offset={offset}&limit={limit}&countLimit={countLimit}&sortOrder={sortOrder}&assetId={assetId}&userId={userId}")
    @Headers(value={"Accept: application/json"})
    public RatingsPagedResponse findRatings(@Param(value="offset") Integer var1, @Param(value="limit") Integer var2, @Param(value="countLimit") Integer var3, @Param(value="sortOrder") String var4, @Param(value="assetId") UUID var5, @Param(value="userId") UUID var6);

    @RequestLine(value="GET /ratings?offset={offset}&limit={limit}&countLimit={countLimit}&sortOrder={sortOrder}&assetId={assetId}&userId={userId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<RatingsPagedResponse> findRatingsWithHttpInfo(@Param(value="offset") Integer var1, @Param(value="limit") Integer var2, @Param(value="countLimit") Integer var3, @Param(value="sortOrder") String var4, @Param(value="assetId") UUID var5, @Param(value="userId") UUID var6);

    @RequestLine(value="GET /ratings?offset={offset}&limit={limit}&countLimit={countLimit}&sortOrder={sortOrder}&assetId={assetId}&userId={userId}")
    @Headers(value={"Accept: application/json"})
    public RatingsPagedResponse findRatings(@QueryMap(encoded=true) FindRatingsQueryParams var1);

    @RequestLine(value="GET /ratings?offset={offset}&limit={limit}&countLimit={countLimit}&sortOrder={sortOrder}&assetId={assetId}&userId={userId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<RatingsPagedResponse> findRatingsWithHttpInfo(@QueryMap(encoded=true) FindRatingsQueryParams var1);

    @RequestLine(value="GET /ratings/{ratingId}")
    @Headers(value={"Accept: application/json"})
    public Rating getRating(@Param(value="ratingId") UUID var1);

    @RequestLine(value="GET /ratings/{ratingId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Rating> getRatingWithHttpInfo(@Param(value="ratingId") UUID var1);

    @RequestLine(value="DELETE /ratings/{ratingId}")
    @Headers(value={"Accept: application/json"})
    public void removeRating(@Param(value="ratingId") UUID var1);

    @RequestLine(value="DELETE /ratings/{ratingId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> removeRatingWithHttpInfo(@Param(value="ratingId") UUID var1);

    public static class FindRatingsQueryParams
    extends HashMap<String, Object> {
        public FindRatingsQueryParams offset(Integer value) {
            this.put("offset", EncodingUtils.encode(value));
            return this;
        }

        public FindRatingsQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public FindRatingsQueryParams countLimit(Integer value) {
            this.put("countLimit", EncodingUtils.encode(value));
            return this;
        }

        public FindRatingsQueryParams sortOrder(String value) {
            this.put("sortOrder", EncodingUtils.encode(value));
            return this;
        }

        public FindRatingsQueryParams assetId(UUID value) {
            this.put("assetId", EncodingUtils.encode(value));
            return this;
        }

        public FindRatingsQueryParams userId(UUID value) {
            this.put("userId", EncodingUtils.encode(value));
            return this;
        }
    }
}

