/*
 * Decompiled with CFR 0.152.
 */
package com.collibra.core.rest.client.api;

import com.collibra.core.rest.client.invoker.ApiClient;
import com.collibra.core.rest.client.invoker.EncodingUtils;
import com.collibra.core.rest.client.model.AddMappingRequest;
import com.collibra.core.rest.client.model.ApiResponse;
import com.collibra.core.rest.client.model.ChangeMappingByExternalEntityRequest;
import com.collibra.core.rest.client.model.ChangeMappingByMappedResourceRequest;
import com.collibra.core.rest.client.model.ChangeMappingRequest;
import com.collibra.core.rest.client.model.Job;
import com.collibra.core.rest.client.model.Mapping;
import com.collibra.core.rest.client.model.MappingPagedResponse;
import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

public interface MappingsApi
extends ApiClient.Api {
    @RequestLine(value="POST /mappings")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Mapping addMapping(AddMappingRequest var1);

    @RequestLine(value="POST /mappings")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Mapping> addMappingWithHttpInfo(AddMappingRequest var1);

    @RequestLine(value="POST /mappings/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public List<Mapping> addMappings(List<AddMappingRequest> var1);

    @RequestLine(value="POST /mappings/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<List<Mapping>> addMappingsWithHttpInfo(List<AddMappingRequest> var1);

    @RequestLine(value="PATCH /mappings/{mappingId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Mapping changeMapping(@Param(value="mappingId") UUID var1, ChangeMappingRequest var2);

    @RequestLine(value="PATCH /mappings/{mappingId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Mapping> changeMappingWithHttpInfo(@Param(value="mappingId") UUID var1, ChangeMappingRequest var2);

    @RequestLine(value="PATCH /mappings/externalSystem/{externalSystemId}/externalEntity/{externalEntityId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Mapping changeMappingByExternalEntity(@Param(value="externalSystemId") String var1, @Param(value="externalEntityId") String var2, ChangeMappingByExternalEntityRequest var3);

    @RequestLine(value="PATCH /mappings/externalSystem/{externalSystemId}/externalEntity/{externalEntityId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Mapping> changeMappingByExternalEntityWithHttpInfo(@Param(value="externalSystemId") String var1, @Param(value="externalEntityId") String var2, ChangeMappingByExternalEntityRequest var3);

    @RequestLine(value="PATCH /mappings/externalSystem/{externalSystemId}/mappedResource/{mappedResourceId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Mapping changeMappingByMappedResource(@Param(value="externalSystemId") String var1, @Param(value="mappedResourceId") UUID var2, ChangeMappingByMappedResourceRequest var3);

    @RequestLine(value="PATCH /mappings/externalSystem/{externalSystemId}/mappedResource/{mappedResourceId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Mapping> changeMappingByMappedResourceWithHttpInfo(@Param(value="externalSystemId") String var1, @Param(value="mappedResourceId") UUID var2, ChangeMappingByMappedResourceRequest var3);

    @RequestLine(value="PATCH /mappings/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public List<Mapping> changeMappings(List<ChangeMappingRequest> var1);

    @RequestLine(value="PATCH /mappings/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<List<Mapping>> changeMappingsWithHttpInfo(List<ChangeMappingRequest> var1);

    @RequestLine(value="PATCH /mappings/externalSystem/externalEntity/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public List<Mapping> changeMappingsByExternalEntities(List<ChangeMappingByExternalEntityRequest> var1);

    @RequestLine(value="PATCH /mappings/externalSystem/externalEntity/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<List<Mapping>> changeMappingsByExternalEntitiesWithHttpInfo(List<ChangeMappingByExternalEntityRequest> var1);

    @RequestLine(value="PATCH /mappings/externalSystem/mappedResource/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public List<Mapping> changeMappingsByMappedResources(List<ChangeMappingByMappedResourceRequest> var1);

    @RequestLine(value="PATCH /mappings/externalSystem/mappedResource/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<List<Mapping>> changeMappingsByMappedResourcesWithHttpInfo(List<ChangeMappingByMappedResourceRequest> var1);

    @RequestLine(value="GET /mappings?offset={offset}&limit={limit}&countLimit={countLimit}&externalSystemId={externalSystemId}&externalEntityId={externalEntityId}&mappedResourceType={mappedResourceType}&syncAction={syncAction}")
    @Headers(value={"Accept: application/json"})
    public MappingPagedResponse findMappings(@Param(value="offset") Integer var1, @Param(value="limit") Integer var2, @Param(value="countLimit") Integer var3, @Param(value="externalSystemId") String var4, @Param(value="externalEntityId") String var5, @Param(value="mappedResourceType") String var6, @Param(value="syncAction") String var7);

    @RequestLine(value="GET /mappings?offset={offset}&limit={limit}&countLimit={countLimit}&externalSystemId={externalSystemId}&externalEntityId={externalEntityId}&mappedResourceType={mappedResourceType}&syncAction={syncAction}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MappingPagedResponse> findMappingsWithHttpInfo(@Param(value="offset") Integer var1, @Param(value="limit") Integer var2, @Param(value="countLimit") Integer var3, @Param(value="externalSystemId") String var4, @Param(value="externalEntityId") String var5, @Param(value="mappedResourceType") String var6, @Param(value="syncAction") String var7);

    @RequestLine(value="GET /mappings?offset={offset}&limit={limit}&countLimit={countLimit}&externalSystemId={externalSystemId}&externalEntityId={externalEntityId}&mappedResourceType={mappedResourceType}&syncAction={syncAction}")
    @Headers(value={"Accept: application/json"})
    public MappingPagedResponse findMappings(@QueryMap(encoded=true) FindMappingsQueryParams var1);

    @RequestLine(value="GET /mappings?offset={offset}&limit={limit}&countLimit={countLimit}&externalSystemId={externalSystemId}&externalEntityId={externalEntityId}&mappedResourceType={mappedResourceType}&syncAction={syncAction}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<MappingPagedResponse> findMappingsWithHttpInfo(@QueryMap(encoded=true) FindMappingsQueryParams var1);

    @RequestLine(value="GET /mappings/{mappingId}")
    @Headers(value={"Accept: application/json"})
    public Mapping getMapping(@Param(value="mappingId") UUID var1);

    @RequestLine(value="GET /mappings/{mappingId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Mapping> getMappingWithHttpInfo(@Param(value="mappingId") UUID var1);

    @RequestLine(value="GET /mappings/externalSystem/{externalSystemId}/externalEntity/{externalEntityId}")
    @Headers(value={"Accept: application/json"})
    public Mapping getMappingByExternalEntity(@Param(value="externalSystemId") String var1, @Param(value="externalEntityId") String var2);

    @RequestLine(value="GET /mappings/externalSystem/{externalSystemId}/externalEntity/{externalEntityId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Mapping> getMappingByExternalEntityWithHttpInfo(@Param(value="externalSystemId") String var1, @Param(value="externalEntityId") String var2);

    @RequestLine(value="GET /mappings/externalSystem/{externalSystemId}/mappedResource/{mappedResourceId}")
    @Headers(value={"Accept: application/json"})
    public Mapping getMappingByMappedResource(@Param(value="externalSystemId") String var1, @Param(value="mappedResourceId") UUID var2);

    @RequestLine(value="GET /mappings/externalSystem/{externalSystemId}/mappedResource/{mappedResourceId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Mapping> getMappingByMappedResourceWithHttpInfo(@Param(value="externalSystemId") String var1, @Param(value="mappedResourceId") UUID var2);

    @RequestLine(value="DELETE /mappings/{mappingId}")
    @Headers(value={"Accept: application/json"})
    public void removeMapping(@Param(value="mappingId") UUID var1);

    @RequestLine(value="DELETE /mappings/{mappingId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> removeMappingWithHttpInfo(@Param(value="mappingId") UUID var1);

    @RequestLine(value="DELETE /mappings/externalSystem/{externalSystemId}/externalEntity/{externalEntityId}")
    @Headers(value={"Accept: application/json"})
    public void removeMappingByExternalEntity(@Param(value="externalSystemId") String var1, @Param(value="externalEntityId") String var2);

    @RequestLine(value="DELETE /mappings/externalSystem/{externalSystemId}/externalEntity/{externalEntityId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> removeMappingByExternalEntityWithHttpInfo(@Param(value="externalSystemId") String var1, @Param(value="externalEntityId") String var2);

    @RequestLine(value="DELETE /mappings/externalSystem/{externalSystemId}/mappedResource/{mappedResourceId}")
    @Headers(value={"Accept: application/json"})
    public void removeMappingByMappedResource(@Param(value="externalSystemId") String var1, @Param(value="mappedResourceId") String var2);

    @RequestLine(value="DELETE /mappings/externalSystem/{externalSystemId}/mappedResource/{mappedResourceId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> removeMappingByMappedResourceWithHttpInfo(@Param(value="externalSystemId") String var1, @Param(value="mappedResourceId") String var2);

    @RequestLine(value="POST /mappings/externalSystem/{externalSystemId}/removalJobs")
    @Headers(value={"Accept: application/json"})
    public Job removeMappingsByExternalSystemInJob(@Param(value="externalSystemId") String var1);

    @RequestLine(value="POST /mappings/externalSystem/{externalSystemId}/removalJobs")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Job> removeMappingsByExternalSystemInJobWithHttpInfo(@Param(value="externalSystemId") String var1);

    @RequestLine(value="POST /mappings/removalJobs")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Job removeMappingsInJob(List<UUID> var1);

    @RequestLine(value="POST /mappings/removalJobs")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Job> removeMappingsInJobWithHttpInfo(List<UUID> var1);

    public static class FindMappingsQueryParams
    extends HashMap<String, Object> {
        public FindMappingsQueryParams offset(Integer value) {
            this.put("offset", EncodingUtils.encode(value));
            return this;
        }

        public FindMappingsQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public FindMappingsQueryParams countLimit(Integer value) {
            this.put("countLimit", EncodingUtils.encode(value));
            return this;
        }

        public FindMappingsQueryParams externalSystemId(String value) {
            this.put("externalSystemId", EncodingUtils.encode(value));
            return this;
        }

        public FindMappingsQueryParams externalEntityId(String value) {
            this.put("externalEntityId", EncodingUtils.encode(value));
            return this;
        }

        public FindMappingsQueryParams mappedResourceType(String value) {
            this.put("mappedResourceType", EncodingUtils.encode(value));
            return this;
        }

        public FindMappingsQueryParams syncAction(String value) {
            this.put("syncAction", EncodingUtils.encode(value));
            return this;
        }
    }
}

