/*
 * Decompiled with CFR 0.152.
 */
package com.collibra.core.rest.client.api;

import com.collibra.core.rest.client.invoker.ApiClient;
import com.collibra.core.rest.client.invoker.EncodingUtils;
import com.collibra.core.rest.client.model.AddIssueRequest;
import com.collibra.core.rest.client.model.ApiResponse;
import com.collibra.core.rest.client.model.AssetImpl;
import com.collibra.core.rest.client.model.AssetPagedResponse;
import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;

public interface IssuesApi
extends ApiClient.Api {
    @RequestLine(value="POST /issues")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public AssetImpl addIssue(AddIssueRequest var1);

    @RequestLine(value="POST /issues")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<AssetImpl> addIssueWithHttpInfo(AddIssueRequest var1);

    @RequestLine(value="GET /issues?offset={offset}&limit={limit}&countLimit={countLimit}&sortOrder={sortOrder}&sortField={sortField}&onlyOpenIssues={onlyOpenIssues}&userRelation={userRelation}")
    @Headers(value={"Accept: application/json"})
    public AssetPagedResponse findIssues(@Param(value="offset") Integer var1, @Param(value="limit") Integer var2, @Param(value="countLimit") Integer var3, @Param(value="sortOrder") String var4, @Param(value="sortField") String var5, @Param(value="onlyOpenIssues") Boolean var6, @Param(value="userRelation") String var7);

    @RequestLine(value="GET /issues?offset={offset}&limit={limit}&countLimit={countLimit}&sortOrder={sortOrder}&sortField={sortField}&onlyOpenIssues={onlyOpenIssues}&userRelation={userRelation}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<AssetPagedResponse> findIssuesWithHttpInfo(@Param(value="offset") Integer var1, @Param(value="limit") Integer var2, @Param(value="countLimit") Integer var3, @Param(value="sortOrder") String var4, @Param(value="sortField") String var5, @Param(value="onlyOpenIssues") Boolean var6, @Param(value="userRelation") String var7);

    @RequestLine(value="GET /issues?offset={offset}&limit={limit}&countLimit={countLimit}&sortOrder={sortOrder}&sortField={sortField}&onlyOpenIssues={onlyOpenIssues}&userRelation={userRelation}")
    @Headers(value={"Accept: application/json"})
    public AssetPagedResponse findIssues(@QueryMap(encoded=true) FindIssuesQueryParams var1);

    @RequestLine(value="GET /issues?offset={offset}&limit={limit}&countLimit={countLimit}&sortOrder={sortOrder}&sortField={sortField}&onlyOpenIssues={onlyOpenIssues}&userRelation={userRelation}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<AssetPagedResponse> findIssuesWithHttpInfo(@QueryMap(encoded=true) FindIssuesQueryParams var1);

    @RequestLine(value="PATCH /issues/{issueId}/community/{communityId}")
    @Headers(value={"Accept: application/json"})
    public AssetImpl moveIssue(@Param(value="issueId") UUID var1, @Param(value="communityId") UUID var2);

    @RequestLine(value="PATCH /issues/{issueId}/community/{communityId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<AssetImpl> moveIssueWithHttpInfo(@Param(value="issueId") UUID var1, @Param(value="communityId") UUID var2);

    public static class FindIssuesQueryParams
    extends HashMap<String, Object> {
        public FindIssuesQueryParams offset(Integer value) {
            this.put("offset", EncodingUtils.encode(value));
            return this;
        }

        public FindIssuesQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public FindIssuesQueryParams countLimit(Integer value) {
            this.put("countLimit", EncodingUtils.encode(value));
            return this;
        }

        public FindIssuesQueryParams sortOrder(String value) {
            this.put("sortOrder", EncodingUtils.encode(value));
            return this;
        }

        public FindIssuesQueryParams sortField(String value) {
            this.put("sortField", EncodingUtils.encode(value));
            return this;
        }

        public FindIssuesQueryParams onlyOpenIssues(Boolean value) {
            this.put("onlyOpenIssues", EncodingUtils.encode(value));
            return this;
        }

        public FindIssuesQueryParams userRelation(String value) {
            this.put("userRelation", EncodingUtils.encode(value));
            return this;
        }
    }
}

