/*
 * Decompiled with CFR 0.152.
 */
package com.collibra.core.rest.client.api;

import com.collibra.core.rest.client.invoker.ApiClient;
import com.collibra.core.rest.client.invoker.EncodingUtils;
import com.collibra.core.rest.client.model.ApiResponse;
import com.collibra.core.rest.client.model.FileInfoImpl;
import com.collibra.core.rest.client.model.ScopeImpl;
import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

public interface FilesApi
extends ApiClient.Api {
    @RequestLine(value="POST /files")
    @Headers(value={"Content-Type: multipart/form-data", "Accept: application/json"})
    public List<FileInfoImpl> addFiles(@Param(value="file") File var1);

    @RequestLine(value="POST /files")
    @Headers(value={"Content-Type: multipart/form-data", "Accept: application/json"})
    public ApiResponse<List<FileInfoImpl>> addFilesWithHttpInfo(@Param(value="file") File var1);

    @RequestLine(value="DELETE /files/{fileId}")
    @Headers(value={"Accept: application/json"})
    public void deleteFile(@Param(value="fileId") UUID var1);

    @RequestLine(value="DELETE /files/{fileId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteFileWithHttpInfo(@Param(value="fileId") UUID var1);

    @RequestLine(value="DELETE /files/bulk?timeToLive={timeToLive}")
    @Headers(value={"Accept: application/json"})
    public void deleteFiles(@Param(value="timeToLive") Long var1);

    @RequestLine(value="DELETE /files/bulk?timeToLive={timeToLive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteFilesWithHttpInfo(@Param(value="timeToLive") Long var1);

    @RequestLine(value="DELETE /files/bulk?timeToLive={timeToLive}")
    @Headers(value={"Accept: application/json"})
    public void deleteFiles(@QueryMap(encoded=true) DeleteFilesQueryParams var1);

    @RequestLine(value="DELETE /files/bulk?timeToLive={timeToLive}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteFilesWithHttpInfo(@QueryMap(encoded=true) DeleteFilesQueryParams var1);

    @RequestLine(value="GET /files/{fileId}")
    @Headers(value={"Accept: application/json"})
    public File getFile(@Param(value="fileId") UUID var1);

    @RequestLine(value="GET /files/{fileId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<File> getFileWithHttpInfo(@Param(value="fileId") UUID var1);

    @RequestLine(value="GET /files/{fileId}/info")
    @Headers(value={"Accept: application/json"})
    public ScopeImpl getFileInfo(@Param(value="fileId") UUID var1);

    @RequestLine(value="GET /files/{fileId}/info")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ScopeImpl> getFileInfoWithHttpInfo(@Param(value="fileId") UUID var1);

    public static class DeleteFilesQueryParams
    extends HashMap<String, Object> {
        public DeleteFilesQueryParams timeToLive(Long value) {
            this.put("timeToLive", EncodingUtils.encode(value));
            return this;
        }
    }
}

