/*
 * Decompiled with CFR 0.152.
 */
package com.collibra.core.rest.client.api;

import com.collibra.core.rest.client.invoker.ApiClient;
import com.collibra.core.rest.client.invoker.EncodingUtils;
import com.collibra.core.rest.client.model.AddDomainRequest;
import com.collibra.core.rest.client.model.ApiResponse;
import com.collibra.core.rest.client.model.ChangeDomainRequest;
import com.collibra.core.rest.client.model.DomainImpl;
import com.collibra.core.rest.client.model.DomainPagedResponse;
import com.collibra.core.rest.client.model.Job;
import com.collibra.core.rest.client.model.NamedResourceReferenceImpl;
import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

public interface DomainsApi
extends ApiClient.Api {
    @RequestLine(value="POST /domains")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public DomainImpl addDomain(AddDomainRequest var1);

    @RequestLine(value="POST /domains")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<DomainImpl> addDomainWithHttpInfo(AddDomainRequest var1);

    @RequestLine(value="POST /domains/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public List<DomainImpl> addDomains(List<AddDomainRequest> var1);

    @RequestLine(value="POST /domains/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<List<DomainImpl>> addDomainsWithHttpInfo(List<AddDomainRequest> var1);

    @RequestLine(value="PATCH /domains/{domainId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public DomainImpl changeDomain(@Param(value="domainId") UUID var1, ChangeDomainRequest var2);

    @RequestLine(value="PATCH /domains/{domainId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<DomainImpl> changeDomainWithHttpInfo(@Param(value="domainId") UUID var1, ChangeDomainRequest var2);

    @RequestLine(value="PATCH /domains/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public List<DomainImpl> changeDomains(List<ChangeDomainRequest> var1);

    @RequestLine(value="PATCH /domains/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<List<DomainImpl>> changeDomainsWithHttpInfo(List<ChangeDomainRequest> var1);

    @RequestLine(value="GET /domains?offset={offset}&limit={limit}&countLimit={countLimit}&cursor={cursor}&name={name}&nameMatchMode={nameMatchMode}&excludeMeta={excludeMeta}&communityId={communityId}&typeId={typeId}&includeSubCommunities={includeSubCommunities}")
    @Headers(value={"Accept: application/json"})
    public DomainPagedResponse findDomains(@Param(value="offset") Integer var1, @Param(value="limit") Integer var2, @Param(value="countLimit") Integer var3, @Param(value="cursor") String var4, @Param(value="name") String var5, @Param(value="nameMatchMode") String var6, @Param(value="excludeMeta") Boolean var7, @Param(value="communityId") UUID var8, @Param(value="typeId") UUID var9, @Param(value="includeSubCommunities") Boolean var10);

    @RequestLine(value="GET /domains?offset={offset}&limit={limit}&countLimit={countLimit}&cursor={cursor}&name={name}&nameMatchMode={nameMatchMode}&excludeMeta={excludeMeta}&communityId={communityId}&typeId={typeId}&includeSubCommunities={includeSubCommunities}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DomainPagedResponse> findDomainsWithHttpInfo(@Param(value="offset") Integer var1, @Param(value="limit") Integer var2, @Param(value="countLimit") Integer var3, @Param(value="cursor") String var4, @Param(value="name") String var5, @Param(value="nameMatchMode") String var6, @Param(value="excludeMeta") Boolean var7, @Param(value="communityId") UUID var8, @Param(value="typeId") UUID var9, @Param(value="includeSubCommunities") Boolean var10);

    @RequestLine(value="GET /domains?offset={offset}&limit={limit}&countLimit={countLimit}&cursor={cursor}&name={name}&nameMatchMode={nameMatchMode}&excludeMeta={excludeMeta}&communityId={communityId}&typeId={typeId}&includeSubCommunities={includeSubCommunities}")
    @Headers(value={"Accept: application/json"})
    public DomainPagedResponse findDomains(@QueryMap(encoded=true) FindDomainsQueryParams var1);

    @RequestLine(value="GET /domains?offset={offset}&limit={limit}&countLimit={countLimit}&cursor={cursor}&name={name}&nameMatchMode={nameMatchMode}&excludeMeta={excludeMeta}&communityId={communityId}&typeId={typeId}&includeSubCommunities={includeSubCommunities}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DomainPagedResponse> findDomainsWithHttpInfo(@QueryMap(encoded=true) FindDomainsQueryParams var1);

    @RequestLine(value="GET /domains/{domainId}")
    @Headers(value={"Accept: application/json"})
    public DomainImpl getDomain(@Param(value="domainId") UUID var1);

    @RequestLine(value="GET /domains/{domainId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DomainImpl> getDomainWithHttpInfo(@Param(value="domainId") UUID var1);

    @RequestLine(value="GET /domains/{domainId}/breadcrumb")
    @Headers(value={"Accept: application/json"})
    public List<NamedResourceReferenceImpl> getDomainBreadcrumb(@Param(value="domainId") String var1);

    @RequestLine(value="GET /domains/{domainId}/breadcrumb")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<List<NamedResourceReferenceImpl>> getDomainBreadcrumbWithHttpInfo(@Param(value="domainId") String var1);

    @Deprecated
    @RequestLine(value="DELETE /domains/{domainId}")
    @Headers(value={"Accept: application/json"})
    public void removeDomain(@Param(value="domainId") UUID var1);

    @Deprecated
    @RequestLine(value="DELETE /domains/{domainId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> removeDomainWithHttpInfo(@Param(value="domainId") UUID var1);

    @Deprecated
    @RequestLine(value="DELETE /domains/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void removeDomains(List<UUID> var1);

    @Deprecated
    @RequestLine(value="DELETE /domains/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Void> removeDomainsWithHttpInfo(List<UUID> var1);

    @RequestLine(value="POST /domains/removalJobs")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Job removeDomainsInJob(List<UUID> var1);

    @RequestLine(value="POST /domains/removalJobs")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Job> removeDomainsInJobWithHttpInfo(List<UUID> var1);

    public static class FindDomainsQueryParams
    extends HashMap<String, Object> {
        public FindDomainsQueryParams offset(Integer value) {
            this.put("offset", EncodingUtils.encode(value));
            return this;
        }

        public FindDomainsQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public FindDomainsQueryParams countLimit(Integer value) {
            this.put("countLimit", EncodingUtils.encode(value));
            return this;
        }

        public FindDomainsQueryParams cursor(String value) {
            this.put("cursor", EncodingUtils.encode(value));
            return this;
        }

        public FindDomainsQueryParams name(String value) {
            this.put("name", EncodingUtils.encode(value));
            return this;
        }

        public FindDomainsQueryParams nameMatchMode(String value) {
            this.put("nameMatchMode", EncodingUtils.encode(value));
            return this;
        }

        public FindDomainsQueryParams excludeMeta(Boolean value) {
            this.put("excludeMeta", EncodingUtils.encode(value));
            return this;
        }

        public FindDomainsQueryParams communityId(UUID value) {
            this.put("communityId", EncodingUtils.encode(value));
            return this;
        }

        public FindDomainsQueryParams typeId(UUID value) {
            this.put("typeId", EncodingUtils.encode(value));
            return this;
        }

        public FindDomainsQueryParams includeSubCommunities(Boolean value) {
            this.put("includeSubCommunities", EncodingUtils.encode(value));
            return this;
        }
    }
}

