/*
 * Decompiled with CFR 0.152.
 */
package com.collibra.core.rest.client.api;

import com.collibra.core.rest.client.invoker.ApiClient;
import com.collibra.core.rest.client.invoker.EncodingUtils;
import com.collibra.core.rest.client.model.AddDomainTypeRequest;
import com.collibra.core.rest.client.model.ApiResponse;
import com.collibra.core.rest.client.model.ChangeDomainTypeRequest;
import com.collibra.core.rest.client.model.DomainTypeImpl;
import com.collibra.core.rest.client.model.DomainTypePagedResponse;
import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

public interface DomainTypesApi
extends ApiClient.Api {
    @RequestLine(value="POST /domainTypes")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public DomainTypeImpl addDomainType(AddDomainTypeRequest var1);

    @RequestLine(value="POST /domainTypes")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<DomainTypeImpl> addDomainTypeWithHttpInfo(AddDomainTypeRequest var1);

    @RequestLine(value="POST /domainTypes/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public List<DomainTypeImpl> addDomainTypes(List<AddDomainTypeRequest> var1);

    @RequestLine(value="POST /domainTypes/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<List<DomainTypeImpl>> addDomainTypesWithHttpInfo(List<AddDomainTypeRequest> var1);

    @RequestLine(value="PATCH /domainTypes/{domainTypeId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public DomainTypeImpl changeDomainType(@Param(value="domainTypeId") UUID var1, ChangeDomainTypeRequest var2);

    @RequestLine(value="PATCH /domainTypes/{domainTypeId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<DomainTypeImpl> changeDomainTypeWithHttpInfo(@Param(value="domainTypeId") UUID var1, ChangeDomainTypeRequest var2);

    @RequestLine(value="PATCH /domainTypes/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public List<DomainTypeImpl> changeDomainTypes(List<ChangeDomainTypeRequest> var1);

    @RequestLine(value="PATCH /domainTypes/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<List<DomainTypeImpl>> changeDomainTypesWithHttpInfo(List<ChangeDomainTypeRequest> var1);

    @RequestLine(value="GET /domainTypes?offset={offset}&limit={limit}&countLimit={countLimit}&name={name}&nameMatchMode={nameMatchMode}&parentId={parentId}&excludeMeta={excludeMeta}&topLevel={topLevel}")
    @Headers(value={"Accept: application/json"})
    public DomainTypePagedResponse findDomainTypes(@Param(value="offset") Integer var1, @Param(value="limit") Integer var2, @Param(value="countLimit") Integer var3, @Param(value="name") String var4, @Param(value="nameMatchMode") String var5, @Param(value="parentId") UUID var6, @Param(value="excludeMeta") Boolean var7, @Param(value="topLevel") Boolean var8);

    @RequestLine(value="GET /domainTypes?offset={offset}&limit={limit}&countLimit={countLimit}&name={name}&nameMatchMode={nameMatchMode}&parentId={parentId}&excludeMeta={excludeMeta}&topLevel={topLevel}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DomainTypePagedResponse> findDomainTypesWithHttpInfo(@Param(value="offset") Integer var1, @Param(value="limit") Integer var2, @Param(value="countLimit") Integer var3, @Param(value="name") String var4, @Param(value="nameMatchMode") String var5, @Param(value="parentId") UUID var6, @Param(value="excludeMeta") Boolean var7, @Param(value="topLevel") Boolean var8);

    @RequestLine(value="GET /domainTypes?offset={offset}&limit={limit}&countLimit={countLimit}&name={name}&nameMatchMode={nameMatchMode}&parentId={parentId}&excludeMeta={excludeMeta}&topLevel={topLevel}")
    @Headers(value={"Accept: application/json"})
    public DomainTypePagedResponse findDomainTypes(@QueryMap(encoded=true) FindDomainTypesQueryParams var1);

    @RequestLine(value="GET /domainTypes?offset={offset}&limit={limit}&countLimit={countLimit}&name={name}&nameMatchMode={nameMatchMode}&parentId={parentId}&excludeMeta={excludeMeta}&topLevel={topLevel}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DomainTypePagedResponse> findDomainTypesWithHttpInfo(@QueryMap(encoded=true) FindDomainTypesQueryParams var1);

    @RequestLine(value="GET /domainTypes/{domainTypeId}/subTypes?domainTypeId={domainTypeId2}&includeParent={includeParent}")
    @Headers(value={"Accept: application/json"})
    public DomainTypePagedResponse findSubDomainTypes(@Param(value="domainTypeId") UUID var1, @Param(value="domainTypeId2") UUID var2, @Param(value="includeParent") Boolean var3);

    @RequestLine(value="GET /domainTypes/{domainTypeId}/subTypes?domainTypeId={domainTypeId2}&includeParent={includeParent}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DomainTypePagedResponse> findSubDomainTypesWithHttpInfo(@Param(value="domainTypeId") UUID var1, @Param(value="domainTypeId2") UUID var2, @Param(value="includeParent") Boolean var3);

    @RequestLine(value="GET /domainTypes/{domainTypeId}/subTypes?domainTypeId={domainTypeId2}&includeParent={includeParent}")
    @Headers(value={"Accept: application/json"})
    public DomainTypePagedResponse findSubDomainTypes(@Param(value="domainTypeId") UUID var1, @QueryMap(encoded=true) FindSubDomainTypesQueryParams var2);

    @RequestLine(value="GET /domainTypes/{domainTypeId}/subTypes?domainTypeId={domainTypeId2}&includeParent={includeParent}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DomainTypePagedResponse> findSubDomainTypesWithHttpInfo(@Param(value="domainTypeId") UUID var1, @QueryMap(encoded=true) FindSubDomainTypesQueryParams var2);

    @RequestLine(value="GET /domainTypes/{domainTypeId}")
    @Headers(value={"Accept: application/json"})
    public DomainTypeImpl getDomainType(@Param(value="domainTypeId") UUID var1);

    @RequestLine(value="GET /domainTypes/{domainTypeId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<DomainTypeImpl> getDomainTypeWithHttpInfo(@Param(value="domainTypeId") UUID var1);

    @RequestLine(value="DELETE /domainTypes/{domainTypeId}")
    @Headers(value={"Accept: application/json"})
    public void removeDomainType(@Param(value="domainTypeId") UUID var1);

    @RequestLine(value="DELETE /domainTypes/{domainTypeId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> removeDomainTypeWithHttpInfo(@Param(value="domainTypeId") UUID var1);

    @RequestLine(value="DELETE /domainTypes/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void removeDomainTypes(List<UUID> var1);

    @RequestLine(value="DELETE /domainTypes/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Void> removeDomainTypesWithHttpInfo(List<UUID> var1);

    public static class FindSubDomainTypesQueryParams
    extends HashMap<String, Object> {
        public FindSubDomainTypesQueryParams domainTypeId2(UUID value) {
            this.put("domainTypeId", EncodingUtils.encode(value));
            return this;
        }

        public FindSubDomainTypesQueryParams includeParent(Boolean value) {
            this.put("includeParent", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class FindDomainTypesQueryParams
    extends HashMap<String, Object> {
        public FindDomainTypesQueryParams offset(Integer value) {
            this.put("offset", EncodingUtils.encode(value));
            return this;
        }

        public FindDomainTypesQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public FindDomainTypesQueryParams countLimit(Integer value) {
            this.put("countLimit", EncodingUtils.encode(value));
            return this;
        }

        public FindDomainTypesQueryParams name(String value) {
            this.put("name", EncodingUtils.encode(value));
            return this;
        }

        public FindDomainTypesQueryParams nameMatchMode(String value) {
            this.put("nameMatchMode", EncodingUtils.encode(value));
            return this;
        }

        public FindDomainTypesQueryParams parentId(UUID value) {
            this.put("parentId", EncodingUtils.encode(value));
            return this;
        }

        public FindDomainTypesQueryParams excludeMeta(Boolean value) {
            this.put("excludeMeta", EncodingUtils.encode(value));
            return this;
        }

        public FindDomainTypesQueryParams topLevel(Boolean value) {
            this.put("topLevel", EncodingUtils.encode(value));
            return this;
        }
    }
}

