/*
 * Decompiled with CFR 0.152.
 */
package com.collibra.core.rest.client.api;

import com.collibra.core.rest.client.invoker.ApiClient;
import com.collibra.core.rest.client.invoker.EncodingUtils;
import com.collibra.core.rest.client.model.AddComplexRelationRequest;
import com.collibra.core.rest.client.model.ApiResponse;
import com.collibra.core.rest.client.model.ChangeComplexRelationRequest;
import com.collibra.core.rest.client.model.ComplexRelationImpl;
import com.collibra.core.rest.client.model.ComplexRelationPagedResponse;
import com.collibra.core.rest.client.model.ExportComplexRelationsToCSVRequest;
import com.collibra.core.rest.client.model.ExportComplexRelationsToExcelRequest;
import com.collibra.core.rest.client.model.FileInfoImpl;
import com.collibra.core.rest.client.model.Job;
import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.UUID;

public interface ComplexRelationsApi
extends ApiClient.Api {
    @RequestLine(value="POST /complexRelations")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ComplexRelationImpl addComplexRelation(AddComplexRelationRequest var1);

    @RequestLine(value="POST /complexRelations")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ComplexRelationImpl> addComplexRelationWithHttpInfo(AddComplexRelationRequest var1);

    @RequestLine(value="PATCH /complexRelations/{complexRelationId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ComplexRelationImpl changeComplexRelation(@Param(value="complexRelationId") UUID var1, ChangeComplexRelationRequest var2);

    @RequestLine(value="PATCH /complexRelations/{complexRelationId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ComplexRelationImpl> changeComplexRelationWithHttpInfo(@Param(value="complexRelationId") UUID var1, ChangeComplexRelationRequest var2);

    @RequestLine(value="POST /complexRelations/export/csv-job")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Job exportToCSV(ExportComplexRelationsToCSVRequest var1);

    @RequestLine(value="POST /complexRelations/export/csv-job")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Job> exportToCSVWithHttpInfo(ExportComplexRelationsToCSVRequest var1);

    @RequestLine(value="POST /complexRelations/export/csv")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public String exportToCSVAsString(ExportComplexRelationsToCSVRequest var1);

    @RequestLine(value="POST /complexRelations/export/csv")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<String> exportToCSVAsStringWithHttpInfo(ExportComplexRelationsToCSVRequest var1);

    @RequestLine(value="POST /complexRelations/export/csv-file")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public FileInfoImpl exportToCSVWithoutJob(ExportComplexRelationsToCSVRequest var1);

    @RequestLine(value="POST /complexRelations/export/csv-file")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<FileInfoImpl> exportToCSVWithoutJobWithHttpInfo(ExportComplexRelationsToCSVRequest var1);

    @RequestLine(value="POST /complexRelations/export/excel-job")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Job exportToEXCEL(ExportComplexRelationsToExcelRequest var1);

    @RequestLine(value="POST /complexRelations/export/excel-job")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Job> exportToEXCELWithHttpInfo(ExportComplexRelationsToExcelRequest var1);

    @RequestLine(value="POST /complexRelations/export/excel-file")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public FileInfoImpl exportToEXCELWithoutJob(ExportComplexRelationsToExcelRequest var1);

    @RequestLine(value="POST /complexRelations/export/excel-file")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<FileInfoImpl> exportToEXCELWithoutJobWithHttpInfo(ExportComplexRelationsToExcelRequest var1);

    @RequestLine(value="GET /complexRelations?offset={offset}&limit={limit}&countLimit={countLimit}&cursor={cursor}&assetId={assetId}&typeId={typeId}")
    @Headers(value={"Accept: application/json"})
    public ComplexRelationPagedResponse findComplexRelations(@Param(value="offset") Integer var1, @Param(value="limit") Integer var2, @Param(value="countLimit") Integer var3, @Param(value="cursor") String var4, @Param(value="assetId") UUID var5, @Param(value="typeId") UUID var6);

    @RequestLine(value="GET /complexRelations?offset={offset}&limit={limit}&countLimit={countLimit}&cursor={cursor}&assetId={assetId}&typeId={typeId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ComplexRelationPagedResponse> findComplexRelationsWithHttpInfo(@Param(value="offset") Integer var1, @Param(value="limit") Integer var2, @Param(value="countLimit") Integer var3, @Param(value="cursor") String var4, @Param(value="assetId") UUID var5, @Param(value="typeId") UUID var6);

    @RequestLine(value="GET /complexRelations?offset={offset}&limit={limit}&countLimit={countLimit}&cursor={cursor}&assetId={assetId}&typeId={typeId}")
    @Headers(value={"Accept: application/json"})
    public ComplexRelationPagedResponse findComplexRelations(@QueryMap(encoded=true) FindComplexRelationsQueryParams var1);

    @RequestLine(value="GET /complexRelations?offset={offset}&limit={limit}&countLimit={countLimit}&cursor={cursor}&assetId={assetId}&typeId={typeId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ComplexRelationPagedResponse> findComplexRelationsWithHttpInfo(@QueryMap(encoded=true) FindComplexRelationsQueryParams var1);

    @RequestLine(value="GET /complexRelations/{complexRelationId}")
    @Headers(value={"Accept: application/json"})
    public ComplexRelationImpl getComplexRelation(@Param(value="complexRelationId") UUID var1);

    @RequestLine(value="GET /complexRelations/{complexRelationId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ComplexRelationImpl> getComplexRelationWithHttpInfo(@Param(value="complexRelationId") UUID var1);

    @RequestLine(value="DELETE /complexRelations/{complexRelationId}")
    @Headers(value={"Accept: application/json"})
    public void removeComplexRelation(@Param(value="complexRelationId") UUID var1);

    @RequestLine(value="DELETE /complexRelations/{complexRelationId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> removeComplexRelationWithHttpInfo(@Param(value="complexRelationId") UUID var1);

    public static class FindComplexRelationsQueryParams
    extends HashMap<String, Object> {
        public FindComplexRelationsQueryParams offset(Integer value) {
            this.put("offset", EncodingUtils.encode(value));
            return this;
        }

        public FindComplexRelationsQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public FindComplexRelationsQueryParams countLimit(Integer value) {
            this.put("countLimit", EncodingUtils.encode(value));
            return this;
        }

        public FindComplexRelationsQueryParams cursor(String value) {
            this.put("cursor", EncodingUtils.encode(value));
            return this;
        }

        public FindComplexRelationsQueryParams assetId(UUID value) {
            this.put("assetId", EncodingUtils.encode(value));
            return this;
        }

        public FindComplexRelationsQueryParams typeId(UUID value) {
            this.put("typeId", EncodingUtils.encode(value));
            return this;
        }
    }
}

