/*
 * Decompiled with CFR 0.152.
 */
package com.collibra.core.rest.client.api;

import com.collibra.core.rest.client.invoker.ApiClient;
import com.collibra.core.rest.client.invoker.EncodingUtils;
import com.collibra.core.rest.client.model.AddCommunityRequest;
import com.collibra.core.rest.client.model.ApiResponse;
import com.collibra.core.rest.client.model.ChangeCommunityRequest;
import com.collibra.core.rest.client.model.CommunityImpl;
import com.collibra.core.rest.client.model.CommunityPagedResponse;
import com.collibra.core.rest.client.model.Job;
import com.collibra.core.rest.client.model.NamedResourceReferenceImpl;
import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

public interface CommunitiesApi
extends ApiClient.Api {
    @RequestLine(value="POST /communities/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public List<CommunityImpl> addCommunities(List<AddCommunityRequest> var1);

    @RequestLine(value="POST /communities/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<List<CommunityImpl>> addCommunitiesWithHttpInfo(List<AddCommunityRequest> var1);

    @RequestLine(value="POST /communities")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public CommunityImpl addCommunity(AddCommunityRequest var1);

    @RequestLine(value="POST /communities")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<CommunityImpl> addCommunityWithHttpInfo(AddCommunityRequest var1);

    @RequestLine(value="PATCH /communities/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public List<CommunityImpl> changeCommunities(List<ChangeCommunityRequest> var1);

    @RequestLine(value="PATCH /communities/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<List<CommunityImpl>> changeCommunitiesWithHttpInfo(List<ChangeCommunityRequest> var1);

    @RequestLine(value="PATCH /communities/{communityId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public CommunityImpl changeCommunity(@Param(value="communityId") UUID var1, ChangeCommunityRequest var2);

    @RequestLine(value="PATCH /communities/{communityId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<CommunityImpl> changeCommunityWithHttpInfo(@Param(value="communityId") UUID var1, ChangeCommunityRequest var2);

    @RequestLine(value="POST /communities/{communityId}/root")
    @Headers(value={"Accept: application/json"})
    public CommunityImpl changeToRootCommunity(@Param(value="communityId") UUID var1);

    @RequestLine(value="POST /communities/{communityId}/root")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<CommunityImpl> changeToRootCommunityWithHttpInfo(@Param(value="communityId") UUID var1);

    @RequestLine(value="GET /communities?offset={offset}&limit={limit}&countLimit={countLimit}&cursor={cursor}&name={name}&nameMatchMode={nameMatchMode}&parentId={parentId}&excludeMeta={excludeMeta}&sortField={sortField}&sortOrder={sortOrder}")
    @Headers(value={"Accept: application/json"})
    public CommunityPagedResponse findCommunities(@Param(value="sortField") String var1, @Param(value="offset") Integer var2, @Param(value="limit") Integer var3, @Param(value="countLimit") Integer var4, @Param(value="cursor") String var5, @Param(value="name") String var6, @Param(value="nameMatchMode") String var7, @Param(value="parentId") UUID var8, @Param(value="excludeMeta") Boolean var9, @Param(value="sortOrder") String var10);

    @RequestLine(value="GET /communities?offset={offset}&limit={limit}&countLimit={countLimit}&cursor={cursor}&name={name}&nameMatchMode={nameMatchMode}&parentId={parentId}&excludeMeta={excludeMeta}&sortField={sortField}&sortOrder={sortOrder}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<CommunityPagedResponse> findCommunitiesWithHttpInfo(@Param(value="sortField") String var1, @Param(value="offset") Integer var2, @Param(value="limit") Integer var3, @Param(value="countLimit") Integer var4, @Param(value="cursor") String var5, @Param(value="name") String var6, @Param(value="nameMatchMode") String var7, @Param(value="parentId") UUID var8, @Param(value="excludeMeta") Boolean var9, @Param(value="sortOrder") String var10);

    @RequestLine(value="GET /communities?offset={offset}&limit={limit}&countLimit={countLimit}&cursor={cursor}&name={name}&nameMatchMode={nameMatchMode}&parentId={parentId}&excludeMeta={excludeMeta}&sortField={sortField}&sortOrder={sortOrder}")
    @Headers(value={"Accept: application/json"})
    public CommunityPagedResponse findCommunities(@QueryMap(encoded=true) FindCommunitiesQueryParams var1);

    @RequestLine(value="GET /communities?offset={offset}&limit={limit}&countLimit={countLimit}&cursor={cursor}&name={name}&nameMatchMode={nameMatchMode}&parentId={parentId}&excludeMeta={excludeMeta}&sortField={sortField}&sortOrder={sortOrder}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<CommunityPagedResponse> findCommunitiesWithHttpInfo(@QueryMap(encoded=true) FindCommunitiesQueryParams var1);

    @RequestLine(value="GET /communities/{communityId}")
    @Headers(value={"Accept: application/json"})
    public CommunityImpl getCommunity(@Param(value="communityId") UUID var1);

    @RequestLine(value="GET /communities/{communityId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<CommunityImpl> getCommunityWithHttpInfo(@Param(value="communityId") UUID var1);

    @RequestLine(value="GET /communities/{communityId}/breadcrumb")
    @Headers(value={"Accept: application/json"})
    public List<NamedResourceReferenceImpl> getCommunityBreadcrumb(@Param(value="communityId") String var1);

    @RequestLine(value="GET /communities/{communityId}/breadcrumb")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<List<NamedResourceReferenceImpl>> getCommunityBreadcrumbWithHttpInfo(@Param(value="communityId") String var1);

    @Deprecated
    @RequestLine(value="DELETE /communities/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void removeCommunities(List<UUID> var1);

    @Deprecated
    @RequestLine(value="DELETE /communities/bulk")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Void> removeCommunitiesWithHttpInfo(List<UUID> var1);

    @RequestLine(value="POST /communities/removalJobs")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Job removeCommunitiesInJob(List<UUID> var1);

    @RequestLine(value="POST /communities/removalJobs")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Job> removeCommunitiesInJobWithHttpInfo(List<UUID> var1);

    @Deprecated
    @RequestLine(value="DELETE /communities/{communityId}")
    @Headers(value={"Accept: application/json"})
    public void removeCommunity(@Param(value="communityId") UUID var1);

    @Deprecated
    @RequestLine(value="DELETE /communities/{communityId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> removeCommunityWithHttpInfo(@Param(value="communityId") UUID var1);

    public static class FindCommunitiesQueryParams
    extends HashMap<String, Object> {
        public FindCommunitiesQueryParams offset(Integer value) {
            this.put("offset", EncodingUtils.encode(value));
            return this;
        }

        public FindCommunitiesQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public FindCommunitiesQueryParams countLimit(Integer value) {
            this.put("countLimit", EncodingUtils.encode(value));
            return this;
        }

        public FindCommunitiesQueryParams cursor(String value) {
            this.put("cursor", EncodingUtils.encode(value));
            return this;
        }

        public FindCommunitiesQueryParams name(String value) {
            this.put("name", EncodingUtils.encode(value));
            return this;
        }

        public FindCommunitiesQueryParams nameMatchMode(String value) {
            this.put("nameMatchMode", EncodingUtils.encode(value));
            return this;
        }

        public FindCommunitiesQueryParams parentId(UUID value) {
            this.put("parentId", EncodingUtils.encode(value));
            return this;
        }

        public FindCommunitiesQueryParams excludeMeta(Boolean value) {
            this.put("excludeMeta", EncodingUtils.encode(value));
            return this;
        }

        public FindCommunitiesQueryParams sortField(String value) {
            this.put("sortField", EncodingUtils.encode(value));
            return this;
        }

        public FindCommunitiesQueryParams sortOrder(String value) {
            this.put("sortOrder", EncodingUtils.encode(value));
            return this;
        }
    }
}

